/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.TimeScheduler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;

public class VIEW_SYNC
extends Protocol {
    Address local_addr = null;
    final Vector mbrs = new Vector();
    View my_view = null;
    ViewId my_vid = null;
    long avg_send_interval = 60000L;
    private int num_views_sent = 0;
    private int num_views_adjusted = 0;
    volatile ViewSendTask view_send_task = null;
    final Object view_send_task_mutex = new Object();
    TimeScheduler timer = null;
    static final String name = "VIEW_SYNC";
    static boolean VERBOSE = Boolean.getBoolean("VS.VERBOSE");
    private volatile TimeScheduler.Task sendTask;
    private boolean splitBrainDetectionEnabled;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 9;
    }

    public long getAverageSendInterval() {
        return this.avg_send_interval;
    }

    public void setAverageSendInterval(long gossip_interval) {
        this.avg_send_interval = gossip_interval;
    }

    public int getNumViewsSent() {
        return this.num_views_sent;
    }

    public int getNumViewsAdjusted() {
        return this.num_views_adjusted;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_views_sent = 0;
        this.num_views_adjusted = 0;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("avg_send_interval");
        if (str != null) {
            this.avg_send_interval = Long.parseLong(str);
            props.remove("avg_send_interval");
        }
        if ((str = props.getProperty("split-brain-detection")) != null) {
            this.splitBrainDetectionEnabled = Boolean.valueOf(str);
            props.remove("split-brain-detection");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.VIEW_SYNC_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void start() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    @Override
    public void stop() {
        this.stopViewSender();
    }

    public void sendViewRequest() {
        Message msg = new Message(null, null, null);
        ViewSyncHeader hdr = new ViewSyncHeader(2);
        msg.putHeader(name, hdr);
        this.passDown(new Event(1, msg));
    }

    @Override
    public void up(Event evt) {
        int type = evt.getType();
        switch (type) {
            case 1: {
                Message msg = (Message)evt.getArg();
                ViewSyncHeader hdr = (ViewSyncHeader)msg.removeHeader(name);
                if (hdr == null) break;
                Address sender = msg.getSrc();
                switch (hdr.type) {
                    case 1: {
                        View v = (View)msg.getObject();
                        if (VERBOSE) {
                            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "Received view sync from " + sender + ": " + v);
                        }
                        this.handleView(v, sender);
                        break;
                    }
                    case 2: {
                        if (sender.equals(this.local_addr)) break;
                        this.sendView(sender);
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error(JGroupsStrings.VIEW_SYNC_VIEWSYNCHEADER_TYPE__0__NOT_KNOWN, hdr.type);
                    }
                }
                return;
            }
            case 6: {
                View view = (View)evt.getArg();
                this.handleViewChange(view);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1006: {
                Address mbr = (Address)evt.getArg();
                this.sendView(mbr);
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View v = (View)evt.getArg();
                this.handleViewChange(v);
            }
        }
        this.passDown(evt);
    }

    private void handleView(View v, final Address sender) {
        TimeScheduler.Task oldTask;
        if (this.stack.getChannel().closing()) {
            return;
        }
        Vector members = v.getMembers();
        final ViewId vid = v.getVid();
        int rc = vid.compareTo(this.my_vid);
        if (rc > 0) {
            if (VERBOSE || this.log.isTraceEnabled()) {
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "view from " + sender + " (" + vid + ") is greater than my own view (" + this.my_vid + ");" + " will update my own view");
            }
            Message view_change = new Message(this.local_addr, this.local_addr, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(5);
            view_change.putHeader("GMS", hdr);
            view_change.setObject(v);
            this.passUp(new Event(1, view_change));
            ++this.num_views_adjusted;
        } else if (sender != null && rc < 0 && this.splitBrainDetectionEnabled && ((oldTask = this.sendTask) == null || oldTask.cancelled())) {
            TimeScheduler.Task newTask;
            this.sendTask = newTask = new TimeScheduler.Task(){
                volatile boolean hasRun;

                @Override
                public boolean cancelled() {
                    return this.hasRun;
                }

                @Override
                public long nextInterval() {
                    return 0L;
                }

                @Override
                public void run() {
                    this.hasRun = true;
                    if (VERBOSE || VIEW_SYNC.this.log.isTraceEnabled()) {
                        VIEW_SYNC.this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "view from " + sender + " (" + vid + ") is older than my own view (" + VIEW_SYNC.this.my_vid + ").  Sending my view to it");
                    }
                    VIEW_SYNC.this.sendView(sender);
                }
            };
            this.stack.timer.add(newTask);
        }
    }

    private void handleViewChange(View view) {
        Vector tmp = view.getMembers();
        if (tmp != null) {
            this.mbrs.clear();
            this.mbrs.addAll(tmp);
        }
        this.my_view = (View)view.clone();
        this.my_vid = this.my_view.getVid();
        if (!(this.my_view.size() <= 1 || this.view_send_task != null && this.view_send_task.running())) {
            this.startViewSender();
        }
    }

    protected void sendView() {
        this.sendView(null);
    }

    protected void sendView(Address oldViewSender) {
        View tmp = (View)(this.my_view != null ? this.my_view.clone() : null);
        if (tmp == null) {
            return;
        }
        ViewSyncHeader hdr = new ViewSyncHeader(1);
        if (oldViewSender == null) {
            Message msg = new Message(null, null, null);
            msg.isHighPriority = true;
            msg.putHeader(name, hdr);
            msg.putHeader("NO_UCAST", new ViewSyncHeader(1));
            msg.setObject(tmp);
            this.passDown(new Event(1, msg));
        } else {
            Message msg = new Message(oldViewSender, null, null);
            msg.putHeader(name, hdr);
            msg.putHeader("NO_UCAST", new ViewSyncHeader(1));
            msg.setObject(tmp);
            this.passDown(new Event(1, msg));
        }
        ++this.num_views_sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startViewSender() {
        if (this.view_send_task != null) {
            return;
        }
        Object object = this.view_send_task_mutex;
        synchronized (object) {
            if (this.view_send_task != null && this.view_send_task.running()) {
                return;
            }
            this.view_send_task = new ViewSendTask();
            this.timer.add(this.view_send_task, true);
        }
        if (trace) {
            this.log.trace("view send task started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopViewSender() {
        Object object = this.view_send_task_mutex;
        synchronized (object) {
            if (this.view_send_task != null) {
                this.view_send_task.stop();
                if (trace) {
                    this.log.trace("view send task stopped");
                }
                this.view_send_task = null;
            }
        }
    }

    protected class ViewSendTask
    implements TimeScheduler.Task {
        boolean stopped = false;

        protected ViewSendTask() {
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean running() {
            return !this.stopped;
        }

        @Override
        public boolean cancelled() {
            return this.stopped;
        }

        @Override
        public long nextInterval() {
            long interval = this.computeSleepTime();
            if (interval <= 0L) {
                return 10000L;
            }
            return interval;
        }

        @Override
        public void run() {
            VIEW_SYNC.this.sendView();
        }

        long computeSleepTime() {
            int num_mbrs = Math.max(VIEW_SYNC.this.mbrs.size(), 1);
            return this.getRandom((long)num_mbrs * VIEW_SYNC.this.avg_send_interval * 2L);
        }

        long getRandom(long range) {
            return (long)(Math.random() * (double)range % (double)range);
        }
    }

    public static class ViewSyncHeader
    extends Header
    implements Streamable {
        public static final int VIEW_SYNC = 1;
        public static final int VIEW_SYNC_REQ = 2;
        int type = 0;

        public ViewSyncHeader() {
        }

        public ViewSyncHeader(int type) {
            this.type = type;
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return com.gemstone.org.jgroups.protocols.VIEW_SYNC.name;
                }
                case 2: {
                    return "VIEW_SYNC_REQ";
                }
            }
            return "<unknown>";
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(ViewSyncHeader.type2String(this.type));
            sb.append("]");
            return sb.toString();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }

        @Override
        public long size(short version) {
            long retval = 5L;
            return retval;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.type);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readInt();
        }
    }
}

