/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.Discovery;
import com.gemstone.org.jgroups.protocols.PingHeader;
import com.gemstone.org.jgroups.protocols.WanPipeAddress;
import com.gemstone.org.jgroups.util.List;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

public class WANPING
extends Discovery {
    List initial_hosts = null;

    @Override
    public String getName() {
        return "WANPING";
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("port_range");
        if (str != null) {
            props.remove("port_range");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.WANPING_INITIAL_HOSTS__0, this.initial_hosts);
            }
        }
        if (this.initial_hosts == null || this.initial_hosts.size() == 0) {
            this.log.error("WANPING.setProperties(): hosts to contact for initial membership not specified. Cannot determine coordinator !");
            return false;
        }
        return super.setProperties(props);
    }

    @Override
    public void sendGetMembersRequest(AtomicBoolean waiter_sync) {
        PingHeader hdr = new PingHeader(1, null);
        Message msg = new Message(null, null, null);
        msg.putHeader(this.getName(), hdr);
        this.wakeWaiter(waiter_sync);
        Enumeration en = this.initial_hosts.elements();
        while (en.hasMoreElements()) {
            String h = (String)en.nextElement();
            Message copy = msg.copy();
            copy.setDest(new WanPipeAddress(h));
            this.passDown(new Event(1, copy));
        }
    }

    private List createInitialHosts(String l) {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                tmp.add(t.trim());
            }
            catch (NumberFormatException e) {
                this.log.error(JGroupsStrings.WANPING_WANPINGCREATEINITIALHOSTS__0, (Throwable)e);
            }
        }
        return tmp;
    }
}

