/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.oswego.concurrent.ConcurrentReaderHashMap;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Streamable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;

public class Digest
implements Externalizable,
Streamable,
DataSerializable {
    Map senders = null;
    protected static final GemFireTracer log = GemFireTracer.getLog(Digest.class);
    static final boolean warn = log.isWarnEnabled();

    public Digest() {
    }

    public Digest(int size2) {
        this.senders = this.createSenders(size2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Digest)) {
            return false;
        }
        Digest other = (Digest)obj;
        if (this.senders == null && other.senders == null) {
            return true;
        }
        if (this.senders == null) {
            return false;
        }
        return this.senders.equals(other.senders);
    }

    public int hashCode() {
        int result = 0;
        if (this.senders != null) {
            result += this.senders.hashCode();
        }
        return result;
    }

    public void add(Address sender, long low_seqno, long high_seqno) {
        this.add(sender, low_seqno, high_seqno, -1L);
    }

    public void add(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        this.add(sender, new Entry(low_seqno, high_seqno, high_seqno_seen));
    }

    private void add(Address sender, Entry entry) {
        if (sender == null || entry == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.Digest_SENDER__0__OR_ENTRY__1_IS_NULL_WILL_NOT_ADD_ENTRY, new Object[]{sender, entry});
            }
            return;
        }
        Entry retval = this.senders.put(sender, entry);
        if (retval != null && warn) {
            log.warn("entry for " + sender + " was overwritten with " + entry);
        }
    }

    public void add(Digest d) {
        if (d != null) {
            for (Map.Entry entry : d.senders.entrySet()) {
                Address key2 = (Address)entry.getKey();
                Entry val = (Entry)entry.getValue();
                this.add(key2, val.low_seqno, val.high_seqno, val.high_seqno_seen);
            }
        }
    }

    public void replace(Digest d) {
        if (d != null) {
            this.clear();
            for (Map.Entry entry : d.senders.entrySet()) {
                Address key2 = (Address)entry.getKey();
                Entry val = (Entry)entry.getValue();
                this.add(key2, val.low_seqno, val.high_seqno, val.high_seqno_seen);
            }
        }
    }

    public Entry get(Address sender) {
        return (Entry)this.senders.get(sender);
    }

    public boolean set(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return false;
        }
        entry.low_seqno = low_seqno;
        entry.high_seqno = high_seqno;
        entry.high_seqno_seen = high_seqno_seen;
        return true;
    }

    public void merge(Digest d) {
        if (d == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.Digest_DIGEST_TO_BE_MERGED_WITH_IS_NULL);
            }
            return;
        }
        for (Map.Entry entry : d.senders.entrySet()) {
            Address sender = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            if (val == null) continue;
            this.merge(sender, val.low_seqno, val.high_seqno, val.high_seqno_seen);
        }
    }

    public void merge(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        if (sender == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.Digest_SENDER__NULL);
            }
            return;
        }
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            this.add(sender, low_seqno, high_seqno, high_seqno_seen);
        } else {
            if (low_seqno < entry.low_seqno) {
                entry.low_seqno = low_seqno;
            }
            if (high_seqno > entry.high_seqno) {
                entry.high_seqno = high_seqno;
            }
            if (high_seqno_seen > entry.high_seqno_seen) {
                entry.high_seqno_seen = high_seqno_seen;
            }
        }
    }

    public boolean contains(Address sender) {
        return this.senders.containsKey(sender);
    }

    public boolean sameSenders(Digest other) {
        if (other == null) {
            return false;
        }
        if (this.senders == null || other.senders == null) {
            return false;
        }
        if (this.senders.size() != other.senders.size()) {
            return false;
        }
        Set my_senders = this.senders.keySet();
        Set other_senders = other.senders.keySet();
        return my_senders.equals(other_senders);
    }

    public void incrementHighSeqno(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return;
        }
        ++entry.high_seqno;
    }

    public int size() {
        return this.senders.size();
    }

    public void resetAt(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry != null) {
            entry.reset();
        }
    }

    public void clear() {
        this.senders.clear();
    }

    public long lowSeqnoAt(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.low_seqno;
    }

    public long highSeqnoAt(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.high_seqno;
    }

    public long highSeqnoSeenAt(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.high_seqno_seen;
    }

    public void setHighSeqnoAt(Address sender, long high_seqno) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry != null) {
            entry.high_seqno = high_seqno;
        }
    }

    public void setHighSeqnoSeenAt(Address sender, long high_seqno_seen) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry != null) {
            entry.high_seqno_seen = high_seqno_seen;
        }
    }

    public void setHighestDeliveredAndSeenSeqnos(Address sender, long high_seqno, long high_seqno_seen) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry != null) {
            entry.high_seqno = high_seqno;
            entry.high_seqno_seen = high_seqno_seen;
        }
    }

    public Digest copy() {
        Digest ret = new Digest(this.senders.size());
        for (Map.Entry entry : this.senders.entrySet()) {
            Entry tmp = (Entry)entry.getValue();
            ret.add((Address)entry.getKey(), tmp.low_seqno, tmp.high_seqno, tmp.high_seqno_seen);
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (this.senders == null) {
            return "[]";
        }
        for (Map.Entry entry : this.senders.entrySet()) {
            Address key2 = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key2).append(": ").append('[').append(val.low_seqno).append(" : ");
            sb.append(val.high_seqno);
            if (val.high_seqno_seen >= 0L) {
                sb.append(" (").append(val.high_seqno_seen).append(")");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String printHighSeqnos() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Map.Entry entry : this.senders.entrySet()) {
            Address key2 = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                sb.append('[');
                first = false;
            }
            sb.append(key2).append("#").append(val.high_seqno);
        }
        sb.append(']');
        return sb.toString();
    }

    public String printHighSeqnosSeen() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Map.Entry entry : this.senders.entrySet()) {
            Address key2 = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                sb.append('[');
                first = false;
            }
            sb.append(key2).append("#").append(val.high_seqno_seen);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.senders);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.senders = (Map)in.readObject();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        this.toData(out);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeShort(this.senders.size());
        for (Map.Entry entry : this.senders.entrySet()) {
            Address key2 = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            DataSerializer.writeObject(key2, out);
            out.writeLong(val.low_seqno);
            out.writeLong(val.high_seqno);
            out.writeLong(val.high_seqno_seen);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        try {
            this.fromData(in);
        }
        catch (ClassNotFoundException e) {
            InstantiationException ex = new InstantiationException("Unable to instantiate during deserialization");
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readShort();
        this.senders = this.createSenders(size2);
        for (int i = 0; i < size2; ++i) {
            Address key2 = (Address)DataSerializer.readObject(in);
            this.add(key2, in.readLong(), in.readLong(), in.readLong());
        }
    }

    public long serializedSize(short version) {
        long retval = 2L;
        if (this.senders.size() > 0) {
            Address addr = (Address)this.senders.keySet().iterator().next();
            int len = addr.size(version) + 2;
            retval += (long)((len += 24) * this.senders.size());
        }
        return retval;
    }

    private Map createSenders(int size2) {
        return new ConcurrentReaderHashMap(size2);
    }

    public static class Entry {
        public long low_seqno;
        public long high_seqno;
        public long high_seqno_seen = -1L;

        public Entry(long low_seqno, long high_seqno, long high_seqno_seen) {
            this.low_seqno = low_seqno;
            this.high_seqno = high_seqno;
            this.high_seqno_seen = high_seqno_seen;
        }

        public Entry(long low_seqno, long high_seqno) {
            this.low_seqno = low_seqno;
            this.high_seqno = high_seqno;
        }

        public Entry(Entry other) {
            if (other != null) {
                this.low_seqno = other.low_seqno;
                this.high_seqno = other.high_seqno;
                this.high_seqno_seen = other.high_seqno_seen;
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.low_seqno == other.low_seqno && this.high_seqno == other.high_seqno && this.high_seqno_seen == other.high_seqno_seen;
        }

        public int hashCode() {
            int result = 0;
            result = (int)((long)result + this.low_seqno);
            result = (int)((long)result + this.high_seqno);
            result = (int)((long)result + this.high_seqno_seen);
            return result;
        }

        public String toString() {
            return new StringBuffer("low=").append(this.low_seqno).append(", high=").append(this.high_seqno).append(", highest seen=").append(this.high_seqno_seen).toString();
        }

        public void reset() {
            this.high_seqno = 0L;
            this.low_seqno = 0L;
            this.high_seqno_seen = -1L;
        }
    }
}

