/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Membership;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.protocols.pbcast.JoinRsp;
import com.gemstone.org.jgroups.protocols.pbcast.MergeData;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.util.List;
import java.util.Vector;

public abstract class GmsImpl {
    protected GMS gms = null;
    protected final GemFireTracer log;
    final boolean trace;
    final boolean warn;
    volatile boolean leaving = false;

    protected GmsImpl() {
        this.log = null;
        this.warn = false;
        this.trace = false;
    }

    protected GmsImpl(GMS gms) {
        this.gms = gms;
        this.log = gms.getLog();
        this.trace = this.log.isTraceEnabled();
        this.warn = this.log.isWarnEnabled();
    }

    public abstract boolean join(Address var1);

    public abstract void leave(Address var1);

    public abstract void handleJoinResponse(JoinRsp var1);

    public abstract void handleLeaveResponse(String var1);

    public abstract void unsuspect(Address var1);

    public void merge(Vector other_coords) {
    }

    public void handleMergeRequest(Address sender, ViewId merge_id) {
    }

    public void handleMergeResponse(MergeData data, ViewId merge_id) {
    }

    public void handleMergeView(MergeData data, ViewId merge_id) {
    }

    public void handleMergeCancelled(ViewId merge_id) {
    }

    public abstract void handleJoinsAndLeaves(List var1, List var2, List var3, List var4, boolean var5);

    public void handleGetViewResponse(JoinRsp rsp) {
    }

    public abstract void handleJoin(Address var1);

    public abstract void handleAlreadyJoined(Address var1);

    public abstract void handleLeave(List var1, boolean var2, List var3, boolean var4);

    public abstract void handleViewChange(View var1, Digest var2);

    public void handleExit() {
    }

    public boolean handleUpEvent(Event evt) {
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        return true;
    }

    public void init() throws Exception {
        this.leaving = false;
    }

    public void start() throws Exception {
        this.leaving = false;
    }

    public void stop() {
        this.leaving = true;
    }

    protected void sendMergeRejectedResponse(Address sender, ViewId merge_id) {
        Message msg = new Message(sender, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_rejected = true;
        hdr.merge_id = merge_id;
        msg.putHeader(this.gms.getName(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("response=" + hdr);
        }
        this.gms.passDown(new Event(1, msg));
    }

    protected void wrongMethod(String method_name) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(method_name + "() should not be invoked on an instance of " + this.getClass().getName());
        }
    }

    protected boolean iWouldBeCoordinator(Vector new_mbrs) {
        Membership tmp_mbrs = this.gms.members.copy();
        tmp_mbrs.merge(new_mbrs, null);
        tmp_mbrs.sort();
        if (tmp_mbrs.size() <= 0 || this.gms.local_addr == null) {
            return false;
        }
        return this.gms.local_addr.equals(tmp_mbrs.elementAt(0));
    }
}

