/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.protocols.pbcast.NakAckHeader;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.NakReceiverWindow;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.Retransmitter;
import com.gemstone.org.jgroups.util.BoundedList;
import com.gemstone.org.jgroups.util.Buffer;
import com.gemstone.org.jgroups.util.Range;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class NAKACK
extends Protocol
implements Retransmitter.RetransmitCommand,
NakReceiverWindow.Listener {
    private long[] retransmit_timeout = new long[]{600L, 1200L, 2400L, 4800L};
    private volatile boolean is_server = false;
    private Address local_addr = null;
    private final Vector members = new Vector(11);
    private ViewId viewId;
    private long seqno = 0L;
    private long max_xmit_size = 8192L;
    private int gc_lag = 20;
    private long max_xmit_burst = 0L;
    private boolean use_mcast_xmit = false;
    private boolean xmit_from_random_member = false;
    private boolean discard_delivered_msgs = false;
    private int max_xmit_buf_size = 0;
    private final HashMap received_msgs = new HashMap(11);
    private long received_msgs_size = 0L;
    private final TreeMap sent_msgs = new TreeMap();
    private boolean leaving = false;
    private TimeScheduler timer = null;
    private static final String name = "NAKACK";
    private long xmit_reqs_received;
    private long xmit_reqs_sent;
    private long xmit_rsps_received;
    private long xmit_rsps_sent;
    private long missing_msgs_received;
    private HashMap sent = new HashMap();
    private HashMap received = new HashMap();
    private int stats_list_size = 20;
    private BoundedList receive_history;
    private BoundedList send_history;
    long max_sent_msgs_size = 100000L;
    private final Object deliverySync = new Object();

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 3;
    }

    public long getXmitRequestsReceived() {
        return this.xmit_reqs_received;
    }

    public long getXmitRequestsSent() {
        return this.xmit_reqs_sent;
    }

    public long getXmitResponsesReceived() {
        return this.xmit_rsps_received;
    }

    public long getXmitResponsesSent() {
        return this.xmit_rsps_sent;
    }

    public long getMissingMessagesReceived() {
        return this.missing_msgs_received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingRetransmissionRequests() {
        int num = 0;
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            for (NakReceiverWindow win : this.received_msgs.values()) {
                num += win.size();
            }
        }
        return num;
    }

    public int getSentTableSize() {
        return this.sent_msgs.size();
    }

    public int getReceivedTableSize() {
        int ret = 0;
        LinkedHashSet s = new LinkedHashSet(this.received_msgs.values());
        for (NakReceiverWindow win : s) {
            ret += win.size();
        }
        return ret;
    }

    @Override
    public void resetStats() {
        this.missing_msgs_received = 0L;
        this.xmit_rsps_sent = 0L;
        this.xmit_rsps_received = 0L;
        this.xmit_reqs_sent = 0L;
        this.xmit_reqs_received = 0L;
        this.sent.clear();
        this.received.clear();
        if (this.receive_history != null) {
            this.receive_history.removeAll();
        }
        if (this.send_history != null) {
            this.send_history.removeAll();
        }
    }

    @Override
    public void init() throws Exception {
        if (this.stats) {
            this.send_history = new BoundedList(this.stats_list_size);
            this.receive_history = new BoundedList(this.stats_list_size);
        }
    }

    public int getGcLag() {
        return this.gc_lag;
    }

    public void setGcLag(int gc_lag) {
        this.gc_lag = gc_lag;
    }

    public boolean isUseMcastXmit() {
        return this.use_mcast_xmit;
    }

    public void setUseMcastXmit(boolean use_mcast_xmit) {
        this.use_mcast_xmit = use_mcast_xmit;
    }

    public boolean isXmitFromRandomMember() {
        return this.xmit_from_random_member;
    }

    public void setXmitFromRandomMember(boolean xmit_from_random_member) {
        this.xmit_from_random_member = xmit_from_random_member;
    }

    public boolean isDiscardDeliveredMsgs() {
        return this.discard_delivered_msgs;
    }

    public void setDiscardDeliveredMsgs(boolean discard_delivered_msgs) {
        this.discard_delivered_msgs = discard_delivered_msgs;
    }

    public int getMaxXmitBufSize() {
        return this.max_xmit_buf_size;
    }

    public void setMaxXmitBufSize(int max_xmit_buf_size) {
        this.max_xmit_buf_size = max_xmit_buf_size;
    }

    public long getMaxXmitSize() {
        return this.max_xmit_size;
    }

    public void setMaxXmitSize(long max_xmit_size) {
        this.max_xmit_size = max_xmit_size;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeout = tmp;
            }
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = Integer.parseInt(str);
            if (this.gc_lag < 0) {
                this.log.error(JGroupsStrings.NAKACK_NAKACKSETPROPERTIES_GC_LAG_CANNOT_BE_NEGATIVE_SETTING_IT_TO_0);
            }
            props.remove("gc_lag");
        }
        if ((str = props.getProperty("max_xmit_size")) != null) {
            this.max_xmit_size = Long.parseLong(str);
            props.remove("max_xmit_size");
        }
        if ((str = props.getProperty("max_xmit_burst")) != null) {
            this.max_xmit_burst = Long.parseLong(str);
            props.remove("max_xmit_burst");
        }
        if ((str = props.getProperty("use_mcast_xmit")) != null) {
            this.use_mcast_xmit = Boolean.valueOf(str);
            props.remove("use_mcast_xmit");
        }
        if ((str = props.getProperty("discard_delivered_msgs")) != null) {
            this.discard_delivered_msgs = Boolean.valueOf(str);
            props.remove("discard_delivered_msgs");
        }
        if ((str = props.getProperty("xmit_from_random_member")) != null) {
            this.xmit_from_random_member = Boolean.valueOf(str);
            props.remove("xmit_from_random_member");
        }
        if ((str = props.getProperty("max_xmit_buf_size")) != null) {
            this.max_xmit_buf_size = Integer.parseInt(str);
            props.remove("max_xmit_buf_size");
        }
        if ((str = props.getProperty("stats_list_size")) != null) {
            this.stats_list_size = Integer.parseInt(str);
            props.remove("stats_list_size");
        }
        if ((str = props.getProperty("max_sent_msgs_size")) != null) {
            this.max_sent_msgs_size = Long.parseLong(str);
            props.remove("max_sent_msgs_size");
        }
        if (this.xmit_from_random_member && this.discard_delivered_msgs) {
            this.discard_delivered_msgs = false;
            this.log.warn("xmit_from_random_member set to true: changed discard_delivered_msgs to false");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.NAKACK_NAKACKSETPROPERTIES_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map dumpStats() {
        HashMap<String, Long> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, Long>();
        }
        retval.put("xmit_reqs_received", this.xmit_reqs_received);
        retval.put("xmit_reqs_sent", this.xmit_reqs_sent);
        retval.put("xmit_rsps_received", this.xmit_rsps_received);
        retval.put("xmit_rsps_sent", this.xmit_rsps_sent);
        retval.put("missing_msgs_received", this.missing_msgs_received);
        retval.put("sent_msgs", (Long)((Object)this.printSentMsgs()));
        StringBuffer sb = new StringBuffer();
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            for (Map.Entry entry : this.received_msgs.entrySet()) {
                Address addr = (Address)entry.getKey();
                Object w = entry.getValue();
                sb.append(addr).append(": ").append(w.toString()).append('\n');
            }
        }
        retval.put("received_msgs", (Long)((Object)sb.toString()));
        return retval;
    }

    @Override
    public String printStats() {
        Object val;
        Object key2;
        StringBuffer sb = new StringBuffer();
        sb.append("sent:\n");
        for (Map.Entry entry : this.sent.entrySet()) {
            key2 = entry.getKey();
            if (key2 == null) {
                key2 = "<mcast dest>";
            }
            val = entry.getValue();
            sb.append(key2).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        for (Map.Entry entry : this.received.entrySet()) {
            key2 = entry.getKey();
            val = entry.getValue();
            sb.append(key2).append(": ").append(val).append("\n");
        }
        sb.append("\nXMIT_REQS sent:\n");
        Enumeration en = this.send_history.elements();
        while (en.hasMoreElements()) {
            XmitRequest tmp = (XmitRequest)en.nextElement();
            sb.append(tmp).append("\n");
        }
        sb.append("\nMissing messages received\n");
        Enumeration en2 = this.receive_history.elements();
        while (en2.hasMoreElements()) {
            MissingMessage missing = (MissingMessage)en2.nextElement();
            sb.append(missing).append("\n");
        }
        return sb.toString();
    }

    @Override
    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>(5);
        retval.addElement(39);
        retval.addElement(57);
        retval.addElement(42);
        retval.addElement(41);
        retval.addElement(53);
        return retval;
    }

    @Override
    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>(2);
        retval.addElement(39);
        retval.addElement(57);
        return retval;
    }

    @Override
    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("NAKACK.up(): timer is null");
        }
    }

    @Override
    public void stop() {
        this.removeAll();
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null && !dest.isMulticastAddress()) break;
                this.send(evt, msg);
                return;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigest();
                this.passUp(new Event(40, digest != null ? digest.copy() : null));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passUp(new Event(58, digest != null ? digest.copy() : null));
                return;
            }
            case 42: {
                Digest digest = this.getDigest();
                this.passUp(new Event(43, digest != null ? digest.copy() : null));
                return;
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return;
            }
            case 56: {
                this.passDown(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 15: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                this.adjustReceivers();
                break;
            }
            case 6: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                this.viewId = ((View)evt.getArg()).getVid();
                this.adjustReceivers();
                this.is_server = true;
                LinkedHashSet<Object> tmp = new LinkedHashSet<Object>(this.members);
                tmp.add(null);
                this.sent.keySet().retainAll(tmp);
                this.received.keySet().retainAll(tmp);
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 4: {
                this.leaving = true;
                this.removeAll();
                this.seqno = 0L;
            }
        }
        this.passDown(evt);
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                NakAckHeader hdr = (NakAckHeader)msg.getHeader(name);
                if (hdr == null) break;
                boolean isServer = this.is_server;
                if (!isServer || !this.isMember(msg.getSrc())) {
                    GMS.GmsHeader ghdr = (GMS.GmsHeader)msg.getHeader("GMS");
                    if (ghdr != null && ghdr.type == 5) {
                        this.stack.findProtocol("GMS").up(evt);
                    } else if (trace) {
                        this.log.trace("message was discarded (not yet server)");
                    }
                    if (!isServer) {
                        return;
                    }
                }
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.NAKACK_XMIT_REQ_RANGE_OF_XMIT_MSG_IS_NULL_DISCARDING_REQUEST_FROM__0, msg.getSrc());
                            }
                            return;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high, hdr.sender);
                        return;
                    }
                    case 3: {
                        if (trace) {
                            this.log.trace("received missing messages " + hdr.range);
                        }
                        this.handleXmitRsp(msg);
                        return;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.NAKACK_NAKACK_HEADER_TYPE__0__NOT_KNOWN_, hdr.type);
                }
                return;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(40, digest));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(58, digest));
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 56: {
                this.passUp(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    private boolean isMember(Address addr) {
        if (!this.members.contains(addr) && this.viewId != null) {
            return (long)addr.getBirthViewId() > this.viewId.getId();
        }
        return true;
    }

    private synchronized long getNextSeqno() {
        return this.seqno++;
    }

    public long getCurrentSeqno() {
        return this.seqno - 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Event evt, Message msg) {
        NAKACK nAKACK = this;
        synchronized (nAKACK) {
            long msg_id = this.getNextSeqno();
            if (trace) {
                this.log.trace("sending msg #" + msg_id);
            }
            msg.putHeader(name, new NakAckHeader(1, msg_id));
            TreeMap treeMap = this.sent_msgs;
            synchronized (treeMap) {
                this.sent_msgs.put(msg_id, msg);
                if (this.max_sent_msgs_size > 0L && (long)this.sent_msgs.size() > this.max_sent_msgs_size) {
                    try {
                        this.sent_msgs.wait(1L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (this.stack.gemfireStats != null) {
                        this.stack.gemfireStats.incJgNAKACKwaits(1L);
                    }
                }
                if (this.stack.gemfireStats != null) {
                    this.stack.gemfireStats.setJgSTABLEsentMessagesSize(this.sent_msgs.size());
                }
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Message msg, NakAckHeader hdr) {
        NakReceiverWindow win;
        Serializable sb;
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("sender of message is null: " + msg.toString(), (Throwable)new Exception("Stack trace - please send to GemStone customer support and reference bug #36611"));
            }
            return;
        }
        if (trace) {
            sb = new StringBuffer(91);
            ((StringBuffer)sb).append(this.local_addr).append("] received ").append(sender).append('#').append(hdr.seqno);
            this.log.trace(((StringBuffer)sb).toString());
        }
        sb = this.received_msgs;
        synchronized (sb) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.leaving) {
                return;
            }
            if (this.warn) {
                sb = new StringBuffer(91);
                ((StringBuffer)sb).append(this.local_addr).append("] discarded message from non-member ").append(sender);
                if (this.warn) {
                    this.log.warn(((StringBuffer)sb).toString());
                }
            }
            return;
        }
        Object object = this.deliverySync;
        synchronized (object) {
            Message msg_to_deliver;
            win.add(hdr.seqno, msg);
            while ((msg_to_deliver = win.remove()) != null) {
                if (trace) {
                    this.log.trace("NAKACK dispatching " + msg_to_deliver);
                }
                this.passUp(new Event(1, msg_to_deliver));
            }
        }
    }

    public boolean testRetransmitLargeMessage(byte[] bytesToSend) {
        IpAddress myAddress = (IpAddress)this.local_addr;
        int myPort = myAddress.getPort();
        Message msg = new Message(new IpAddress(myAddress.getIpAddress(), myPort - 1), this.local_addr, bytesToSend, 0, bytesToSend.length);
        msg.putHeader(name, new NakAckHeader(3, 0L, 0L));
        try {
            this.passDown(new Event(1, msg));
        }
        catch (RetransmissionTooLargeException e) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleXmitReq(Address xmit_requester, long first_seqno, long last_seqno, Address original_sender) {
        boolean amISender;
        long size2 = 0L;
        long marker = first_seqno;
        long burstSize = 0L;
        NakReceiverWindow win = null;
        Vector vector = this.members;
        synchronized (vector) {
            if (!this.isMember(xmit_requester)) {
                if (trace) {
                    this.log.trace("Ignoring xmit request from " + xmit_requester + " who is not in membership");
                }
                return;
            }
        }
        if (trace) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.local_addr).append(": received xmit request from ").append(xmit_requester).append(" for ");
            sb.append(original_sender).append(" [").append(first_seqno).append(" - ").append(last_seqno).append("]");
            this.log.trace(sb.toString());
        }
        if (first_seqno > last_seqno) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.NAKACK_FIRST_SEQNO__0___LAST_SEQNO__1__NOT_ABLE_TO_RETRANSMIT, new Object[]{first_seqno, last_seqno});
            }
            return;
        }
        if (this.stats) {
            this.xmit_reqs_received += last_seqno - first_seqno + 1L;
            NAKACK.updateStats(this.received, xmit_requester, 1, 0, 0);
        }
        if (!(amISender = this.local_addr.equals(original_sender))) {
            win = (NakReceiverWindow)this.received_msgs.get(original_sender);
        }
        LinkedList<Message> list = new LinkedList<Message>();
        for (long i = first_seqno; i <= last_seqno && (this.max_xmit_burst <= 0L || burstSize <= this.max_xmit_burst); ++i) {
            Message tmp;
            Message m;
            if (amISender) {
                m = (Message)this.sent_msgs.get(i);
            } else {
                Message message = m = win != null ? win.get(i) : null;
            }
            if (m == null) {
                InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                if (system != null && system.isDisconnecting()) {
                    return;
                }
                if (this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().fine("Retransmission request received from " + xmit_requester + " for a message that has already been discarded");
                }
                m = new Message();
                m.setDest(xmit_requester);
                m.setSrc(this.local_addr);
                NakAckHeader hdr = new NakAckHeader(1, i);
                m.putHeader(name, hdr);
            }
            long len = m.size();
            burstSize += len;
            if ((size2 += len) > this.max_xmit_size && list.size() > 0) {
                if (trace) {
                    this.log.trace("xmitting msgs [" + marker + '-' + (i - 1L) + "] to " + xmit_requester);
                }
                this.sendXmitRsp(xmit_requester, (LinkedList)list.clone(), marker, i - 1L);
                marker = i;
                list.clear();
                size2 = len;
                burstSize = len;
            }
            if ((tmp = m).getSrc() == null) {
                tmp.setSrc(this.local_addr);
            }
            list.add(tmp);
        }
        if (list.size() > 0) {
            if (trace) {
                this.log.trace("xmitting msgs [" + marker + '-' + last_seqno + "] to " + xmit_requester);
            }
            this.sendXmitRsp(xmit_requester, (LinkedList)list.clone(), marker, last_seqno);
            list.clear();
        }
    }

    private static void updateStats(HashMap map, Address key2, int req, int rsp, int missing) {
        Entry entry = (Entry)map.get(key2);
        if (entry == null) {
            entry = new Entry();
            map.put(key2, entry);
        }
        entry.xmit_reqs += (long)req;
        entry.xmit_rsps += (long)rsp;
        entry.missing_msgs_rcvd += (long)missing;
    }

    private void sendXmitRsp(Address dest, LinkedList xmit_list, long first_seqno, long last_seqno) {
        if (xmit_list == null || xmit_list.size() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.NAKACK_XMIT_LIST_IS_EMPTY);
            }
            return;
        }
        if (this.use_mcast_xmit) {
            dest = null;
        }
        if (this.stats) {
            this.xmit_rsps_sent += (long)xmit_list.size();
            NAKACK.updateStats(this.sent, dest, 0, 1, 0);
        }
        try {
            Buffer buf = Util.msgListToByteBuffer(xmit_list, dest);
            Message msg = new Message(dest, null, buf.getBuf(), buf.getOffset(), buf.getLength());
            msg.putHeader(name, new NakAckHeader(3, first_seqno, last_seqno));
            this.passDown(new Event(1, msg));
            if (this.stack.gemfireStats != null) {
                this.stack.gemfireStats.incMcastRetransmits();
            }
        }
        catch (RetransmissionTooLargeException e) {
            for (Message xmitMsg : xmit_list) {
                NakAckHeader xmitHdr = (NakAckHeader)xmitMsg.getHeader(name);
                long seqno = xmitHdr.seqno;
                try {
                    Buffer buf = Util.msgListToByteBuffer(Collections.singletonList(xmitMsg), null);
                    Message msg = new Message(dest, null, buf.getBuf(), buf.getOffset(), buf.getLength());
                    msg.putHeader(name, new NakAckHeader(3, seqno, seqno));
                    this.passDown(new Event(1, msg));
                    if (this.stack.gemfireStats == null) continue;
                    this.stack.gemfireStats.incMcastRetransmits();
                }
                catch (IOException ex) {
                    this.log.error(JGroupsStrings.NAKACK_FAILED_MARSHALLING_XMIT_LIST, (Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            this.log.error(JGroupsStrings.NAKACK_FAILED_MARSHALLING_XMIT_LIST, (Throwable)ex);
        }
    }

    public static boolean isRetransmission(Message msg) {
        NakAckHeader hdr = (NakAckHeader)msg.getHeader(name);
        return hdr != null && hdr.type == 3;
    }

    private void handleXmitRsp(Message msg) {
        block8: {
            if (msg == null) {
                if (this.warn) {
                    this.log.warn("message is null");
                }
                return;
            }
            try {
                LinkedList list = Util.byteBufferToMessageList(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                if (list != null) {
                    if (this.stats) {
                        this.xmit_rsps_received += (long)list.size();
                        NAKACK.updateStats(this.received, msg.getSrc(), 0, 1, 0);
                    }
                    for (Message m : list) {
                        this.up(new Event(1, m));
                    }
                    list.clear();
                }
            }
            catch (CancelException e) {
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error("Exception caught while processing a message from " + msg.getSrc(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustReceivers() {
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            NakReceiverWindow win;
            Address sender;
            this.received_msgs_size = 0L;
            Iterator it = this.received_msgs.keySet().iterator();
            while (it.hasNext()) {
                sender = (Address)it.next();
                if (!this.isMember(sender)) {
                    win = (NakReceiverWindow)this.received_msgs.get(sender);
                    win.reset();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("removing " + sender + " from received_msgs (not member anymore)");
                    }
                    it.remove();
                    continue;
                }
                if (this.stack.gemfireStats == null) continue;
                win = (NakReceiverWindow)this.received_msgs.get(sender);
                this.received_msgs_size += (long)win.unsafeGetSize();
                this.stack.gemfireStats.setJgSTABLEreceivedMessagesSize(this.received_msgs_size);
            }
            for (int i = 0; i < this.members.size(); ++i) {
                sender = (Address)this.members.elementAt(i);
                if (this.received_msgs.containsKey(sender)) continue;
                win = this.createNakReceiverWindow(sender, 0L);
                this.received_msgs.put(sender, win);
            }
            if (this.stack.gemfireStats != null) {
                this.stack.gemfireStats.setJgSTABLEreceivedMessagesSize(this.received_msgs_size);
            }
        }
    }

    private Digest getDigest() {
        Digest digest = new Digest(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, false);
            if (range == null) {
                if (!this.log.isErrorEnabled() || this.stack.getChannel().closing()) continue;
                this.log.error(JGroupsStrings.NAKACK_RANGE_IS_NULL);
                continue;
            }
            digest.add(sender, range.low, range.high);
        }
        return digest;
    }

    private Digest getDigestHighestDeliveredMsgs() {
        Digest digest = new Digest(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, true);
            if (range == null) {
                if (!this.log.isErrorEnabled() || this.stack.getChannel().closing()) continue;
                this.log.error(JGroupsStrings.NAKACK_RANGE_IS_NULL_2);
                continue;
            }
            long high_seqno_seen = this.getHighSeqnoSeen(sender);
            digest.add(sender, range.low, range.high, high_seqno_seen);
        }
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDigest(Digest d) {
        if (d == null || d.senders == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.NAKACK_DIGEST_OR_DIGESTSENDERS_IS_NULL);
            }
            return;
        }
        if (trace) {
            this.log.trace("installing NAKACK digest " + d);
        }
        this.clear();
        for (Map.Entry entry : d.senders.entrySet()) {
            Address sender = (Address)entry.getKey();
            Digest.Entry val = (Digest.Entry)entry.getValue();
            if (sender == null || val == null) {
                if (!this.warn) continue;
                this.log.warn("sender or value is null");
                continue;
            }
            long initial_seqno = val.high_seqno;
            NakReceiverWindow win = this.createNakReceiverWindow(sender, initial_seqno);
            HashMap hashMap = this.received_msgs;
            synchronized (hashMap) {
                this.received_msgs.put(sender, win);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeDigest(Digest d) {
        if (d == null || d.senders == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.NAKACK_DIGEST_OR_DIGESTSENDERS_IS_NULL);
            }
            return;
        }
        for (Map.Entry entry : d.senders.entrySet()) {
            Address sender = (Address)entry.getKey();
            Digest.Entry val = (Digest.Entry)entry.getValue();
            if (sender == null || val == null) {
                if (!this.warn) continue;
                this.log.warn("sender or value is null");
                continue;
            }
            long initial_seqno = val.high_seqno;
            HashMap hashMap = this.received_msgs;
            synchronized (hashMap) {
                NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (win == null) {
                    win = this.createNakReceiverWindow(sender, initial_seqno);
                } else if (win.getHighestReceived() < initial_seqno) {
                    this.received_msgs_size -= (long)win.unsafeGetSize();
                    this.stack.gemfireStats.setJgSTABLEreceivedMessagesSize(this.received_msgs_size);
                    win.reset();
                    this.received_msgs.remove(sender);
                    win = this.createNakReceiverWindow(sender, initial_seqno);
                    this.received_msgs.put(sender, win);
                }
                if (this.stack.gemfireStats != null) {
                    this.stack.gemfireStats.setJgSTABLEreceivedMessagesSize(this.received_msgs_size);
                }
            }
        }
    }

    private NakReceiverWindow createNakReceiverWindow(Address sender, long initial_seqno) {
        NakReceiverWindow win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
        win.setRetransmitTimeouts(this.retransmit_timeout);
        win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
        win.setMaxXmitBufSize(this.max_xmit_buf_size);
        if (this.stats) {
            win.setListener(this);
        }
        return win;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range getLowestAndHighestSeqno(Address sender, boolean stop_at_gaps) {
        NakReceiverWindow win;
        Range r = null;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.NAKACK_SENDER_IS_NULL);
            }
            return r;
        }
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.log.isErrorEnabled() && !this.stack.getChannel().closing()) {
                this.log.error(JGroupsStrings.NAKACK_SENDER__0__NOT_FOUND_IN_RECEIVED_MSGS, sender);
            }
            return r;
        }
        r = stop_at_gaps ? new Range(win.getLowestSeen(), win.getHighestSeen()) : new Range(win.getLowestSeen(), win.getHighestReceived() + 1L);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getHighSeqnoSeen(Address sender) {
        NakReceiverWindow win;
        long ret = 0L;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.NAKACK_SENDER_IS_NULL);
            }
            return ret;
        }
        if (sender.equals(this.local_addr)) {
            return this.seqno - 1L;
        }
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            return ret;
        }
        ret = win.getHighestReceived();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighSeqnoDispatched(Address sender) {
        NakReceiverWindow win;
        long ret = 0L;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.NAKACK_SENDER_IS_NULL);
            }
            return ret;
        }
        if (sender.equals(this.local_addr)) {
            return this.seqno - 1L;
        }
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.log.isErrorEnabled() && !this.stack.getChannel().closing()) {
                this.log.error(JGroupsStrings.NAKACK_SENDER__0__NOT_FOUND_IN_RECEIVED_MSGS_2, sender);
            }
            return ret;
        }
        ret = win.getHighestSeen();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stable(Digest d) {
        if (this.members == null || this.local_addr == null || d == null) {
            if (this.warn) {
                this.log.warn("members, local_addr or digest are null !");
            }
            return;
        }
        if (trace) {
            this.log.trace("received stable digest " + d);
        }
        for (Map.Entry entry : d.senders.entrySet()) {
            NakReceiverWindow recv_win;
            Address sender = (Address)entry.getKey();
            if (sender == null) continue;
            Digest.Entry val = (Digest.Entry)entry.getValue();
            long high_seqno_delivered = val.high_seqno;
            long high_seqno_received = val.high_seqno_seen;
            AbstractMap abstractMap = this.received_msgs;
            synchronized (abstractMap) {
                recv_win = (NakReceiverWindow)this.received_msgs.get(sender);
            }
            if (recv_win != null) {
                long my_highest_rcvd = recv_win.getHighestReceived();
                long stability_highest_rcvd = high_seqno_received;
                if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                    if (trace) {
                        this.log.trace("my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + sender + '#' + stability_highest_rcvd);
                    }
                    this.retransmit(stability_highest_rcvd, stability_highest_rcvd, sender);
                }
            }
            if ((high_seqno_delivered -= (long)this.gc_lag) < 0L) continue;
            if (trace) {
                this.log.trace("deleting msgs <= " + high_seqno_delivered + " from " + sender);
            }
            if (sender.equals(this.local_addr)) {
                abstractMap = this.sent_msgs;
                synchronized (abstractMap) {
                    SortedMap stable_keys = this.sent_msgs.headMap(high_seqno_delivered);
                    if (stable_keys != null) {
                        stable_keys.clear();
                        this.sent_msgs.notifyAll();
                        if (this.stack.gemfireStats != null) {
                            this.stack.gemfireStats.setJgSTABLEsentMessagesSize(this.sent_msgs.size());
                        }
                    }
                }
            }
            if (recv_win == null) continue;
            recv_win.stable(high_seqno_delivered);
        }
    }

    @Override
    public Address getDest() {
        return null;
    }

    @Override
    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        Address random_member;
        Address dest = sender;
        if (this.xmit_from_random_member && !this.local_addr.equals(sender) && (random_member = (Address)Util.pickRandomElement(this.members)) != null && !this.local_addr.equals(random_member)) {
            dest = random_member;
            if (trace) {
                this.log.trace("picked random member " + dest + " to send XMIT request to");
            }
        }
        NakAckHeader hdr = new NakAckHeader(2, first_seqno, last_seqno, sender);
        Message retransmit_msg = new Message(dest, null, null);
        if (trace) {
            this.log.trace(this.local_addr + ": sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + dest);
        }
        retransmit_msg.putHeader(name, hdr);
        this.passDown(new Event(1, retransmit_msg));
        if (this.stack.gemfireStats != null) {
            this.stack.gemfireStats.incMcastRetransmitRequests();
        }
        if (this.stats) {
            this.xmit_reqs_sent += last_seqno - first_seqno + 1L;
            NAKACK.updateStats(this.sent, dest, 1, 0, 0);
            for (long i = first_seqno; i <= last_seqno; ++i) {
                XmitRequest req = new XmitRequest(sender, i, dest);
                this.send_history.add(req);
            }
        }
    }

    @Override
    public void missingMessageReceived(long mseqno, Message msg) {
        if (this.stats) {
            ++this.missing_msgs_received;
            NAKACK.updateStats(this.received, msg.getSrc(), 0, 0, 1);
            MissingMessage missing = new MissingMessage(msg.getSrc(), mseqno);
            this.receive_history.add(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            for (NakReceiverWindow win : this.received_msgs.values()) {
                win.reset();
            }
            this.received_msgs.clear();
            this.received_msgs_size = 0L;
            if (this.stack.gemfireStats != null) {
                this.stack.gemfireStats.setJgSTABLEreceivedMessagesSize(this.received_msgs_size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAll() {
        AbstractMap abstractMap = this.sent_msgs;
        synchronized (abstractMap) {
            this.sent_msgs.clear();
            if (this.stack.gemfireStats != null) {
                this.stack.gemfireStats.setJgSTABLEsentMessagesSize(this.sent_msgs.size());
            }
        }
        abstractMap = this.received_msgs;
        synchronized (abstractMap) {
            for (NakReceiverWindow win : this.received_msgs.values()) {
                win.destroy();
            }
            this.received_msgs.clear();
            this.received_msgs_size = 0L;
            if (this.stack.gemfireStats != null) {
                this.stack.gemfireStats.setJgSTABLEreceivedMessagesSize(this.received_msgs_size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printMessages() {
        StringBuffer ret = new StringBuffer();
        ret.append("\nsent_msgs: ").append(this.printSentMsgs());
        ret.append("\nreceived_msgs:\n");
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            for (Map.Entry entry : this.received_msgs.entrySet()) {
                Address addr = (Address)entry.getKey();
                Object w = entry.getValue();
                ret.append(addr).append(": ").append(w.toString()).append('\n');
            }
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printSentMsgs() {
        Long max_seqno;
        Long min_seqno;
        StringBuffer sb = new StringBuffer();
        TreeMap treeMap = this.sent_msgs;
        synchronized (treeMap) {
            min_seqno = this.sent_msgs.size() > 0 ? (Long)this.sent_msgs.firstKey() : Long.valueOf(0L);
            max_seqno = this.sent_msgs.size() > 0 ? (Long)this.sent_msgs.lastKey() : Long.valueOf(0L);
        }
        sb.append('[').append(min_seqno).append(" - ").append(max_seqno).append("] (" + this.sent_msgs.size() + ")");
        return sb.toString();
    }

    private void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.max_xmit_size = ((Integer)map.get("frag_size")).intValue();
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.NAKACK_MAX_XMIT_SIZE_0, this.max_xmit_size);
            }
        }
    }

    static class MissingMessage {
        Address original_sender;
        long seq;
        long timestamp = System.currentTimeMillis();

        MissingMessage(Address original_sender, long seqno) {
            this.original_sender = original_sender;
            this.seq = seqno;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(new Date(this.timestamp)).append(": ").append(this.original_sender).append(" #").append(this.seq);
            return sb.toString();
        }
    }

    static class XmitRequest {
        Address original_sender;
        long seq;
        long timestamp = System.currentTimeMillis();
        Address xmit_dest;

        XmitRequest(Address original_sender, long seqno, Address xmit_dest) {
            this.original_sender = original_sender;
            this.xmit_dest = xmit_dest;
            this.seq = seqno;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(new Date(this.timestamp)).append(": ").append(this.original_sender).append(" #").append(this.seq);
            sb.append(" (XMIT_REQ sent to ").append(this.xmit_dest).append(")");
            return sb.toString();
        }
    }

    static class Entry {
        long xmit_reqs;
        long xmit_rsps;
        long missing_msgs_rcvd;

        Entry() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.xmit_reqs).append(" xmit_reqs").append(", ").append(this.xmit_rsps).append(" xmit_rsps");
            sb.append(", ").append(this.missing_msgs_rcvd).append(" missing msgs");
            return sb.toString();
        }
    }

    public static class RetransmissionTooLargeException
    extends RuntimeException {
        public RetransmissionTooLargeException(String message) {
            super(message);
        }
    }
}

