/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.protocols.pbcast.Gossip;
import com.gemstone.org.jgroups.protocols.pbcast.PbcastHeader;
import com.gemstone.org.jgroups.stack.NakReceiverWindow;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.List;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;
import com.gemstone.org.jgroups.util.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PBCAST
extends Protocol
implements Runnable {
    boolean operational = false;
    long seqno = 1L;
    long gossip_round = 1L;
    Address local_addr = null;
    final Hashtable digest = new Hashtable();
    Thread gossip_thread = null;
    GossipHandler gossip_handler = null;
    final Queue gossip_queue = new Queue();
    int max_queue = 100;
    long gossip_interval = 5000L;
    double subset = 0.1;
    long desired_avg_gossip = 30000L;
    final Vector members = new Vector();
    final List gossip_list = new List();
    int max_gossip_cache = 100;
    int gc_lag = 30;
    final Hashtable invalid_gossipers = new Hashtable();
    static final int max_invalid_gossips = 2;
    Vector seen_list = null;
    boolean shun = false;
    boolean dynamic = true;
    volatile boolean skip_sleep = true;
    boolean mcast_gossip = true;

    @Override
    public String getName() {
        return "PBCAST";
    }

    @Override
    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(39);
        retval.addElement(41);
        retval.addElement(42);
        return retval;
    }

    @Override
    public void stop() {
        this.stopGossipThread();
        this.stopGossipHandler();
        this.operational = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void up(Event evt) {
        Address sender = null;
        switch (evt.getType()) {
            case 1: {
                Message m = (Message)evt.getArg();
                if (m.getDest() != null && !m.getDest().isMulticastAddress() && !(m.getHeader(this.getName()) instanceof PbcastHeader)) break;
                if (!this.operational) {
                    if (!this.log.isInfoEnabled()) return;
                    this.log.info("event was discarded as I'm not yet operational. Event: " + Util.printEvent(evt));
                    return;
                }
                if (!(m.getHeader(this.getName()) instanceof PbcastHeader)) {
                    sender = m.getSrc();
                    if (!this.log.isErrorEnabled()) break;
                    this.log.error("PbcastHeader expected, but received header of type " + m.getHeader(this.getName()).getClass().getName() + " from " + sender + ". Passing event up unchanged");
                    break;
                }
                PbcastHeader hdr = (PbcastHeader)m.removeHeader(this.getName());
                switch (hdr.type) {
                    case 0: {
                        this.handleUpMessage(m, hdr);
                        return;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        try {
                            if (this.gossip_queue.size() >= this.max_queue) {
                                if (!this.warn) return;
                                this.log.warn("gossip request " + PbcastHeader.type2String(hdr.type) + " discarded because " + "gossip_queue is full (number of elements=" + this.gossip_queue.size() + ')');
                                return;
                            }
                            this.gossip_queue.add(new GossipEntry(hdr, m.getSrc(), m.getBuffer()));
                            return;
                        }
                        catch (Exception ex) {
                            if (!this.warn) return;
                            this.log.warn("exception adding request to gossip_queue, details=" + ex);
                        }
                        return;
                    }
                }
                if (!this.log.isErrorEnabled()) return;
                this.log.error(JGroupsStrings.PBCAST_TYPE__0__OF_PBCASTHEADER_NOT_KNOWN_, hdr.type);
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message m = (Message)evt.getArg();
                if (m.getDest() != null && !m.getDest().isMulticastAddress()) break;
                PbcastHeader hdr = new PbcastHeader(0, this.seqno);
                m.putHeader(this.getName(), hdr);
                Hashtable hashtable = this.digest;
                synchronized (hashtable) {
                    NakReceiverWindow win = (NakReceiverWindow)this.digest.get(this.local_addr);
                    if (win == null) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("NakReceiverWindow for sender " + this.local_addr + " not found. Creating new NakReceiverWindow starting at seqno=" + this.seqno);
                        }
                        win = new NakReceiverWindow(this.local_addr, this.seqno);
                        this.digest.put(this.local_addr, win);
                    }
                    Message copy = m.copy();
                    copy.setSrc(this.local_addr);
                    win.add(this.seqno, copy);
                }
                ++this.seqno;
                break;
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return;
            }
            case 39: {
                this.passUp(new Event(40, this.getDigest()));
                return;
            }
            case 42: {
                this.passUp(new Event(43, this.getDigest()));
                return;
            }
            case 6: {
                Address key2;
                View v = (View)evt.getArg();
                if (v == null) {
                    if (!this.log.isErrorEnabled()) break;
                    this.log.error(JGroupsStrings.PBCAST_VIEW_IS_NULL_);
                    break;
                }
                Vector mbrs = v.getMembers();
                Cloneable cloneable = this.members;
                synchronized (cloneable) {
                    this.members.removeAllElements();
                    for (int i = 0; i < mbrs.size(); ++i) {
                        this.members.addElement(mbrs.elementAt(i));
                    }
                }
                if (mbrs.size() > 0) {
                    cloneable = this.digest;
                    synchronized (cloneable) {
                        Enumeration e = this.digest.keys();
                        while (e.hasMoreElements()) {
                            key2 = (Address)e.nextElement();
                            if (mbrs.contains(key2)) continue;
                            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(key2);
                            win.reset();
                            this.digest.remove(key2);
                        }
                    }
                }
                for (int i = 0; i < mbrs.size(); ++i) {
                    key2 = (Address)mbrs.elementAt(i);
                    if (this.digest.containsKey(key2)) continue;
                    this.digest.put(key2, new NakReceiverWindow(key2, 1L));
                }
                if (this.dynamic) {
                    this.gossip_interval = this.computeGossipInterval(this.members.size(), this.desired_avg_gossip);
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.PBCAST_VIEW_CHANGE_GOSSIP_INTERVAL_0, this.gossip_interval);
                    }
                    if (this.gossip_thread != null) {
                        this.skip_sleep = true;
                        this.gossip_thread.interrupt();
                    }
                }
                this.startGossipThread();
                this.startGossipHandler();
                break;
            }
            case 16: {
                this.operational = true;
            }
        }
        this.passDown(evt);
    }

    @Override
    public void run() {
        while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            if (this.dynamic) {
                this.gossip_interval = this.computeGossipInterval(this.members.size(), this.desired_avg_gossip);
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.PBCAST_GOSSIP_INTERVAL_0, this.gossip_interval);
                }
            }
            try {
                Util.sleep(this.gossip_interval);
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.skip_sleep) {
                this.skip_sleep = false;
                continue;
            }
            this.sendGossip();
        }
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("dynamic");
        if (str != null) {
            this.dynamic = Boolean.valueOf(str);
            props.remove("dynamic");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if ((str = props.getProperty("gossip_interval")) != null) {
            this.gossip_interval = Long.parseLong(str);
            props.remove("gossip_interval");
        }
        if ((str = props.getProperty("mcast_gossip")) != null) {
            this.mcast_gossip = Boolean.valueOf(str);
            props.remove("mcast_gossip");
        }
        if ((str = props.getProperty("subset")) != null) {
            this.subset = Double.parseDouble(str);
            props.remove("subset");
        }
        if ((str = props.getProperty("desired_avg_gossip")) != null) {
            this.desired_avg_gossip = Long.parseLong(str);
            props.remove("desired_avg_gossip");
        }
        if ((str = props.getProperty("max_queue")) != null) {
            this.max_queue = Integer.parseInt(str);
            props.remove("max_queue");
        }
        if ((str = props.getProperty("max_gossip_cache")) != null) {
            this.max_gossip_cache = Integer.parseInt(str);
            props.remove("max_gossip_cache");
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = Integer.parseInt(str);
            props.remove("gc_lag");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.PBCAST_PBCASTSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUpMessage(Message m, PbcastHeader hdr) {
        Address sender = m.getSrc();
        NakReceiverWindow win = null;
        long tmp_seqno = hdr.seqno;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.PBCAST_SENDER_IS_NULL);
            }
            return;
        }
        Hashtable hashtable = this.digest;
        synchronized (hashtable) {
            Message tmpmsg;
            win = (NakReceiverWindow)this.digest.get(sender);
            if (win == null) {
                if (this.warn) {
                    this.log.warn("NakReceiverWindow for sender " + sender + " not found. Creating new NakReceiverWindow starting at seqno=" + tmp_seqno);
                }
                win = new NakReceiverWindow(sender, tmp_seqno);
                this.digest.put(sender, win);
            }
            m.putHeader(this.getName(), hdr);
            win.add(tmp_seqno, m);
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.PBCAST_RECEIVER_WINDOW_FOR__0__IS__1, new Object[]{sender, win});
            }
            while ((tmpmsg = win.remove()) != null) {
                tmpmsg.removeHeader(this.getName());
                this.passUp(new Event(1, tmpmsg));
            }
            if (this.members.size() == 1 && (tmp_seqno = Math.max(tmp_seqno - (long)this.gc_lag, 0L)) > 0L) {
                if (trace) {
                    this.log.trace("deleting messages < " + tmp_seqno + " from " + sender);
                }
                win.stable(tmp_seqno);
            }
        }
    }

    Digest getDigest() {
        Digest ret = new Digest(this.digest.size());
        Enumeration e = this.digest.keys();
        while (e.hasMoreElements()) {
            Address key2 = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(key2);
            long lowest_seqno = win.getLowestSeen();
            long highest_seqno = win.getHighestSeen();
            ret.add(key2, lowest_seqno, highest_seqno);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.PBCAST_DIGEST_IS__0, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDigest(Digest d) {
        long tmp_seqno = 1L;
        Hashtable hashtable = this.digest;
        synchronized (hashtable) {
            Enumeration e = this.digest.elements();
            while (e.hasMoreElements()) {
                NakReceiverWindow win = (NakReceiverWindow)e.nextElement();
                win.reset();
            }
            this.digest.clear();
            for (Map.Entry entry : d.senders.entrySet()) {
                Address sender = (Address)entry.getKey();
                if (sender == null) {
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error(JGroupsStrings.PBCAST_CANNOT_SET_ITEM_BECAUSE_SENDER_IS_NULL);
                    continue;
                }
                Digest.Entry val = (Digest.Entry)entry.getValue();
                tmp_seqno = val.high_seqno;
                this.digest.put(sender, new NakReceiverWindow(sender, tmp_seqno + 1L));
            }
        }
    }

    String printDigest() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.digest.keys();
        while (e.hasMoreElements()) {
            Address key2 = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(key2);
            long highest_seqno = win.getHighestSeen();
            sb.append(key2 + ": " + highest_seqno + '\n');
        }
        return sb.toString();
    }

    String printIncomingMessageQueue() {
        StringBuffer sb = new StringBuffer();
        NakReceiverWindow win = (NakReceiverWindow)this.digest.get(this.local_addr);
        sb.append(win);
        return sb.toString();
    }

    synchronized void startGossipThread() {
        if (this.gossip_thread == null) {
            this.gossip_thread = new Thread(this);
            this.gossip_thread.setDaemon(true);
            this.gossip_thread.start();
        }
    }

    synchronized void stopGossipThread() {
        if (this.gossip_thread != null && this.gossip_thread.isAlive()) {
            Thread tmp = this.gossip_thread;
            this.gossip_thread = null;
            tmp.interrupt();
            Object var1_1 = null;
        }
    }

    void startGossipHandler() {
        if (this.gossip_handler == null) {
            this.gossip_handler = new GossipHandler(this.gossip_queue);
            this.gossip_handler.start();
        }
    }

    void stopGossipHandler() {
        if (this.gossip_handler != null) {
            this.gossip_handler.stop();
            this.gossip_handler = null;
        }
    }

    void sendGossip() {
        Vector current_mbrs = (Vector)this.members.clone();
        Vector subset_mbrs = null;
        Gossip gossip = null;
        if (this.local_addr != null) {
            current_mbrs.remove(this.local_addr);
        }
        if (this.mcast_gossip) {
            gossip = new Gossip(this.local_addr, this.gossip_round, this.getDigest().copy(), null);
            for (int i = 0; i < current_mbrs.size(); ++i) {
                gossip.addToSeenList((Address)current_mbrs.elementAt(i));
            }
            PbcastHeader hdr = new PbcastHeader(gossip, 1);
            Message msg = new Message();
            msg.putHeader(this.getName(), hdr);
            if (this.log.isInfoEnabled()) {
                this.log.info("(from " + this.local_addr + ") multicasting gossip " + gossip.shortForm() + " to all members");
            }
            this.passDown(new Event(1, msg));
        } else {
            subset_mbrs = Util.pickSubset(current_mbrs, this.subset);
            for (int i = 0; i < subset_mbrs.size(); ++i) {
                gossip = new Gossip(this.local_addr, this.gossip_round, this.getDigest().copy(), (Vector)current_mbrs.clone());
                gossip.addToSeenList(this.local_addr);
                PbcastHeader hdr = new PbcastHeader(gossip, 1);
                Address dest = (Address)subset_mbrs.elementAt(i);
                Message msg = new Message(dest, null, null);
                msg.putHeader(this.getName(), hdr);
                if (this.log.isInfoEnabled()) {
                    this.log.info("(from " + this.local_addr + ") sending gossip " + gossip.shortForm() + " to " + subset_mbrs);
                }
                this.passDown(new Event(1, msg));
            }
        }
        ++this.gossip_round;
    }

    void handleGossip(Gossip gossip) {
        Message msg;
        PbcastHeader hdr;
        long my_low = 0L;
        long my_high = 0L;
        Hashtable<Address, List> ht = null;
        if (trace) {
            this.log.trace("(from " + this.local_addr + ") received gossip " + gossip.shortForm() + " from " + gossip.sender);
        }
        if (gossip == null || gossip.digest == null) {
            if (this.warn) {
                this.log.warn("gossip is null or digest is null");
            }
            return;
        }
        if (gossip.sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("sender of gossip is null; don't know where to send XMIT_REQ to. Discarding gossip");
            }
            return;
        }
        if (!this.members.contains(gossip.sender)) {
            if (this.warn) {
                this.log.warn("sender " + gossip.sender + " is not a member. Gossip will not be processed");
            }
            if (this.shun) {
                this.shunInvalidGossiper(gossip.sender);
            }
            return;
        }
        while (this.gossip_list.size() >= this.max_gossip_cache) {
            this.gossip_list.removeFromHead();
        }
        if (this.gossip_list.contains(gossip)) {
            return;
        }
        this.gossip_list.add(gossip.copy());
        this.seen_list = gossip.getSeenList();
        if (this.seen_list.size() > 0) {
            this.passDown(new Event(50, this.seen_list.clone()));
        }
        Digest their_digest = gossip.digest;
        for (Map.Entry entry : their_digest.senders.entrySet()) {
            List missing_msgs;
            Address sender = (Address)entry.getKey();
            Digest.Entry val = (Digest.Entry)entry.getValue();
            long their_low = val.low_seqno;
            long their_high = val.high_seqno;
            if (their_low == 0L && their_high == 0L) continue;
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(sender);
            if (win == null) {
                if (!this.warn) continue;
                this.log.warn("sender " + sender + " not found, skipping...");
                continue;
            }
            my_low = win.getLowestSeen();
            my_high = win.getHighestSeen();
            if (my_high >= their_high || my_low + 1L < their_low || (missing_msgs = win.getMissingMessages(my_high, their_high)) == null) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("asking " + gossip.sender + " for retransmission of " + sender + ", missing messages: " + missing_msgs + "\nwin for " + sender + ":\n" + win + '\n');
            }
            if (ht == null) {
                ht = new Hashtable<Address, List>();
            }
            ht.put(sender, missing_msgs);
        }
        if (ht != null && ht.size() != 0) {
            hdr = new PbcastHeader(2);
            hdr.xmit_reqs = ht;
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.PBCAST_SENDING_XMIT_REQ_TO__0, gossip.sender);
            }
            msg = new Message(gossip.sender, null, null);
            msg.putHeader(this.getName(), hdr);
            this.passDown(new Event(1, msg));
        }
        gossip.removeFromNotSeenList(this.local_addr);
        if (gossip.sizeOfNotSeenList() == 0) {
            this.garbageCollect(gossip.digest);
            return;
        }
        Vector new_dests = Util.pickSubset(gossip.getNotSeenList(), this.subset);
        if (this.log.isInfoEnabled()) {
            this.log.info("(from " + this.local_addr + ") forwarding gossip " + gossip.shortForm() + " to " + new_dests);
        }
        gossip.addToSeenList(this.local_addr);
        for (int i = 0; i < new_dests.size(); ++i) {
            Address dest = (Address)new_dests.elementAt(i);
            msg = new Message(dest, null, null);
            hdr = new PbcastHeader(gossip.copy(), 1);
            msg.putHeader(this.getName(), hdr);
            this.passDown(new Event(1, msg));
        }
    }

    void handleXmitRequest(Address requester, Hashtable xmit_reqs) {
        if (requester == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.PBCAST_REQUESTER_IS_NULL);
            }
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.PBCAST_RETRANSMISSION_REQUESTS_ARE__0, this.printXmitReqs(xmit_reqs));
        }
        Enumeration e = xmit_reqs.keys();
        while (e.hasMoreElements()) {
            Message msg;
            Address sender = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(sender);
            if (win == null) {
                if (!this.warn) continue;
                this.log.warn("sender " + sender + " not found in my digest; skipping retransmit request !");
                continue;
            }
            List missing_msgs = (List)xmit_reqs.get(sender);
            List msgs = win.getMessagesInList(missing_msgs);
            List xmit_msgs = new List();
            Enumeration en = msgs.elements();
            while (en.hasMoreElements()) {
                msg = ((Message)en.nextElement()).copy();
                xmit_msgs.add(msg);
            }
            msg = new Message(requester, null, xmit_msgs);
            msg.putHeader(this.getName(), new PbcastHeader(3));
            this.passDown(new Event(1, msg));
        }
    }

    void handleXmitRsp(List xmit_msgs) {
        Enumeration e = xmit_msgs.elements();
        while (e.hasMoreElements()) {
            Message m = (Message)e.nextElement();
            PbcastHeader hdr = (PbcastHeader)m.removeHeader(this.getName());
            if (hdr == null) {
                this.log.warn("header is null, ignoring message");
                continue;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("received #" + hdr.seqno + ", type=" + PbcastHeader.type2String(hdr.type) + ", msg=" + m);
            }
            this.handleUpMessage(m, hdr);
        }
    }

    String printXmitReqs(Hashtable xmit_reqs) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (xmit_reqs == null) {
            return "<null>";
        }
        Enumeration e = xmit_reqs.keys();
        while (e.hasMoreElements()) {
            Address key2 = (Address)e.nextElement();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key2 + ": " + xmit_reqs.get(key2));
        }
        return sb.toString();
    }

    void garbageCollect(Digest d) {
        for (Map.Entry entry : d.senders.entrySet()) {
            Address sender = (Address)entry.getKey();
            Digest.Entry val = (Digest.Entry)entry.getValue();
            NakReceiverWindow win = (NakReceiverWindow)this.digest.get(sender);
            if (win == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("sender " + sender + " not found in our message digest, skipping");
                continue;
            }
            long tmp_seqno = val.high_seqno;
            if ((tmp_seqno = Math.max(tmp_seqno - (long)this.gc_lag, 0L)) <= 0L) continue;
            if (trace) {
                this.log.trace("(from " + this.local_addr + ") GC: deleting messages < " + tmp_seqno + " from " + sender);
            }
            win.stable(tmp_seqno);
        }
    }

    void shunInvalidGossiper(Address invalid_gossiper) {
        int num_pings = 0;
        if (this.invalid_gossipers.containsKey(invalid_gossiper)) {
            num_pings = (Integer)this.invalid_gossipers.get(invalid_gossiper);
            if (num_pings >= 2) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("sender " + invalid_gossiper + " is not member of " + this.members + " ! Telling it to leave group");
                }
                Message shun_msg = new Message(invalid_gossiper, null, null);
                shun_msg.putHeader(this.getName(), new PbcastHeader(4));
                this.passDown(new Event(1, shun_msg));
                this.invalid_gossipers.remove(invalid_gossiper);
            } else {
                this.invalid_gossipers.put(invalid_gossiper, ++num_pings);
            }
        } else {
            this.invalid_gossipers.put(invalid_gossiper, ++num_pings);
        }
    }

    long computeGossipInterval(int num_mbrs, double desired_avg_gossip) {
        return this.getRandom((long)((double)num_mbrs * desired_avg_gossip * 2.0));
    }

    long getRandom(long range) {
        return (long)(Math.random() * (double)range % (double)range);
    }

    private class GossipHandler
    implements Runnable {
        Thread t = null;
        final Queue queue;

        GossipHandler(Queue q) {
            this.queue = q;
        }

        synchronized void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "PBCAST.GossipHandlerThread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        synchronized void stop() {
            if (this.t != null && this.t.isAlive()) {
                Thread tmp = this.t;
                this.t = null;
                if (this.queue != null) {
                    this.queue.close(false);
                }
                tmp.interrupt();
            }
            this.t = null;
        }

        @Override
        public void run() {
            block11: while (true) {
                SystemFailure.checkFailure();
                if (Thread.currentThread().isInterrupted()) break;
                try {
                    GossipEntry entry = (GossipEntry)this.queue.remove();
                    PbcastHeader hdr = entry.hdr;
                    if (hdr == null) {
                        if (!PBCAST.this.log.isErrorEnabled()) continue;
                        PBCAST.this.log.error(JGroupsStrings.PBCAST_GOSSIP_ENTRY_HAS_NO_PBCASTHEADER);
                        continue;
                    }
                    switch (hdr.type) {
                        case 1: {
                            PBCAST.this.handleGossip(hdr.gossip);
                            break;
                        }
                        case 2: {
                            if (hdr.xmit_reqs == null) {
                                if (!PBCAST.this.warn) continue block11;
                                PBCAST.this.log.warn("request is null !");
                                break;
                            }
                            PBCAST.this.handleXmitRequest(entry.sender, hdr.xmit_reqs);
                            break;
                        }
                        case 3: {
                            List xmit_msgs;
                            byte[] data = entry.data;
                            if (data == null) {
                                if (!PBCAST.this.warn) continue block11;
                                PBCAST.this.log.warn("buffer is null (no xmitted msgs)");
                                break;
                            }
                            try {
                                xmit_msgs = (List)Util.objectFromByteBuffer(data);
                            }
                            catch (Exception ex) {
                                if (!PBCAST.this.log.isErrorEnabled()) continue block11;
                                PBCAST.this.log.error(JGroupsStrings.PBCAST_FAILED_CREATING_RETRANSMITTED_MESSAGES_FROM_BUFFER, (Throwable)ex);
                                break;
                            }
                            PBCAST.this.handleXmitRsp(xmit_msgs);
                            break;
                        }
                        case 4: {
                            if (!PBCAST.this.shun) continue block11;
                            if (PBCAST.this.log.isInfoEnabled()) {
                                PBCAST.this.log.info(JGroupsStrings.PBCAST_I_AM_BEING_SHUNNED_WILL_LEAVE_AND_REJOIN);
                            }
                            PBCAST.this.passUp(new Event(46));
                            break;
                        }
                        default: {
                            if (PBCAST.this.log.isErrorEnabled()) {
                                PBCAST.this.log.error("type (" + hdr.type + ") of PbcastHeader not known !");
                            }
                            return;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    break;
                }
                catch (QueueClosedException closed) {
                    break;
                }
            }
        }
    }

    private static class GossipEntry {
        PbcastHeader hdr = null;
        Address sender = null;
        byte[] data = null;

        GossipEntry(PbcastHeader hdr, Address sender, byte[] data) {
            this.hdr = hdr;
            this.sender = sender;
            this.data = data;
        }

        public String toString() {
            return "hdr=" + this.hdr + ", sender=" + this.sender + ", data=" + (this.data == null ? "null" : "(" + this.data.length + " bytes)");
        }
    }
}

