/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Membership;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.protocols.pbcast.GmsImpl;
import com.gemstone.org.jgroups.protocols.pbcast.JoinRsp;
import com.gemstone.org.jgroups.util.Promise;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class ParticipantGmsImpl
extends GmsImpl {
    private final Vector suspected_mbrs = new Vector(11);
    private final Set<Address> departed_mbrs = new HashSet<Address>();
    private final Promise leave_promise = new Promise();

    public ParticipantGmsImpl(GMS g) {
        super(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        super.init();
        Vector vector = this.suspected_mbrs;
        synchronized (vector) {
            this.suspected_mbrs.removeAllElements();
        }
        this.leave_promise.reset();
    }

    @Override
    public boolean join(Address mbr) {
        this.wrongMethod("join");
        return false;
    }

    @Override
    public void handleJoinsAndLeaves(List joins, List leaves, List suspects, List suspectReasons, boolean forceInclusion) {
        Iterator it = suspects.iterator();
        while (it.hasNext()) {
            this.handleSuspect((Address)it.next());
        }
        if (leaves != null && !leaves.isEmpty()) {
            this.handleLeave(leaves, false, null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leave(Address mbr) {
        Address coord;
        int max_tries = 3;
        this.leave_promise.reset();
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        while ((coord = this.gms.determineCoordinator()) != null && max_tries-- > 0) {
            if (this.gms.local_addr.equals(coord)) {
                if (this.leaving) break;
                this.gms.becomeCoordinator(this.suspected_mbrs);
                this.gms.getImpl().leave(mbr);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("sending LEAVE request to " + coord + " (local_addr=" + this.gms.local_addr + ")");
            }
            this.sendLeaveMessage(coord, mbr);
            long leaveTimeout = this.gms.leave_timeout * (long)this.gms.members.size() / 10L;
            Set<Address> set = this.leave_promise;
            synchronized (set) {
                Object result = this.leave_promise.getResult(leaveTimeout);
                if (result != null) {
                    break;
                }
            }
            set = this.suspected_mbrs;
            synchronized (set) {
                if (this.suspected_mbrs.contains(coord)) {
                    break;
                }
            }
            set = this.departed_mbrs;
            synchronized (set) {
                if (this.departed_mbrs.contains(coord)) {
                    break;
                }
            }
            if (this.gms.determineCoordinator() != coord) continue;
            break;
        }
        this.gms.becomeClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSuspects() {
        Vector vector = this.suspected_mbrs;
        synchronized (vector) {
            return new Vector(this.suspected_mbrs);
        }
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLeaveResponse(String reason) {
        if (reason != null && reason.length() > 0) {
            this.gms.passUp(new Event(46, new ForcedDisconnectException("This member has been forced out of the distributed system.  Reason='" + reason + "'")));
        }
        Promise promise = this.leave_promise;
        synchronized (promise) {
            this.leave_promise.setResult(Boolean.TRUE);
        }
    }

    public void suspect(Address mbr) {
        this.handleSuspect(mbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsuspect(Address mbr) {
        Vector vector = this.suspected_mbrs;
        synchronized (vector) {
            if (mbr != null) {
                this.suspected_mbrs.remove(mbr);
            }
        }
    }

    @Override
    public void handleJoin(Address mbr) {
    }

    public void handleLeave(Address mbr, boolean suspected) {
        if (suspected) {
            this.handleSuspect(mbr);
        } else {
            this.handleLeave(Collections.singletonList(mbr), false, null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLeave(List members, boolean suspected, List reasons, boolean forceInclusion) {
        if (suspected) {
            Iterator it = members.iterator();
            while (it.hasNext() && this.gms.getImpl() == this) {
                this.handleSuspect((Address)it.next());
            }
        } else {
            boolean becomeCoordinator = false;
            Vector suspects = null;
            HashSet<Address> departed = null;
            Collection<Object> collection = this.suspected_mbrs;
            synchronized (collection) {
                suspects = new Vector(this.suspected_mbrs);
            }
            collection = this.departed_mbrs;
            synchronized (collection) {
                this.departed_mbrs.addAll(members);
                departed = new HashSet<Address>(this.departed_mbrs);
            }
            if (this.wouldIBeCoordinator(suspects, departed)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("suspected mbrs=" + this.suspected_mbrs + "; departed=" + this.departed_mbrs + "; members are " + this.gms.members + ", coord=" + this.gms.local_addr + ": I'm the new coord !");
                }
                becomeCoordinator = true;
            }
            if (becomeCoordinator) {
                collection = this.suspected_mbrs;
                synchronized (collection) {
                    this.suspected_mbrs.removeAll(suspects);
                }
                collection = this.departed_mbrs;
                synchronized (collection) {
                    this.departed_mbrs.removeAll(departed);
                }
                this.gms.incrementLtime(10);
                this.gms.becomeCoordinator(suspects);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleViewChange(View new_view, Digest digest) {
        Vector mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            this.log.debug("view=" + new_view);
        }
        Collection<Object> collection = this.suspected_mbrs;
        synchronized (collection) {
            this.suspected_mbrs.removeAllElements();
        }
        collection = this.departed_mbrs;
        synchronized (collection) {
            this.departed_mbrs.clear();
        }
        if (!mbrs.contains(this.gms.local_addr)) {
            if (this.leaving) {
                return;
            }
            this.gms.passUp(new Event(46, new ForcedDisconnectException(JGroupsStrings.PGMS_THIS_MEMBER_HAS_BEEN_FORCED_OUT_OF_THE_DISTRIBUTED_SYSTEM_PLEASE_CONSULT_GEMFIRE_LOGS_TO_FIND_THE_REASON_PGMS.toLocalizedString(new_view.getCreator()))));
        }
        this.gms.installView(new_view, digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSuspect(Address mbr) {
        boolean becomeCoordinator = false;
        Vector suspects = null;
        if (mbr == null) {
            return;
        }
        Collection<Object> collection = this.suspected_mbrs;
        synchronized (collection) {
            if (!this.suspected_mbrs.contains(mbr)) {
                this.suspected_mbrs.addElement(mbr);
            }
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("PGMS: suspected mbr=" + mbr + ", suspected_mbrs=" + this.suspected_mbrs + ", members=" + this.gms.members + ", local_addr=" + this.gms.local_addr);
            }
            if (this.wouldIBeCoordinator(this.suspected_mbrs, Collections.EMPTY_SET)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("suspected mbr=" + mbr + "), departed=" + this.departed_mbrs + "; members are " + this.gms.members + ", coord=" + this.gms.local_addr + ": I'm the new coord !");
                }
                becomeCoordinator = true;
                suspects = new Vector(this.suspected_mbrs);
                this.suspected_mbrs.removeAllElements();
            }
        }
        if (becomeCoordinator) {
            collection = this.departed_mbrs;
            synchronized (collection) {
                this.departed_mbrs.clear();
            }
            this.gms.incrementLtime(10);
            this.gms.becomeCoordinator(suspects);
        }
    }

    @Override
    public void handleMergeRequest(Address sender, ViewId merge_id) {
        this.sendMergeRejectedResponse(sender, merge_id);
    }

    boolean wouldIBeCoordinator(Vector suspects, Set<Address> departures) {
        Vector mbrs = this.gms.members.getMembers();
        if (this.log.isDebugEnabled()) {
            this.log.debug("wouldIBeCoordinator:\nmembers = " + mbrs + "\ndeparted = " + this.departed_mbrs + "\nsuspected = " + this.suspected_mbrs);
        }
        if (suspects != null) {
            mbrs.removeAll(suspects);
        }
        if (departures != null) {
            mbrs.removeAll(departures);
        }
        if (mbrs.size() < 1) {
            return false;
        }
        Address new_coord = new Membership(mbrs).getCoordinator();
        if (new_coord == null) {
            return false;
        }
        return this.gms.local_addr.equals(new_coord);
    }

    void sendLeaveMessage(Address coord, Address mbr) {
        Message msg = new Message(coord, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(3, mbr);
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.passDown(new Event(1, msg));
    }

    @Override
    public void handleAlreadyJoined(Address mbr) {
    }
}

