/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.protocols.pbcast.Gossip;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;

public class PbcastHeader
extends Header {
    public static final int MCAST_MSG = 0;
    public static final int GOSSIP = 1;
    public static final int XMIT_REQ = 2;
    public static final int XMIT_RSP = 3;
    public static final int NOT_MEMBER = 4;
    int type = -1;
    long seqno = -1L;
    Gossip gossip = null;
    Hashtable xmit_reqs = null;

    public PbcastHeader() {
        this.type = -1;
    }

    public PbcastHeader(int type) {
        this.type = type;
    }

    public PbcastHeader(int type, long seqno) {
        this.type = type;
        this.seqno = seqno;
    }

    public PbcastHeader(Gossip g, int type) {
        this.type = type;
        this.gossip = g;
    }

    public PbcastHeader(Gossip g, int type, long seqno) {
        this.type = type;
        this.seqno = seqno;
        this.gossip = g;
    }

    public long getSeqno() {
        return this.seqno;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[PBCAST(" + PbcastHeader.type2String(this.type) + "), seqno=" + this.seqno);
        if (this.gossip != null) {
            sb.append(", gossip=" + this.gossip);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public long size(short version) {
        return 500L;
    }

    public static String type2String(int t) {
        switch (t) {
            case 0: {
                return "MCAST_MSG";
            }
            case 1: {
                return "GOSSIP";
            }
            case 2: {
                return "XMIT_REQ";
            }
            case 3: {
                return "XMIT_RSP";
            }
            case 4: {
                return "NOT_MEMBER";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeLong(this.seqno);
        out.writeObject(this.gossip);
        out.writeObject(this.xmit_reqs);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.seqno = in.readLong();
        this.gossip = (Gossip)in.readObject();
        this.xmit_reqs = (Hashtable)in.readObject();
    }
}

