/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.StateTransferInfo;
import com.gemstone.org.jgroups.util.List;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class STATE_TRANSFER
extends Protocol {
    Address local_addr = null;
    final Vector members = new Vector();
    long state_id = 1L;
    final List state_requesters = new List();
    Digest digest = null;
    final HashMap map = new HashMap();
    long start;
    long stop;
    int num_state_reqs = 0;
    long num_bytes_sent = 0L;
    double avg_state_size = 0.0;
    static final String name = "STATE_TRANSFER";

    @Override
    public String getName() {
        return name;
    }

    public int getNumberOfStateRequests() {
        return this.num_state_reqs;
    }

    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent;
    }

    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    @Override
    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(42);
        retval.addElement(41);
        return retval;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_state_reqs = 0;
        this.num_bytes_sent = 0L;
        this.avg_state_size = 0.0;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.STATE_TRANSFER_STATE_TRANSFERSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
        this.map.put("state_transfer", Boolean.TRUE);
        this.map.put("protocol_class", this.getClass().getName());
    }

    @Override
    public void start() throws Exception {
        this.passUp(new Event(56, this.map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 16: {
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 43: {
                List list = this.state_requesters;
                synchronized (list) {
                    if (this.digest != null && this.warn) {
                        this.log.warn("GET_DIGEST_STATE_OK: existing digest is not null, overwriting it !");
                    }
                    this.digest = (Digest)evt.getArg();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_DIGEST_STATE_OK: digest is " + this.digest + "\npassUp(GET_APPLSTATE)");
                    }
                    this.passUp(new Event(17));
                }
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (!(msg.getHeader(name) instanceof StateHeader)) break;
                StateHeader hdr = (StateHeader)msg.removeHeader(name);
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(hdr.sender);
                        break;
                    }
                    case 2: {
                        this.handleStateRsp(hdr.sender, hdr.my_digest, msg.getBuffer());
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error(JGroupsStrings.STATE_TRANSFER_TYPE__0__NOT_KNOWN_IN_STATEHEADER, hdr.type);
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.type != 1 && this.warn) {
                    this.log.warn("[GET_STATE] (info=" + info + "): getting the state from " + "all members is not currently supported by pbcast.STATE_TRANSFER, will use " + "coordinator to fetch state instead");
                }
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error(JGroupsStrings.STATE_TRANSFER_GET_STATE_CANNOT_FETCH_STATE_FROM_MYSELF_);
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_STATE: first member (no state)");
                    }
                    this.passUp(new Event(20, null));
                } else {
                    Message state_req = new Message(target, null, null);
                    state_req.putHeader(name, new StateHeader(1, this.local_addr, this.state_id++, null));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_STATE: asking " + target + " for state");
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("passing down a SUSPEND_STABLE event");
                    }
                    this.passDown(new Event(65, info.timeout));
                    this.start = System.currentTimeMillis();
                    this.passDown(new Event(1, state_req));
                }
                return;
            }
            case 18: {
                byte[] state = (byte[])evt.getArg();
                List list = this.state_requesters;
                synchronized (list) {
                    if (this.state_requesters.size() == 0) {
                        if (this.warn) {
                            this.log.warn("GET_APPLSTATE_OK: received application state, but there are no requesters !");
                        }
                        return;
                    }
                    if (this.digest == null) {
                        if (this.warn) {
                            this.log.warn("GET_APPLSTATE_OK: received application state, but there is no digest !");
                        }
                    } else {
                        this.digest = this.digest.copy();
                    }
                    if (this.stats) {
                        ++this.num_state_reqs;
                        if (state != null) {
                            this.num_bytes_sent += (long)state.length;
                        }
                        this.avg_state_size = (double)this.num_bytes_sent / (double)this.num_state_reqs;
                    }
                    Enumeration e = this.state_requesters.elements();
                    while (e.hasMoreElements()) {
                        Address requester = (Address)e.nextElement();
                        Message state_rsp = new Message(requester, null, state);
                        StateHeader hdr = new StateHeader(2, this.local_addr, 0L, this.digest);
                        state_rsp.putHeader(name, hdr);
                        this.passDown(new Event(1, state_rsp));
                    }
                    this.digest = null;
                    this.state_requesters.removeAll();
                }
                return;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address determineCoordinator() {
        Address ret = null;
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() > 1) {
                for (int i = 0; i < this.members.size(); ++i) {
                    if (this.local_addr.equals(this.members.elementAt(i))) continue;
                    return (Address)this.members.elementAt(i);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        Vector new_members = v.getMembers();
        Vector vector = this.members;
        synchronized (vector) {
            this.members.clear();
            this.members.addAll(new_members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStateReq(Object sender) {
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.STATE_TRANSFER_SENDER_IS_NULL_);
            }
            return;
        }
        List list = this.state_requesters;
        synchronized (list) {
            if (this.state_requesters.size() > 0) {
                this.state_requesters.add(sender);
            } else {
                this.state_requesters.add(sender);
                this.digest = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("passing down GET_DIGEST_STATE");
                }
                this.passDown(new Event(42));
            }
        }
    }

    void handleStateRsp(Object sender, Digest digest, byte[] state) {
        if (digest == null) {
            if (this.warn) {
                this.log.warn("digest received from " + sender + " is null, skipping setting digest !");
            }
        } else {
            this.passDown(new Event(41, digest));
        }
        this.stop = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("passing down a RESUME_STABLE event");
        }
        this.passDown(new Event(66));
        if (state == null) {
            if (this.warn) {
                this.log.warn("state received from " + sender + " is null, will return null state to application");
            }
        } else {
            this.log.debug("received state, size=" + state.length + " bytes. Time=" + (this.stop - this.start) + " milliseconds");
        }
        this.passUp(new Event(20, state));
    }

    public static class StateHeader
    extends Header
    implements Streamable {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        long id = 0L;
        byte type = 0;
        Address sender = null;
        Digest my_digest = null;

        public StateHeader() {
        }

        public StateHeader(byte type, Address sender, long id, Digest digest) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        public boolean equals(Object o) {
            if (this.sender != null && o != null) {
                if (!(o instanceof StateHeader)) {
                    return false;
                }
                StateHeader other = (StateHeader)o;
                return this.sender.equals(other.sender) && this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            if (this.sender != null) {
                return this.sender.hashCode() + (int)this.id;
            }
            return (int)this.id;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[StateHeader: type=" + StateHeader.type2Str(this.type));
            if (this.sender != null) {
                sb.append(", sender=" + this.sender + " id=#" + this.id);
            }
            if (this.my_digest != null) {
                sb.append(", digest=" + this.my_digest);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
            }
            return "<unknown>";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sender);
            out.writeLong(this.id);
            out.writeByte(this.type);
            out.writeObject(this.my_digest);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sender = (Address)in.readObject();
            this.id = in.readLong();
            this.type = in.readByte();
            this.my_digest = (Digest)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            Util.writeAddress(this.sender, out);
            Util.writeStreamable(this.my_digest, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.sender = Util.readAddress(in);
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
        }

        @Override
        public long size(short version) {
            long retval = 9L;
            retval += (long)Util.size(this.sender, version);
            ++retval;
            if (this.my_digest != null) {
                retval += this.my_digest.serializedSize(version);
            }
            return retval;
        }
    }
}

