/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.ring;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.SuspectedException;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.protocols.ring.RingNode;
import com.gemstone.org.jgroups.protocols.ring.RingToken;
import com.gemstone.org.jgroups.protocols.ring.TokenLostException;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.RpcProtocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class TcpRingNode
implements RingNode {
    final ServerSocket tokenReceiver;
    Socket previous;
    Socket next;
    final Address thisNode;
    Address nextNode;
    ObjectInputStream ios;
    ObjectOutputStream oos;
    final RpcProtocol rpcProtocol;
    static final boolean failedOnTokenLostException = false;
    final Object socketMutex = new Object();
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());

    public TcpRingNode(RpcProtocol owner, Address memberAddress) {
        this.tokenReceiver = Util.createServerSocket(12000);
        this.rpcProtocol = owner;
        this.thisNode = memberAddress;
        this.nextNode = null;
    }

    @Override
    public IpAddress getTokenReceiverAddress() {
        return new IpAddress(this.tokenReceiver.getLocalPort());
    }

    @Override
    public Object receiveToken(int timeout) throws TokenLostException {
        RingToken token = null;
        Address wasNextNode = this.nextNode;
        try {
            if (this.previous == null) {
                this.previous = this.tokenReceiver.accept();
                this.ios = new ObjectInputStream(this.previous.getInputStream());
            }
            this.previous.setSoTimeout(timeout);
            token = new RingToken();
            token.readExternal(this.ios);
        }
        catch (InterruptedIOException io) {
            throw new TokenLostException(io.getMessage(), (Throwable)io, wasNextNode, 1);
        }
        catch (ClassNotFoundException cantHappen) {
        }
        catch (IOException ioe) {
            this.closeSocket(this.previous);
            this.previous = null;
            if (this.ios != null) {
                try {
                    this.ios.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            token = (RingToken)this.receiveToken(timeout);
        }
        return token;
    }

    @Override
    public Object receiveToken() throws TokenLostException {
        return this.receiveToken(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passToken(Object token) throws TokenLostException {
        Object object = this.socketMutex;
        synchronized (object) {
            try {
                ((Externalizable)token).writeExternal(this.oos);
                this.oos.flush();
                this.oos.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new TokenLostException(e.getMessage(), (Throwable)e, this.nextNode, 2);
            }
        }
    }

    @Override
    public void tokenArrived(Object token) {
    }

    public void reconfigureAll(Vector newMembers) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Vector newMembers) {
        if (this.isNextNeighbourChanged(newMembers)) {
            IpAddress tokenReceiverAddress = null;
            Object object = this.socketMutex;
            synchronized (object) {
                this.nextNode = this.getNextNode(newMembers);
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.TcpRingNode_NEXT_NODE__0, this.nextNode);
                }
                try {
                    tokenReceiverAddress = (IpAddress)this.rpcProtocol.callRemoteMethod(this.nextNode, "getTokenReceiverAddress", 1, 0L);
                }
                catch (TimeoutException tim) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.TcpRingNode_TIMEOUTED_WHILE_DOING_RPC_CALL_GETTOKENRECEIVERADDRESS_0, (Throwable)tim);
                    }
                    tim.printStackTrace();
                }
                catch (SuspectedException sus) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.TcpRingNode_SUSPECTED_NODE_WHILE_DOING_RPC_CALL_GETTOKENRECEIVERADDRESS_0, (Throwable)sus);
                    }
                    sus.printStackTrace();
                }
                try {
                    this.closeSocket(this.next);
                    this.next = new Socket(tokenReceiverAddress.getIpAddress(), tokenReceiverAddress.getPort());
                    this.next.setTcpNoDelay(true);
                    this.oos = new ObjectOutputStream(this.next.getOutputStream());
                }
                catch (IOException ioe) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.TcpRingNode_COULD_NOT_CONNECT_TO_NEXT_NODE__0, (Throwable)ioe);
                    }
                    ioe.printStackTrace();
                }
            }
        }
    }

    private void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean isNextNeighbourChanged(Vector newMembers) {
        Address oldNeighbour = this.nextNode;
        Address newNeighbour = this.getNextNode(newMembers);
        return !newNeighbour.equals(oldNeighbour);
    }

    private Address getNextNode(Vector otherNodes) {
        int myIndex = otherNodes.indexOf(this.thisNode);
        return myIndex == otherNodes.size() - 1 ? (Address)otherNodes.firstElement() : (Address)otherNodes.elementAt(myIndex + 1);
    }
}

