/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.ring;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.TOTAL_TOKEN;
import com.gemstone.org.jgroups.protocols.ring.RingNode;
import com.gemstone.org.jgroups.protocols.ring.TokenLostException;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.RpcProtocol;
import java.io.Serializable;
import java.util.Vector;

public class UdpRingNode
implements RingNode {
    final Address thisNode;
    Address nextNode;
    final RpcProtocol rpcProtocol;
    Object token;
    final Object mutex = new Object();
    final TOTAL_TOKEN.RingTokenHeader tokenHeader;
    boolean tokenInStack = false;

    public UdpRingNode(RpcProtocol owner, Address memberAddress) {
        this.rpcProtocol = owner;
        this.thisNode = memberAddress;
        this.nextNode = null;
        this.tokenHeader = new TOTAL_TOKEN.RingTokenHeader();
    }

    @Override
    public IpAddress getTokenReceiverAddress() {
        return (IpAddress)this.thisNode;
    }

    @Override
    public synchronized void tokenArrived(Object token) {
        this.tokenInStack = true;
        this.token = token;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object receiveToken(int timeout) throws TokenLostException {
        Address wasNext = this.nextNode;
        try {
            UdpRingNode udpRingNode = this;
            synchronized (udpRingNode) {
                if (!this.tokenInStack) {
                    this.wait(timeout);
                }
                if (!this.tokenInStack) {
                    throw new TokenLostException("Token wait timout expired", null, wasNext, 1);
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new TokenLostException("Token thread interrupted", (Throwable)ie, wasNext, 1);
        }
        return this.token;
    }

    @Override
    public Object receiveToken() throws TokenLostException {
        return this.receiveToken(0);
    }

    @Override
    public synchronized void passToken(Object token) {
        Message t = new Message(this.nextNode, this.thisNode, (Serializable)token);
        t.putHeader("TOTAL_TOKEN", this.tokenHeader);
        this.rpcProtocol.passDown(new Event(1, t));
        this.tokenInStack = false;
    }

    @Override
    public synchronized void reconfigure(Vector newMembers) {
        if (this.isNextNeighbourChanged(newMembers)) {
            this.nextNode = this.getNextNode(newMembers);
        }
    }

    private boolean isNextNeighbourChanged(Vector newMembers) {
        Address oldNeighbour = this.nextNode;
        Address newNeighbour = this.getNextNode(newMembers);
        return !newNeighbour.equals(oldNeighbour);
    }

    private Address getNextNode(Vector otherNodes) {
        int myIndex = otherNodes.indexOf(this.thisNode);
        return myIndex == otherNodes.size() - 1 ? (Address)otherNodes.firstElement() : (Address)otherNodes.elementAt(myIndex + 1);
    }
}

