/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.oswego.concurrent.ConcurrentReaderHashMap;
import com.gemstone.org.jgroups.protocols.TP;
import com.gemstone.org.jgroups.stack.Retransmitter;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.TimeScheduler;
import java.util.Map;
import java.util.TreeSet;

public class AckSenderWindow
implements Retransmitter.RetransmitCommand {
    RetransmitCommand retransmit_command = null;
    final Map msgs = new ConcurrentReaderHashMap();
    long[] interval = new long[]{400L, 800L, 1200L, 1600L};
    final Retransmitter retransmitter;
    static final GemFireTracer log = GemFireTracer.getLog(AckSenderWindow.class);
    Address dest = null;

    public AckSenderWindow(RetransmitCommand com) {
        this.retransmit_command = com;
        this.retransmitter = new Retransmitter(null, this);
        this.retransmitter.setRetransmitTimeouts(this.interval);
    }

    public AckSenderWindow(RetransmitCommand com, long[] interval) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(null, this);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow(RetransmitCommand com, long[] interval, TimeScheduler sched) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(null, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map map = this.msgs;
        synchronized (map) {
            this.msgs.clear();
        }
        this.retransmitter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg) {
        Long tmp = seqno;
        Map map = this.msgs;
        synchronized (map) {
            if (this.dest == null) {
                this.dest = msg.getDest();
            }
            if (!this.msgs.containsKey(tmp)) {
                this.msgs.put(tmp, msg);
            }
            this.retransmitter.add(seqno, seqno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ack(long seqno) {
        Message msg;
        Map map = this.msgs;
        synchronized (map) {
            msg = (Message)this.msgs.remove(seqno);
            if (msg == null) {
                return -1L;
            }
            this.retransmitter.remove(seqno);
        }
        return msg.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map map = this.msgs;
        synchronized (map) {
            return this.msgs.size();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("retransmitter: ");
        this.retransmitter.toString(sb);
        TreeSet keys = new TreeSet(this.msgs.keySet());
        if (keys.size() > 0) {
            sb.append(keys.first()).append(" - ").append(keys.last());
        } else {
            sb.append("[]");
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.msgs.size()).append(" msgs (").append(this.retransmitter.size()).append(" to retransmit): ").append(new TreeSet(this.msgs.keySet()));
        return sb.toString();
    }

    @Override
    public Address getDest() {
        return this.dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        Address dest = null;
        long burstLimit = this.retransmit_command.getMaxRetransmissionBurst();
        long burstSize = 0L;
        if (this.retransmit_command != null) {
            for (long i = first_seqno; i <= last_seqno; ++i) {
                Message msg;
                Map map = this.msgs;
                synchronized (map) {
                    msg = (Message)this.msgs.get(i);
                }
                if (msg == null) continue;
                this.retransmit_command.retransmit(i, msg);
                dest = msg.getDest();
                if (burstLimit > 0L && (burstSize += msg.size()) >= burstLimit) break;
            }
            if (log.isTraceEnabled() || TP.VERBOSE) {
                StringBuffer b = new StringBuffer("retransmitted message");
                if (last_seqno == first_seqno) {
                    b.append(' ').append(first_seqno);
                } else {
                    b.append("s ").append(first_seqno).append(" - ").append(last_seqno);
                }
                if (dest != null) {
                    b.append(" to ").append(dest);
                }
                log.getInternalLogWriter().info(JGroupsStrings.DEBUG, b);
            }
        }
    }

    static class Dummy
    implements RetransmitCommand {
        static final long last_xmit_req = 0L;

        Dummy() {
        }

        @Override
        public void retransmit(long seqno, Message msg) {
            if (log.isDebugEnabled()) {
                log.debug("seqno=" + seqno);
            }
        }

        @Override
        public long getMaxRetransmissionBurst() {
            return 0L;
        }
    }

    static class Entry {
        final long seqno;
        final Message msg;

        Entry(long seqno, Message msg) {
            this.seqno = seqno;
            this.msg = msg;
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3);

        public long getMaxRetransmissionBurst();
    }
}

