/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.ProtocolObserver;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;

class DownHandler
extends Thread {
    private Queue mq = null;
    private Protocol handler = null;
    private ProtocolObserver observer = null;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());

    public DownHandler(Queue mq, Protocol handler, ProtocolObserver observer) {
        super(GemFireTracer.GROUP, "TempName");
        this.mq = mq;
        this.handler = handler;
        this.observer = observer;
        if (handler != null) {
            this.setName("DownHandler (" + handler.getName() + ')');
        } else {
            this.setName("DownHandler");
        }
        this.setDaemon(true);
    }

    public void setObserver(ProtocolObserver observer) {
        this.observer = observer;
    }

    @Override
    public void run() {
        while (!this.mq.closed()) {
            SystemFailure.checkFailure();
            try {
                int type;
                Event evt = (Event)this.mq.remove();
                if (evt == null) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("removed null event");
                    continue;
                }
                if (this.observer != null && !this.observer.down(evt, this.mq.size()) || ((type = evt.getType()) == 61 || type == 63) && !this.handler.handleSpecialDownEvent(evt)) continue;
                this.handler.down(evt);
            }
            catch (QueueClosedException queue_closed) {
                break;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn(this.getName() + " caught exception", e);
            }
        }
    }
}

