/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.SerializationVersions;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.org.jgroups.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class GossipData
implements DataSerializable,
SerializationVersions {
    private static final long serialVersionUID = 309080226207432135L;
    public static final int REGISTER_REQ = 1;
    public static final int GET_REQ = 2;
    public static final int GET_RSP = 3;
    public static final int GEMFIRE_VERSION = 4;
    int type = 0;
    String group = null;
    Address mbr = null;
    List mbrs = null;
    short versionOrdinal = Version.TOKEN.ordinal();
    boolean hasDistributedSystem;
    boolean floatingCoordinatorDisabled;
    private boolean networkPartitionDetectionEnabled;
    Vector locators;
    Address localAddress;
    private static Version[] serializationVersions = new Version[]{Version.GFE_80};

    public GossipData() {
    }

    public GossipData(int type, String group, Address mbr, List mbrs, Vector locators) {
        this.type = type;
        this.group = group;
        this.mbr = mbr;
        this.mbrs = mbrs;
    }

    public GossipData(int type, String group, Address mbr, List mbrs, boolean hasDistributedSystem, boolean floatingDisabled, boolean networkPartitionDetectionEnabled, Vector locators, Address localAddress) {
        this.type = type;
        this.group = group;
        this.mbr = mbr;
        this.mbrs = mbrs;
        this.hasDistributedSystem = hasDistributedSystem;
        this.floatingCoordinatorDisabled = floatingDisabled;
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
        this.locators = locators;
        this.localAddress = localAddress;
    }

    public int getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public Address getMbr() {
        return this.mbr;
    }

    public List getMbrs() {
        return this.mbrs;
    }

    public boolean getHasDistributedSystem() {
        return this.hasDistributedSystem;
    }

    public boolean getFloatingCoordinatorDisabled() {
        return this.floatingCoordinatorDisabled;
    }

    public boolean getNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("type=").append(GossipData.type2String(this.type));
        switch (this.type) {
            case 1: {
                sb.append(" group=" + this.group + ", mbr=" + this.mbr);
                break;
            }
            case 2: {
                sb.append(" group=" + this.group);
                break;
            }
            case 3: {
                sb.append(" group=" + this.group + ", mbrs=" + this.mbrs + " hasDS=" + this.hasDistributedSystem + " coordinator=" + this.mbr + " locators=" + this.locators);
                break;
            }
            case 4: {
                if (this.versionOrdinal <= 0) break;
                sb.append(" version ordinal =" + this.versionOrdinal);
            }
        }
        return sb.toString();
    }

    public static String type2String(int t) {
        switch (t) {
            case 1: {
                return "REGISTER_REQ";
            }
            case 2: {
                return "GET_REQ";
            }
            case 3: {
                return "GET_RSP";
            }
            case 4: {
                return "GEMFIRE_VERSION";
            }
        }
        return "<unknown>";
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.type);
        if (this.type == 4) {
            out.writeShort(this.versionOrdinal);
        } else {
            out.writeUTF(this.group == null ? "" : this.group);
            DataSerializer.writeObject(this.mbr, out);
            DataSerializer.writeObject(this.mbrs, out);
            out.writeBoolean(this.hasDistributedSystem);
            out.writeBoolean(this.floatingCoordinatorDisabled);
            out.writeBoolean(this.networkPartitionDetectionEnabled);
            DataSerializer.writeObject(this.locators, out);
            DataSerializer.writeObject(this.localAddress, out);
        }
    }

    public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
        out.writeInt(this.type);
        if (this.type == 4) {
            out.writeShort(this.versionOrdinal);
        } else {
            out.writeUTF(this.group == null ? "" : this.group);
            DataSerializer.writeObject(this.mbr, out);
            DataSerializer.writeObject(this.mbrs, out);
            out.writeBoolean(this.hasDistributedSystem);
            out.writeBoolean(this.floatingCoordinatorDisabled);
            out.writeBoolean(this.networkPartitionDetectionEnabled);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        if (this.type == 4) {
            this.versionOrdinal = in.readShort();
        } else {
            this.group = in.readUTF();
            this.mbr = (Address)DataSerializer.readObject(in);
            this.mbrs = (List)DataSerializer.readObject(in);
            this.hasDistributedSystem = in.readBoolean();
            this.floatingCoordinatorDisabled = in.readBoolean();
            this.networkPartitionDetectionEnabled = in.readBoolean();
            this.locators = (Vector)DataSerializer.readObject(in);
            this.localAddress = (Address)DataSerializer.readObject(in);
        }
    }

    public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        if (this.type == 4) {
            this.versionOrdinal = in.readShort();
        } else {
            this.group = in.readUTF();
            this.mbr = (Address)DataSerializer.readObject(in);
            this.mbrs = (List)DataSerializer.readObject(in);
            this.hasDistributedSystem = in.readBoolean();
            this.floatingCoordinatorDisabled = in.readBoolean();
            this.networkPartitionDetectionEnabled = in.readBoolean();
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }
}

