/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMember;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedObjectInput;
import com.gemstone.gemfire.internal.VersionedObjectOutput;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gnu.trove.TIntIntHashMap;
import com.gemstone.gnu.trove.TIntIntIterator;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.protocols.TCPGOSSIP;
import com.gemstone.org.jgroups.stack.GossipClient;
import com.gemstone.org.jgroups.stack.GossipData;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.tcpserver.TcpHandler;
import com.gemstone.org.jgroups.stack.tcpserver.TcpServer;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.logging.log4j.Logger;

public class GossipServer
implements TcpHandler {
    private static final Logger logger = LogService.getLogger();
    public static final int GOSSIPVERSION = TcpServer.getCurrentGossipVersion();
    public static final int OLDGOSSIPVERSION = TcpServer.getOldGossipVersion();
    public static int FILE_FORMAT_VERSION = 1004;
    private static final TIntIntHashMap FILE_FORMAT_TO_GEMFIRE_VERSION_MAP = new TIntIntHashMap();
    public static final boolean LOCATOR_DISCOVERY_DISABLED = Boolean.getBoolean("gemfire.disable-locator-discovery");
    public static final String CHANNEL_NAME = "GF7";
    final Map groups = new HashMap();
    static long EXPIRY_TIME_DEFAULT = 30000L;
    long expiry_time = EXPIRY_TIME_DEFAULT;
    CacheCleaner cache_cleaner = null;
    Timer timer;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    File gossipFile;
    boolean floatingCoordinatorDisabled;
    boolean networkPartitionDetectionEnabled;
    private InetAddress bind_address;
    private int port;
    private File stateFile;
    private String locatorString;
    private Address coordinator;
    private Vector locators;
    private Address localAddress;
    private Object localAddressSync = new Object();
    private boolean withDS;

    public GossipServer(int port, long expiry_time, InetAddress bind_address, File stateFile, String locatorString, boolean floatingCoordinatorDisabled, boolean networkPartitionDetectionEnabled, boolean withDS) {
        this.port = port;
        this.bind_address = bind_address;
        this.expiry_time = expiry_time;
        this.withDS = withDS;
        this.floatingCoordinatorDisabled = floatingCoordinatorDisabled;
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
        this.stateFile = stateFile;
        this.locatorString = locatorString;
        this.locators = this.locatorString == null || this.locatorString.length() == 0 ? new Vector() : TCPGOSSIP.createInitialHosts(this.locatorString);
    }

    @Override
    public void restarting(DistributedSystem ds, GemFireCache cache, SharedConfiguration sharedConfig) {
    }

    private void recover(File sFile, String locatorsString) {
        this.recoverFromFile(sFile);
        this.recoverFromOthers(locatorsString);
    }

    private boolean recoverFromOthers(String locatorsString) {
        String myAddr2 = null;
        if (locatorsString != null && locatorsString.length() > 0) {
            String myAddr;
            if (this.bind_address == null) {
                try {
                    myAddr = SocketCreator.getLocalHost().getHostName();
                    myAddr2 = SocketCreator.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException ue) {
                    this.log.getInternalLogWriter().warning(JGroupsStrings.GossipServer_UNABLE_TO_RESOLVE_LOCAL_HOST_NAME, (Throwable)ue);
                    myAddr = "localhost";
                }
            } else {
                myAddr = this.bind_address.getHostAddress();
                myAddr2 = this.bind_address.getCanonicalHostName();
            }
            StringTokenizer st = new StringTokenizer(locatorsString, ",");
            while (st.hasMoreTokens()) {
                String l = st.nextToken();
                DistributionLocatorId locId = new DistributionLocatorId(l);
                if (locId.isMcastId()) continue;
                String otherAddr = locId.getBindAddress();
                String otherAddr2 = null;
                if (otherAddr != null) {
                    otherAddr = otherAddr.trim();
                }
                if (otherAddr == null || otherAddr.length() == 0) {
                    otherAddr = locId.getHost().getHostName();
                    otherAddr2 = locId.getHost().getCanonicalHostName();
                }
                if ((otherAddr.equals(myAddr) || otherAddr2 != null && otherAddr2.equals(myAddr) || myAddr2 != null && myAddr2.equals(otherAddr2)) && locId.getPort() == this.port) continue;
                this.log.getInternalLogWriter().info(JGroupsStrings.GossipServer_0__1__ATTEMPTING_TO_GET_STATE_FROM__2__3_, new Object[]{myAddr, this.port, otherAddr, locId.getPort()});
                if (!this.recover(otherAddr, locId.getPort())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean recover(String address, int serverPort) {
        GossipClient gc2 = new GossipClient(new IpAddress(address, serverPort), 20000L);
        Vector info = gc2.getMembers(CHANNEL_NAME, null, false, 15000L);
        if (gc2.getResponsiveServerCount() > 0) {
            VersionedEntryList mbrs = new VersionedEntryList(info.size());
            for (int i = 0; i < info.size(); ++i) {
                mbrs.add(new Entry((Address)info.get(i)));
            }
            this.groups.put(CHANNEL_NAME, mbrs);
            this.log.getInternalLogWriter().info(JGroupsStrings.GossipServer_INITIAL_DISCOVERY_SET_IS_0, mbrs);
            GossipServer.processLocators(this.log, this.locators, gc2.getGossip_servers());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean recoverFromFile(File sFile) {
        if (!sFile.exists()) return false;
        this.log.getInternalLogWriter().info(JGroupsStrings.GossipServer_RECOVERING_STATE_FROM__0, sFile);
        FileInputStream fis = null;
        try {
            VersionedEntryList members = null;
            fis = new FileInputStream(sFile);
            try (ObjectInput ois = new ObjectInputStream(fis);){
                int fileversion = ois.readInt();
                this.log.info("Discovery set was written with file version " + fileversion);
                if (fileversion > FILE_FORMAT_VERSION) {
                    boolean gfVersion = false;
                    return gfVersion;
                }
                short gfVersion = (short)FILE_FORMAT_TO_GEMFIRE_VERSION_MAP.get(fileversion);
                Version gemFireVersion = Version.fromOrdinalNoThrow(gfVersion, false);
                if (gemFireVersion == null) {
                    boolean bl = false;
                    return bl;
                }
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "Discovery set was written with " + gemFireVersion);
                ois = new VersionedObjectInput(ois, gemFireVersion);
                InetAddress addr = (InetAddress)ois.readObject();
                if (addr != null && this.bind_address != null && !addr.equals(this.bind_address)) {
                    boolean bl = false;
                    return bl;
                }
                members = new VersionedEntryList();
                members.readExternal(ois);
            }
            this.groups.put(CHANNEL_NAME, members);
            this.log.getInternalLogWriter().info(JGroupsStrings.GossipServer_INITIAL_DISCOVERY_SET_IS_0, members);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.getInternalLogWriter().warning(JGroupsStrings.GossipServer_UNABLE_TO_RECOVER_LOCATOR_REGISTRY_FROM__0, sFile, (Throwable)e);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            if (sFile.delete()) return false;
            if (!sFile.exists()) return false;
            this.log.getInternalLogWriter().warning(JGroupsStrings.GossipServer_UNABLE_TO_DELETE_REGISTRY_FILE_DISABLING_REGISTRY_PERSISTENCE);
            this.gossipFile = null;
            return false;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void init(TcpServer server) {
        if (this.log.getInternalLogWriter().fineEnabled()) {
            this.log.getInternalLogWriter().fine("Recovering from state file: " + this.stateFile);
        }
        this.timer = new Timer(true);
        this.recover(this.stateFile, this.locatorString);
        this.cache_cleaner = new CacheCleaner();
        this.timer.schedule((TimerTask)this.cache_cleaner, this.expiry_time, this.expiry_time);
        this.gossipFile = this.stateFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processLocators(GemFireTracer log, Vector myLocators, Vector otherLocators) {
        if (LOCATOR_DISCOVERY_DISABLED) {
            return false;
        }
        if (otherLocators == null) {
            return true;
        }
        Vector vector = myLocators;
        synchronized (vector) {
            LinkedList<Address> newLocators = null;
            for (Address a : otherLocators) {
                if (myLocators.contains(a)) continue;
                if (newLocators == null) {
                    newLocators = new LinkedList<Address>();
                }
                newLocators.add(a);
            }
            if (newLocators != null) {
                myLocators.addAll(newLocators);
                return true;
            }
            return myLocators.size() == otherLocators.size();
        }
    }

    @Override
    public synchronized Object processRequest(Object request) {
        if (!(request instanceof GossipData)) {
            throw new InternalGemFireException("Expected gossipData, got " + request.getClass());
        }
        GossipData gossip = (GossipData)request;
        Address mbr = null;
        if (this.log.isDebugEnabled()) {
            this.log.trace("processing request " + gossip.toString());
        }
        switch (gossip.getType()) {
            case 1: {
                String group = gossip.getGroup();
                mbr = gossip.getMbr();
                if (group == null || mbr == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.GossipServer_GROUP_OR_MEMBER_IS_NULL_CANNOT_REGISTER_MEMBER);
                    }
                    return null;
                }
                boolean differed = GossipServer.processLocators(this.log, this.locators, gossip.locators);
                return this.processRegisterRequest(group, mbr, differed);
            }
            case 2: {
                String group = gossip.getGroup();
                mbr = gossip.getMbr();
                if (group == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.GossipServer_GROUP_IS_NULL_CANNOT_GET_MEMBERSHIP);
                    }
                    return null;
                }
                boolean differed = GossipServer.processLocators(this.log, this.locators, gossip.locators);
                return this.processGetRequest(group, mbr, differed);
            }
            case 4: {
                return this.processVersionRequest();
            }
            case 3: {
                if (this.log.isWarnEnabled()) {
                    this.log.warn(JGroupsStrings.GossipServer_RECEIVED_A_GET_RSP_SHOULD_NOT_BE_RECEIVED_BY_SERVER);
                }
                return null;
            }
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn(JGroupsStrings.GossipServer_RECEIVED_UNKOWN_GOSSIP_REQUEST_GOSSIP_0.toLocalizedString(gossip));
        }
        return null;
    }

    @Override
    public void endRequest(Object request, long startTime) {
    }

    @Override
    public void endResponse(Object request, long startTime) {
    }

    private boolean checkCompatibility(Address addr) {
        if (this.bind_address != null && addr != null) {
            return this.bind_address.getClass() == ((IpAddress)addr).getIpAddress().getClass();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GossipData processRegisterRequest(String group, Address mbr, boolean sendLocators) {
        if (!this.checkCompatibility(mbr)) {
            this.log.getInternalLogWriter().warning(JGroupsStrings.GossipServer_RECEIVED_REGISTRATION_REQUEST_FROM_MEMBER_USING_INCOMPATIBLE_INTERNET_PROTOCOL_0, mbr);
        }
        this.addMember(group, mbr);
        this.persistState();
        GossipData rsp = new GossipData();
        if (sendLocators) {
            rsp.locators = new Vector(this.locators);
        }
        if (this.withDS) {
            try {
                Object object = this.localAddressSync;
                synchronized (object) {
                    while (this.localAddress == null) {
                        this.localAddressSync.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        rsp.localAddress = this.localAddress;
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GossipData processGetRequest(String group, Address mbr, boolean sendLocators) {
        List mbrs;
        if (!this.checkCompatibility(mbr)) {
            this.log.getInternalLogWriter().warning(JGroupsStrings.GossipServer_RECEIVED_GETMEMBERS_REQUEST_FROM_MEMBER_USING_INCOMPATIBLE_INTERNET_PROTOCOL_0, mbr);
        }
        GossipData ret = null;
        Object object = this;
        synchronized (object) {
            mbrs = this.getMembers(group);
            if (mbr != null) {
                this.addMember(group, mbr);
                this.persistState();
            }
        }
        if (this.withDS) {
            try {
                object = this.localAddressSync;
                synchronized (object) {
                    while (this.localAddress == null) {
                        this.localAddressSync.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        ret = new GossipData(3, group, this.coordinator, mbrs, this.hasDistributedSystem(), this.floatingCoordinatorDisabled, this.networkPartitionDetectionEnabled, sendLocators ? this.locators : null, this.localAddress);
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "get-members response = {}", ret);
        }
        return ret;
    }

    GossipData processVersionRequest() {
        GossipData ret = new GossipData(4, null, null, null, null);
        ret.versionOrdinal = Version.CURRENT_ORDINAL;
        if (this.log.getInternalLogWriter().finerEnabled()) {
            this.log.getInternalLogWriter().finer("version response = " + ret.versionOrdinal);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistState() {
        if (this.gossipFile != null) {
            VersionedEntryList members;
            Map map = this.groups;
            synchronized (map) {
                members = (VersionedEntryList)this.groups.get(CHANNEL_NAME);
                if (members == null) {
                    members = new VersionedEntryList();
                    this.groups.put(CHANNEL_NAME, members);
                }
            }
            if (!this.gossipFile.delete() && this.gossipFile.exists()) {
                this.log.getInternalLogWriter().warning(JGroupsStrings.GossipServer_UNABLE_TO_DELETE_0, this.gossipFile.getAbsolutePath());
            }
            try {
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                VersionedObjectOutput vos = null;
                try {
                    fos = new FileOutputStream(this.gossipFile);
                    oos = new ObjectOutputStream(fos);
                    vos = new VersionedObjectOutput(oos, Version.fromOrdinal((short)FILE_FORMAT_TO_GEMFIRE_VERSION_MAP.get(FILE_FORMAT_VERSION), false));
                    vos.writeInt(FILE_FORMAT_VERSION);
                    vos.writeObject(this.bind_address);
                    VersionedEntryList versionedEntryList = members;
                    synchronized (versionedEntryList) {
                        members.writeExternal(vos);
                    }
                    vos.flush();
                    oos.flush();
                    fos.flush();
                }
                finally {
                    if (vos != null) {
                        vos.close();
                    }
                    if (oos != null) {
                        oos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            catch (Exception e) {
                this.log.getInternalLogWriter().warning(JGroupsStrings.GossipServer_ERROR_WRITING_LOCATOR_STATE_TO_DISK__STATE_STORAGE_IS_BEING_DISABLED, (Throwable)e);
                this.gossipFile = null;
            }
        }
    }

    boolean hasDistributedSystem() {
        return this.withDS || InternalDistributedSystem.unsafeGetConnectedInstance() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(String group, Address mbr) {
        List mbrs;
        Map map = this.groups;
        synchronized (map) {
            mbrs = (List)this.groups.get(group);
        }
        if (mbrs == null) {
            mbrs = new VersionedEntryList();
            mbrs.add(new Entry(mbr));
            Map map2 = this.groups;
            synchronized (map2) {
                this.groups.put(group, mbrs);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("added " + mbr + " to discovery set for " + group + " (new group)");
            }
        } else {
            Entry entry = this.findEntry(mbrs, mbr);
            if (entry == null) {
                entry = new Entry(mbr);
                List list = mbrs;
                synchronized (list) {
                    mbrs.add(entry);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("added " + mbr + " to discovery set for " + group);
                }
            } else {
                entry.mbr = mbr;
                entry.update();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("updated discovery set entry " + entry);
                }
            }
        }
    }

    public int getMemberCount() {
        List mbrs = this.getMembers(CHANNEL_NAME);
        if (mbrs == null) {
            return -1;
        }
        return mbrs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getMembers(String group) {
        List mbrs;
        ArrayList<Address> ret = null;
        Object object = this.groups;
        synchronized (object) {
            mbrs = (List)this.groups.get(group);
        }
        if (mbrs == null) {
            return null;
        }
        object = mbrs;
        synchronized (object) {
            ret = new ArrayList<Address>(mbrs.size());
            for (int i = 0; i < mbrs.size(); ++i) {
                ret.add(((Entry)mbrs.get((int)i)).mbr);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry findEntry(List mbrs, Address mbr) {
        Entry entry = null;
        List list = mbrs;
        synchronized (list) {
            for (int i = 0; i < mbrs.size(); ++i) {
                entry = (Entry)mbrs.get(i);
                if (entry.mbr == null || !entry.mbr.equals(mbr)) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sweep() {
        boolean done;
        long current_time = System.currentTimeMillis();
        int num_entries_removed = 0;
        String key22 = null;
        do {
            done = true;
            try {
                for (String key22 : this.groups.keySet()) {
                    ArrayList listCopy;
                    List val = (List)this.groups.get(key22);
                    if (val == null) continue;
                    List list = val;
                    synchronized (list) {
                        listCopy = new ArrayList(val);
                    }
                    for (Entry entry : listCopy) {
                        long diff = current_time - entry.timestamp;
                        if (entry.timestamp + this.expiry_time >= current_time) continue;
                        val.remove(entry);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("removed member " + entry + " from discovery set " + key22 + '(' + diff + " msecs old)");
                        }
                        ++num_entries_removed;
                    }
                }
            }
            catch (ConcurrentModificationException ex) {
                done = false;
            }
        } while (!done);
        if (num_entries_removed > 0 && this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.GossipServer_DONE_REMOVED__0__DISCOVERY_ENTRIES, num_entries_removed);
        }
    }

    @Override
    public void shutDown() {
        this.timer.cancel();
    }

    public static int getFileVersionForOrdinal(short ordinal) {
        short closest = -1;
        int closestFV = FILE_FORMAT_VERSION;
        if (ordinal <= Version.CURRENT_ORDINAL) {
            TIntIntIterator itr = FILE_FORMAT_TO_GEMFIRE_VERSION_MAP.iterator();
            while (itr.hasNext()) {
                itr.advance();
                short o = (short)itr.value();
                if (o == ordinal) {
                    return itr.key();
                }
                if (o >= ordinal || o <= closest) continue;
                closest = o;
                closestFV = itr.key();
            }
        }
        return closestFV;
    }

    public void setCoordinator(Address coordinator) {
        this.coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalAddress(Address address) {
        Object object = this.localAddressSync;
        synchronized (object) {
            this.localAddress = address;
            this.localAddressSync.notifyAll();
        }
    }

    public void setLocalAddress(InternalDistributedMember daddress) {
        IpAddress jgroupsAddress = ((JGroupMember)daddress.getNetMember()).getAddress();
        this.setLocalAddress(jgroupsAddress);
    }

    public static TIntIntHashMap getFileVersionMapForTestOnly() {
        return FILE_FORMAT_TO_GEMFIRE_VERSION_MAP;
    }

    static {
        FILE_FORMAT_TO_GEMFIRE_VERSION_MAP.put(1003, Version.GFE_701.ordinal());
        FILE_FORMAT_TO_GEMFIRE_VERSION_MAP.put(1004, Version.CURRENT_ORDINAL);
    }

    class CacheCleaner
    extends TimerTask {
        CacheCleaner() {
        }

        @Override
        public void run() {
            GossipServer.this.sweep();
        }
    }

    private static class VersionedEntryList
    extends ArrayList<Entry>
    implements Externalizable {
        private int TEST_BYTES = 1;

        public VersionedEntryList(int size2) {
            super(size2);
        }

        public VersionedEntryList() {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            if (TcpServer.isTesting && in instanceof VersionedObjectInput) {
                VersionedObjectInput vis = (VersionedObjectInput)in;
                short gfVersion = vis.getVersion().ordinal();
                int newFileVersion = GossipServer.getFileVersionForOrdinal(Version.GFE_71.ordinal());
                int oldFileVersion = GossipServer.getFileVersionForOrdinal(gfVersion);
                if (oldFileVersion < newFileVersion && in.readInt() != this.TEST_BYTES) {
                    throw new IOException("Read integer is not TEST_BYTES ");
                }
            }
            int size2 = in.readInt();
            for (int i = 0; i < size2; ++i) {
                Entry entry = new Entry(null);
                entry.readExternal(in);
                this.add(entry);
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            if (TcpServer.isTesting && out instanceof VersionedObjectOutput) {
                VersionedObjectOutput vos = (VersionedObjectOutput)out;
                short gfVersion = vos.getVersion().ordinal();
                int newFileVersion = GossipServer.getFileVersionForOrdinal(Version.GFE_71.ordinal());
                int oldFileVersion = GossipServer.getFileVersionForOrdinal(gfVersion);
                if (oldFileVersion < newFileVersion) {
                    out.writeInt(this.TEST_BYTES);
                }
            }
            out.writeInt(this.size());
            for (Entry entry : this) {
                entry.writeExternal(out);
            }
        }
    }

    private static class Entry {
        Address mbr = null;
        long timestamp = 0L;

        Entry(Address mbr) {
            this.mbr = mbr;
            this.update();
        }

        void update() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            if (this.mbr != null && other != null) {
                if (other instanceof Address) {
                    return this.mbr.equals(other);
                }
                if (other instanceof Entry) {
                    return this.mbr.equals(((Entry)other).mbr);
                }
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "mbr=" + this.mbr;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.mbr = new IpAddress();
            this.mbr.readExternal(in);
            this.update();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            this.mbr.writeExternal(out);
        }
    }
}

