/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.oswego.concurrent.ReadWriteLock;
import com.gemstone.org.jgroups.oswego.concurrent.WriterPreferenceReadWriteLock;
import com.gemstone.org.jgroups.stack.Retransmitter;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.List;
import com.gemstone.org.jgroups.util.TimeScheduler;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

public class NakReceiverWindow {
    private final ReadWriteLock lock = new WriterPreferenceReadWriteLock();
    private long head = 0L;
    private long tail = 0L;
    private long lowest_seen = 0L;
    private long highest_seen = 0L;
    private final TreeMap received_msgs = new TreeMap();
    private final TreeMap delivered_msgs = new TreeMap();
    private boolean discard_delivered_msgs = false;
    private int max_xmit_buf_size = 0;
    private Retransmitter retransmitter = null;
    private Listener listener = null;
    protected static final GemFireTracer log = GemFireTracer.getLog(NakReceiverWindow.class);

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno, TimeScheduler sched) {
        this.tail = this.head = start_seqno;
        if (cmd != null) {
            this.retransmitter = sched == null ? new Retransmitter(sender, cmd) : new Retransmitter(sender, cmd, sched);
        }
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno) {
        this(sender, cmd, start_seqno, null);
    }

    public NakReceiverWindow(Address sender, long start_seqno) {
        this(sender, null, start_seqno);
    }

    public void setRetransmitTimeouts(long[] timeouts) {
        if (this.retransmitter != null) {
            this.retransmitter.setRetransmitTimeouts(timeouts);
        }
    }

    public void setDiscardDeliveredMessages(boolean flag) {
        this.discard_delivered_msgs = flag;
    }

    public int getMaxXmitBufSize() {
        return this.max_xmit_buf_size;
    }

    public void setMaxXmitBufSize(int max_xmit_buf_size) {
        this.max_xmit_buf_size = max_xmit_buf_size;
    }

    public void setListener(Listener l) {
        this.listener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg) {
        try {
            this.lock.writeLock().acquire();
            try {
                long old_tail = this.tail;
                if (seqno < this.head) {
                    if (log.isTraceEnabled()) {
                        StringBuffer sb = new StringBuffer("seqno ");
                        sb.append(seqno).append(" is smaller than ").append(this.head).append("); discarding message");
                        log.trace(sb.toString());
                    }
                    return;
                }
                if (seqno == this.tail) {
                    this.received_msgs.put(seqno, msg);
                    ++this.tail;
                    if (this.highest_seen + 2L == this.tail) {
                        ++this.highest_seen;
                    } else {
                        this.updateHighestSeen();
                    }
                } else if (seqno > this.tail) {
                    for (long i = this.tail; i < seqno; ++i) {
                        this.received_msgs.put(i, null);
                        ++this.tail;
                    }
                    this.received_msgs.put(seqno, msg);
                    this.tail = seqno + 1L;
                    if (this.retransmitter != null) {
                        this.retransmitter.add(old_tail, seqno - 1L);
                    }
                } else if (seqno < this.tail) {
                    Object val;
                    if (log.isTraceEnabled()) {
                        log.trace(new StringBuffer("added missing msg ").append(msg.getSrc()).append('#').append(seqno));
                    }
                    if (this.listener != null) {
                        try {
                            this.listener.missingMessageReceived(seqno, msg);
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                        }
                    }
                    if ((val = this.received_msgs.get(seqno)) == null) {
                        this.received_msgs.put(seqno, msg);
                        if (this.highest_seen + 1L == seqno || seqno == this.head) {
                            this.updateHighestSeen();
                        }
                        if (this.retransmitter != null) {
                            this.retransmitter.remove(seqno);
                        }
                    }
                }
                this.updateLowestSeen();
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void updateHighestSeen() {
        SortedMap map = this.received_msgs.tailMap(this.highest_seen);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) break;
            this.highest_seen = entry.getKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message remove() {
        Message retval = null;
        boolean bounded_buffer_enabled = this.max_xmit_buf_size > 0;
        try {
            this.lock.writeLock().acquire();
            try {
                while (this.received_msgs.size() > 0) {
                    Long key2 = (Long)this.received_msgs.firstKey();
                    retval = (Message)this.received_msgs.get(key2);
                    if (retval != null) {
                        this.received_msgs.remove(key2);
                        if (!this.discard_delivered_msgs) {
                            this.delivered_msgs.put(key2, retval);
                        }
                        ++this.head;
                        Message message = retval;
                        return message;
                    }
                    if (!bounded_buffer_enabled || this.received_msgs.size() <= this.max_xmit_buf_size) break;
                    this.received_msgs.remove(key2);
                    ++this.head;
                    this.retransmitter.remove(key2);
                }
                Message message = retval;
                return message;
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stable(long seqno) {
        try {
            this.lock.writeLock().acquire();
            try {
                SortedMap m = this.delivered_msgs.headMap(seqno + 1L);
                if (m.size() > 0) {
                    this.lowest_seen = Math.max(this.lowest_seen, m.lastKey());
                }
                m.clear();
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_WRITE_LOCK, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            this.lock.writeLock().acquire();
            try {
                if (this.retransmitter != null) {
                    this.retransmitter.reset();
                }
                this._reset();
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_WRITE_LOCK, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.lock.writeLock().acquire();
            try {
                if (this.retransmitter != null) {
                    this.retransmitter.stop();
                }
                this._reset();
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_WRITE_LOCK, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestDelivered() {
        this.lock.readLock().acquire();
        try {
            long l = Math.max(this.head - 1L, -1L);
            this.lock.readLock().release();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLowestSeen() {
        this.lock.readLock().acquire();
        try {
            long l = this.lowest_seen;
            this.lock.readLock().release();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestSeen() {
        this.lock.readLock().acquire();
        try {
            long l = this.highest_seen;
            this.lock.readLock().release();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMissingMessages(long low, long high) {
        List retval = new List();
        if (low > high) {
            if (log.isErrorEnabled()) {
                log.error("invalid range: low (" + low + ") is higher than high (" + high + ')');
            }
            return null;
        }
        this.lock.readLock().acquire();
        try {
            SortedMap m = this.received_msgs.subMap(low, high + 1L);
            Iterator<Long> it = m.keySet().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            List list = retval;
            this.lock.readLock().release();
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReceived() {
        this.lock.readLock().acquire();
        try {
            long l = Math.max(this.tail - 1L, -1L);
            this.lock.readLock().release();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesHigherThan(long seqno) {
        List retval = new List();
        this.lock.readLock().acquire();
        try {
            SortedMap m = this.received_msgs.tailMap(seqno + 1L);
            Iterator it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            m = this.delivered_msgs.tailMap(seqno + 1L);
            it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(((Message)it.next()).copy());
            }
            List list = retval;
            this.lock.readLock().release();
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInRange(long lower, long upper) {
        List retval = new List();
        this.lock.readLock().acquire();
        try {
            SortedMap m = this.received_msgs.subMap(lower + 1L, upper + 1L);
            Iterator it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            m = this.delivered_msgs.subMap(lower + 1L, upper + 1L);
            it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(((Message)it.next()).copy());
            }
            List list = retval;
            this.lock.readLock().release();
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInList(List missing_msgs) {
        List ret = new List();
        if (missing_msgs == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.NakReceiverWindow_ARGUMENT_LIST_IS_NULL);
            }
            return ret;
        }
        this.lock.readLock().acquire();
        try {
            Enumeration en = missing_msgs.elements();
            while (en.hasMoreElements()) {
                Long seqno = (Long)en.nextElement();
                Message msg = (Message)this.delivered_msgs.get(seqno);
                if (msg != null) {
                    ret.add(msg.copy());
                }
                if ((msg = (Message)this.received_msgs.get(seqno)) == null) continue;
                ret.add(msg.copy());
            }
            List list = ret;
            this.lock.readLock().release();
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message get(long sequence_num) {
        Long seqno = sequence_num;
        try {
            this.lock.readLock().acquire();
            try {
                Message msg = (Message)this.delivered_msgs.get(seqno);
                if (msg != null) {
                    Message message = msg;
                    return message;
                }
                msg = (Message)this.received_msgs.get(seqno);
                if (msg == null) return null;
                Message message = msg;
                return message;
            }
            finally {
                this.lock.readLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        boolean acquired = false;
        try {
            this.lock.readLock().acquire();
            acquired = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            int n = this.received_msgs.size();
            return n;
        }
        finally {
            if (acquired) {
                this.lock.readLock().release();
            }
        }
    }

    public int unsafeGetSize() {
        return this.received_msgs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            this.lock.readLock().acquire();
            try {
                sb.append("received_msgs: " + this.printReceivedMessages());
                sb.append(", delivered_msgs: " + this.printDeliveredMessages());
            }
            finally {
                this.lock.readLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(JGroupsStrings.NakReceiverWindow_FAILED_ACQUIRING_READ_LOCK, (Throwable)e);
            return "";
        }
        return sb.toString();
    }

    String printDeliveredMessages() {
        StringBuffer sb = new StringBuffer();
        Long min = null;
        Long max = null;
        if (this.delivered_msgs.size() > 0) {
            try {
                min = (Long)this.delivered_msgs.firstKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            try {
                max = (Long)this.delivered_msgs.lastKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
        }
        sb.append('[').append(min).append(" - ").append(max).append(']');
        if (min != null && max != null) {
            sb.append(" (size=" + (max - min) + ")");
        }
        return sb.toString();
    }

    String printReceivedMessages() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        if (this.received_msgs.size() > 0) {
            Long first = null;
            Long last = null;
            try {
                first = (Long)this.received_msgs.firstKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            try {
                last = (Long)this.received_msgs.lastKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            sb.append(first).append(" - ").append(last);
            int non_received = 0;
            for (Map.Entry entry : this.received_msgs.entrySet()) {
                if (entry.getValue() != null) continue;
                ++non_received;
            }
            sb.append(" (size=").append(this.received_msgs.size()).append(", missing=").append(non_received).append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    private void updateLowestSeen() {
        Long lowest_seqno = null;
        if (this.delivered_msgs.size() > 0) {
            try {
                lowest_seqno = (Long)this.delivered_msgs.firstKey();
                if (lowest_seqno != null) {
                    this.lowest_seen = lowest_seqno;
                }
            }
            catch (NoSuchElementException ex) {}
        } else if (this.received_msgs.size() > 0) {
            try {
                lowest_seqno = (Long)this.received_msgs.firstKey();
                if (this.received_msgs.get(lowest_seqno) != null) {
                    this.lowest_seen = lowest_seqno;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private void _reset() {
        this.received_msgs.clear();
        this.delivered_msgs.clear();
        this.head = 0L;
        this.tail = 0L;
        this.lowest_seen = 0L;
        this.highest_seen = 0L;
    }

    public static interface Listener {
        public void missingMessageReceived(long var1, Message var3);
    }
}

