/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectedException;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.blocks.MethodCall;
import com.gemstone.org.jgroups.stack.MessageProtocol;
import com.gemstone.org.jgroups.util.RspList;
import com.gemstone.org.jgroups.util.Util;
import java.util.Vector;

public class RpcProtocol
extends MessageProtocol {
    @Override
    public String getName() {
        return "RpcProtocol";
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
        byte[] buf = null;
        Message msg = null;
        try {
            buf = Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcProtocol_EXCEPTION_0, (Throwable)e);
            }
            return null;
        }
        msg = new Message(null, null, buf);
        return this.castMessage(dests, msg, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, int mode, long timeout) throws TimeoutException, SuspectedException {
        return this.callRemoteMethod(dest, method_name, new Object[0], new Class[0], mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, String[] signature, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout) throws TimeoutException, SuspectedException {
        byte[] buf = null;
        Message msg = null;
        try {
            buf = Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcProtocol_EXCEPTION_0, (Throwable)e);
            }
            return null;
        }
        msg = new Message(dest, null, buf);
        return this.sendMessage(msg, mode, timeout);
    }

    @Override
    public Object handle(Message req) {
        Object body = null;
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcProtocol_MESSAGE_OR_MESSAGE_BUFFER_IS_NULL);
            }
            return null;
        }
        try {
            body = req.getObject();
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcProtocol_EXCEPTION_0, (Throwable)e);
            }
            return e;
        }
        if (body == null || !(body instanceof MethodCall)) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcProtocol_MESSAGE_DOES_NOT_CONTAIN_A_METHODCALL_OBJECT);
            }
            return null;
        }
        MethodCall method_call = body;
        try {
            return method_call.invoke(this);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable x) {
            SystemFailure.checkFailure();
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcProtocol_FAILED_INVOKING_METHOD__0, method_call.getName(), x);
            }
            return x;
        }
    }

    @Override
    public boolean handleUpEvent(Event evt) {
        return true;
    }

    @Override
    public boolean handleDownEvent(Event evt) {
        return true;
    }
}

