/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.conf.ClassConfigurator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Marshaller {
    private static final ClassConfigurator mConfigurator;

    public static Externalizable read(ObjectInput in) throws IOException {
        try {
            boolean is_null = in.readBoolean();
            if (is_null) {
                return null;
            }
            boolean usemagic = in.readBoolean();
            Class extclass = null;
            if (usemagic) {
                int magic = in.readInt();
                extclass = mConfigurator.get(magic);
            } else {
                String magic = in.readUTF();
                extclass = mConfigurator.get(magic);
            }
            Externalizable newinstance = (Externalizable)extclass.newInstance();
            newinstance.readExternal(in);
            return newinstance;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable x) {
            SystemFailure.checkFailure();
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException(x.toString());
        }
    }

    public static void write(Externalizable inst, ObjectOutput out) throws IOException {
        boolean is_null = inst == null;
        try {
            out.writeBoolean(is_null);
            if (is_null) {
                return;
            }
            int magic = mConfigurator.getMagicNumber(inst.getClass());
            if (magic != -1) {
                out.writeBoolean(true);
                out.writeInt(magic);
            } else {
                out.writeBoolean(false);
                out.writeUTF(inst.getClass().getName());
            }
            inst.writeExternal(out);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException(x.toString());
        }
    }

    static {
        try {
            mConfigurator = ClassConfigurator.getInstance(true);
        }
        catch (ChannelException e) {
            throw new ExceptionInInitializerError(e.toString());
        }
    }
}

