/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PrintXMLTree {
    public static void print(PrintWriter out, Element root) {
        PrintXMLTree.print("", out, root);
    }

    protected static void print(String prepend, PrintWriter out, Element root) {
        if (root == null) {
            return;
        }
        PrintXMLTree.print(prepend, out, root, root.getAttributes());
        NodeList elements = root.getChildNodes();
        if (elements == null) {
            return;
        }
        int elementCount = elements.getLength();
        for (int i = 0; i < elementCount; ++i) {
            if (elements.item(i).getNodeType() != 1) continue;
            Element element = (Element)elements.item(i);
            PrintXMLTree.print(prepend, out, element, element.getAttributes());
        }
    }

    protected static void print(String prepend, PrintWriter out, Element element, NamedNodeMap attributes) {
        int i;
        out.print(prepend);
        out.print('<');
        out.print(element.getNodeName());
        if (attributes != null) {
            int attributeCount = attributes.getLength();
            for (i = 0; i < attributeCount; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                out.print(' ');
                out.print(attribute.getNodeName());
                out.print("=\"");
                out.print(PrintXMLTree.normalize(attribute.getNodeValue()));
                out.print('\"');
            }
        }
        out.println('>');
        NodeList list = element.getChildNodes();
        for (i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() == 1) {
                PrintXMLTree.print(prepend + "  ", out, (Element)list.item(i));
                continue;
            }
            if (list.item(i).getNodeType() != 3 || list.item(i).getNodeValue().trim().length() <= 0) continue;
            out.println(prepend + "  " + list.item(i).getNodeValue());
        }
        out.print(prepend + "</");
        out.print(element.getNodeName());
        out.println(">");
        out.flush();
    }

    public static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    continue block7;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }
}

