/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.oswego.concurrent.CondVar;
import com.gemstone.org.jgroups.oswego.concurrent.Mutex;
import com.gemstone.org.jgroups.oswego.concurrent.Sync;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.QueueClosedException;
import java.util.Vector;

public class Queue2 {
    Element head = null;
    Element tail = null;
    boolean closed = false;
    int size = 0;
    final Sync mutex = new Mutex();
    final CondVar add_condvar = new CondVar(this.mutex);
    final CondVar remove_condvar = new CondVar(this.mutex);
    int num_markers = 0;
    protected static final GemFireTracer log = GemFireTracer.getLog(Queue2.class);
    private static final Object endMarker = new Object();

    public Object getFirst() {
        return this.head != null ? this.head.obj : null;
    }

    public Object getLast() {
        return this.tail != null ? this.tail.obj : null;
    }

    public boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.Queue2_ARGUMENT_MUST_NOT_BE_NULL);
            }
            return;
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue2.add(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        try {
            this.mutex.acquire();
            Element el = new Element(obj);
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                this.tail.next = el;
                this.tail = el;
                ++this.size;
            }
            this.add_condvar.broadcast();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtHead(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.Queue2_ARGUMENT_MUST_NOT_BE_NULL);
            }
            return;
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue2.addAtHead(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        try {
            this.mutex.acquire();
            Element el = new Element(obj);
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                el.next = this.head;
                this.head = el;
                ++this.size;
            }
            this.add_condvar.broadcast();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() throws QueueClosedException {
        Object retval = null;
        try {
            this.mutex.acquire();
            while (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                boolean interrupted = Thread.interrupted();
                try {
                    this.add_condvar.await();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.removeInternal();
            if (retval == null && log.isErrorEnabled()) {
                log.error(JGroupsStrings.Queue2_ELEMENT_WAS_NULL_SHOULD_NEVER_BE_THE_CASE);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
        if (retval == endMarker) {
            this.close(false);
            throw new QueueClosedException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        try {
            this.mutex.acquire();
            if (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.add_condvar.timedwait(timeout);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.removeInternal();
            if (retval == null) {
                throw new TimeoutException();
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Object obj) throws QueueClosedException {
        boolean removed = false;
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.Queue2_ARGUMENT_MUST_NOT_BE_NULL);
            }
            return;
        }
        try {
            this.mutex.acquire();
            Element el = this.head;
            if (el == null) {
                return;
            }
            if (el.obj.equals(obj)) {
                this.head = el.next;
                el.next = null;
                if (this.size == 1) {
                    this.tail = this.head;
                }
                this.decrementSize();
                removed = true;
                return;
            }
            while (el.next != null) {
                if (el.next.obj.equals(obj)) {
                    Element tmp_el = el.next;
                    if (tmp_el == this.tail) {
                        this.tail = el;
                    }
                    el.next = el.next.next;
                    tmp_el.next = null;
                    this.decrementSize();
                    removed = true;
                    break;
                }
                el = el.next;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (removed) {
                this.remove_condvar.broadcast();
            }
            this.mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() throws QueueClosedException {
        Object retval = null;
        try {
            this.mutex.acquire();
            while (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                boolean interrupted = Thread.interrupted();
                try {
                    this.add_condvar.await();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            Object object = retval = this.head != null ? this.head.obj : null;
            if (retval == null && log.isErrorEnabled()) {
                log.error("retval is null: head=" + this.head + ", tail=" + this.tail + ", size()=" + this.size() + ", num_markers=" + this.num_markers + ", closed()=" + this.closed());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
        if (retval == endMarker) {
            this.close(false);
            throw new QueueClosedException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        try {
            this.mutex.acquire();
            if (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            Object object = retval = this.head != null ? this.head.obj : null;
            if (retval == null) {
                throw new TimeoutException();
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush_entries) {
        if (flush_entries) {
            try {
                this.add(endMarker);
                ++this.num_markers;
            }
            catch (QueueClosedException closed) {
                // empty catch block
            }
            return;
        }
        try {
            this.mutex.acquire();
            this.closed = true;
            try {
                this.add_condvar.broadcast();
                this.remove_condvar.broadcast();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(JGroupsStrings.Queue2_EXCEPTION_0, (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.num_markers = 0;
        if (!this.closed) {
            this.close(false);
        }
        try {
            this.mutex.acquire();
            this.size = 0;
            this.head = null;
            this.tail = null;
            this.closed = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
    }

    public int size() {
        return this.size - this.num_markers;
    }

    public String toString() {
        return "Queue2 (" + this.size() + ") messages";
    }

    public String debug() {
        return this.toString() + ", head=" + this.head + ", tail=" + this.tail + ", closed()=" + this.closed() + ", contents=" + this.getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getContents() {
        Vector<Object> retval = new Vector<Object>();
        try {
            this.mutex.acquire();
            Element el = this.head;
            while (el != null) {
                retval.addElement(el.obj);
                el = el.next;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty(long timeout) throws QueueClosedException, TimeoutException {
        long time_to_wait = timeout >= 0L ? timeout : 0L;
        try {
            this.mutex.acquire();
            if (timeout == 0L) {
                while (this.size > 0 && !this.closed) {
                    this.remove_condvar.await();
                }
            } else {
                long start_time = System.currentTimeMillis();
                while (time_to_wait > 0L && this.size > 0 && !this.closed) {
                    boolean interrupted = Thread.interrupted();
                    try {
                        this.remove_condvar.timedwait(time_to_wait);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    time_to_wait = timeout - (System.currentTimeMillis() - start_time);
                }
                if (this.size > 0) {
                    throw new TimeoutException("queue has " + this.size + " elements");
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mutex.release();
        }
    }

    private Object removeInternal() {
        if (this.head == null) {
            return null;
        }
        Element retval = this.head;
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        }
        this.decrementSize();
        this.remove_condvar.broadcast();
        if (this.head != null && this.head.obj == endMarker) {
            this.closed = true;
        }
        retval.next = null;
        return retval.obj;
    }

    void decrementSize() {
        --this.size;
        if (this.size < 0) {
            this.size = 0;
        }
    }

    static class Element {
        Object obj = null;
        Element next = null;

        Element(Object o) {
            this.obj = o;
        }

        public String toString() {
            return this.obj != null ? this.obj.toString() : "null";
        }
    }
}

