/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class TimeScheduler {
    private static final long SUSPEND_INTERVAL = 30000L;
    private static final long MAX_EXECUTION_TIME = 6000L;
    private static final int RUN = 0;
    private static final int SUSPEND = 1;
    private static final int STOPPING = 2;
    private static final int STOP = 3;
    private static final String THREAD_NAME = "TimeScheduler.Thread";
    private final Object thread_mutex = new Object();
    private volatile Thread thread = null;
    private volatile int thread_state = 1;
    private long suspend_interval = 30000L;
    private final TaskQueue queue = new TaskQueue();
    protected static final GemFireTracer log = GemFireTracer.getLog(TimeScheduler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toString(StringBuffer sb) {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.queue.toString(sb);
        }
    }

    public static void loadEmergencyClasses() {
    }

    public void emergencyClose() {
        this.thread_state = 3;
        Thread thr = this.thread;
        if (thr != null) {
            thr.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        Object object = this.thread_mutex;
        synchronized (object) {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread((Runnable)new Loop(), THREAD_NAME);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    private void _start() {
        this.thread_state = 0;
        this.startThread();
    }

    private void _unsuspend() {
        this.thread_state = 0;
        this.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _suspend() {
        this.thread_state = 1;
        Object object = this.thread_mutex;
        synchronized (object) {
            this.thread = null;
        }
    }

    private void _stopping() {
        this.thread_state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stop() {
        this.thread_state = 3;
        Object object = this.thread_mutex;
        synchronized (object) {
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _run() {
        while (true) {
            Task task;
            SystemFailure.checkFailure();
            Thread thr = this.thread;
            if (thr == null || thr.isInterrupted()) {
                return;
            }
            TaskQueue taskQueue = this.queue;
            synchronized (taskQueue) {
                long waitTime;
                IntTask intTask;
                thr = this.thread;
                if (thr == null || thr.isInterrupted()) {
                    return;
                }
                if (this.thread_state == 3) {
                    return;
                }
                if (this.queue.isEmpty()) {
                    if (this.thread_state == 2) {
                        return;
                    }
                    try {
                        this.queue.wait(this.suspend_interval);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    if (this.queue.isEmpty()) {
                        if (this.thread_state == 2) {
                            return;
                        }
                        this._suspend();
                        return;
                    }
                }
                IntTask ex = intTask = this.queue.getFirst();
                synchronized (ex) {
                    task = intTask.task;
                    if (task.cancelled()) {
                        this.queue.removeFirst();
                        continue;
                    }
                    long execTime = intTask.sched;
                    long currTime = System.currentTimeMillis();
                    waitTime = execTime - currTime;
                    if (waitTime <= 0L) {
                        long intervalTime = task.nextInterval();
                        long schedTime = intTask.relative ? currTime + intervalTime : execTime + intervalTime;
                        this.queue.rescheduleFirst(schedTime);
                    }
                }
                if (waitTime > 0L) {
                    try {
                        this.queue.wait(waitTime);
                    }
                    catch (InterruptedException ex2) {
                        return;
                    }
                }
            }
            long start = System.currentTimeMillis();
            try {
                long stop;
                long diff;
                task.run();
                if (!log.isWarnEnabled() || (diff = (stop = System.currentTimeMillis()) - start) < 6000L) continue;
                log.warn("task " + task + " took " + diff + "ms to execute, " + "please check why it is taking so long. It is delaying other tasks");
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                log.error(JGroupsStrings.TimeScheduler_FAILED_RUNNING_TASK__0, task, ex);
                continue;
            }
            break;
        }
    }

    public TimeScheduler(long suspend_interval) {
        this.suspend_interval = suspend_interval;
    }

    public TimeScheduler() {
        this(30000L);
    }

    public void setSuspendInterval(long s) {
        this.suspend_interval = s;
    }

    public long getSuspendInterval() {
        return this.suspend_interval;
    }

    public String dumpTaskQueue() {
        return this.queue != null ? this.queue.toString() : "<empty>";
    }

    public void add(Task t, boolean relative) {
        this.add(t, relative, false, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Task t, boolean relative, boolean useTimeForTest, long msTimeForTest) {
        long interval = t.nextInterval();
        if (interval < 0L) {
            return;
        }
        long time = useTimeForTest ? msTimeForTest : System.currentTimeMillis();
        long sched = time + interval;
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            IntTask itask = new IntTask(t, sched, relative);
            boolean added = this.queue.add(itask);
            switch (this.thread_state) {
                case 0: {
                    this.queue.notifyAll();
                    break;
                }
                case 1: {
                    this._unsuspend();
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    public void add(Task t) {
        this.add(t, true);
    }

    public int size() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            switch (this.thread_state) {
                case 0: {
                    break;
                }
                case 1: {
                    this._unsuspend();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this._start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        Thread myThread;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            switch (this.thread_state) {
                case 0: {
                    this._stopping();
                    break;
                }
                case 1: {
                    this._stop();
                    return;
                }
                case 2: {
                    return;
                }
                case 3: {
                    return;
                }
            }
            this.thread.interrupt();
        }
        Object object = this.thread_mutex;
        synchronized (object) {
            myThread = this.thread;
        }
        if (myThread != null) {
            for (int i = 0; i < 20 && myThread.isAlive(); ++i) {
                myThread.join(500L);
                if (!myThread.isAlive() || myThread.isInterrupted()) continue;
                log.getInternalLogWriter().warning(JGroupsStrings.TimeScheduler_TIMESCHEDULER_THREAD_ATE_AN_INTERRUPT_DURING_SHUTDOWN__RETRYING);
                myThread.interrupt();
            }
            if (myThread.isAlive()) {
                log.getInternalLogWriter().info(JGroupsStrings.TimeScheduler_TIMESCHEDULER_GIVING_UP_ON_STOPPING_SCHEDULER_THREAD_AFTER_WAITING_10_SECONDS);
            }
        }
        TaskQueue taskQueue2 = this.queue;
        synchronized (taskQueue2) {
            this.queue.clear();
            this._stop();
        }
    }

    private static class TaskQueue {
        private final SortedSet set = new TreeSet();

        public boolean add(IntTask t) {
            return this.set.add(t);
        }

        public void remove(IntTask t) {
            this.set.remove(t);
        }

        public IntTask getFirst() {
            return (IntTask)this.set.first();
        }

        public void removeFirst() {
            Iterator it = this.set.iterator();
            it.next();
            it.remove();
        }

        public void rescheduleFirst(long sched) {
            Iterator it = this.set.iterator();
            IntTask t = (IntTask)it.next();
            it.remove();
            t.sched = sched;
            this.set.add(t);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public void clear() {
            this.set.clear();
        }

        public int size() {
            return this.set.size();
        }

        public String toString() {
            return this.set.toString();
        }

        public void toString(StringBuffer sb) {
            sb.append(this.set.toString());
        }
    }

    protected class Loop
    implements Runnable {
        protected Loop() {
        }

        @Override
        public void run() {
            try {
                TimeScheduler.this._run();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                log.error(JGroupsStrings.TimeScheduler_EXCEPTION_IN_LOOP, t);
            }
        }
    }

    private static class IntTask
    implements Comparable {
        public final Task task;
        public long sched;
        public final boolean relative;

        public IntTask(Task task, long sched, boolean relative) {
            this.task = task;
            this.sched = sched;
            this.relative = relative;
        }

        public int compareTo(Object obj) {
            int otherHash;
            if (!(obj instanceof IntTask)) {
                return -1;
            }
            IntTask other = (IntTask)obj;
            if (this.sched < other.sched) {
                return -1;
            }
            if (this.sched > other.sched) {
                return 1;
            }
            int myHash = System.identityHashCode(this.task);
            int diff = myHash - (otherHash = System.identityHashCode(other.task));
            if (diff == 0 && this.task != other.task) {
                return 1;
            }
            return diff;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof IntTask)) {
                return false;
            }
            return this.task == ((IntTask)o).task;
        }

        public int hashCode() {
            return System.identityHashCode(this.task);
        }

        public String toString() {
            if (this.task == null) {
                return "<unnamed>";
            }
            return "(" + this.task.toString() + "; sched=" + this.sched + ")" + "@" + Long.toHexString(this.task.hashCode());
        }
    }

    public static interface CancellableTask
    extends Task {
        public void cancel();
    }

    public static interface Task {
        public boolean cancelled();

        public long nextInterval();

        public void run();
    }
}

