/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.json;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.org.json.JSONArray;
import com.gemstone.org.json.JSONException;
import com.gemstone.org.json.JSONString;
import com.gemstone.org.json.JSONTokener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class JSONObject {
    private final Map map = new LinkedHashMap();
    public static final Object NULL = new Null();
    public static ThreadLocal<Set> cyclicDependencySet = new ThreadLocal();
    public static ThreadLocal<Boolean> cyclicDepChkEnabled = new ThreadLocal();

    public JSONObject() {
    }

    public JSONObject(JSONObject jo, String[] names) {
        this();
        for (int i = 0; i < names.length; ++i) {
            try {
                this.putOnce(names[i], jo.opt(names[i]));
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key2 = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key2, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map) {
        if (map != null) {
            for (Map.Entry e : map.entrySet()) {
                Object value2 = e.getValue();
                if (value2 == null) continue;
                this.map.put(e.getKey(), JSONObject.wrap(value2));
            }
        }
    }

    public JSONObject(Object bean) {
        this();
        this.populateMap(bean);
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                this.putOpt(name, c.getField(name).get(object));
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public JSONObject(String baseName, Locale locale) throws JSONException {
        this();
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, Thread.currentThread().getContextClassLoader());
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key2 = keys.nextElement();
            if (!(key2 instanceof String)) continue;
            String[] path = key2.split("\\.");
            int last = path.length - 1;
            JSONObject target = this;
            for (int i = 0; i < last; ++i) {
                String segment = path[i];
                JSONObject nextTarget = target.optJSONObject(segment);
                if (nextTarget == null) {
                    nextTarget = new JSONObject();
                    target.put(segment, nextTarget);
                }
                target = nextTarget;
            }
            target.put(path[last], bundle.getString(key2));
        }
    }

    public JSONObject accumulate(String key2, Object value2) throws JSONException {
        JSONObject.testValidity(value2);
        Object object = this.opt(key2);
        if (object == null) {
            this.put(key2, value2 instanceof JSONArray ? new JSONArray().put(value2) : value2);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value2);
        } else {
            this.put(key2, new JSONArray().put(object).put(value2));
        }
        return this;
    }

    public JSONObject append(String key2, Object value2) throws JSONException {
        JSONObject.testValidity(value2);
        Object object = this.opt(key2);
        if (object == null) {
            this.put(key2, new JSONArray().put(value2));
        } else if (object instanceof JSONArray) {
            this.put(key2, ((JSONArray)object).put(value2));
        } else {
            throw new JSONException("JSONObject[" + key2 + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object get(String key2) throws JSONException {
        if (key2 == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(key2);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a Boolean.");
    }

    public double getDouble(String key2) throws JSONException {
        Object object = this.get(key2);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a number.");
        }
    }

    public int getInt(String key2) throws JSONException {
        Object object = this.get(key2);
        try {
            return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not an int.");
        }
    }

    public JSONArray getJSONArray(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a JSONObject.");
    }

    public long getLong(String key2) throws JSONException {
        Object object = this.get(key2);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a long.");
        }
    }

    public static String[] getNames(JSONObject jo) {
        int length = jo.length();
        if (length == 0) {
            return null;
        }
        Iterator iterator = jo.keys();
        String[] names = new String[length];
        int i = 0;
        while (iterator.hasNext()) {
            names[i] = (String)iterator.next();
            ++i;
        }
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = fields[i].getName();
        }
        return names;
    }

    public String getString(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof String) {
            return (String)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] not a string.");
    }

    public boolean has(String key2) {
        return this.map.containsKey(key2);
    }

    public JSONObject increment(String key2) throws JSONException {
        Object value2 = this.opt(key2);
        if (value2 == null) {
            this.put(key2, 1);
        } else if (value2 instanceof Integer) {
            this.put(key2, (Integer)value2 + 1);
        } else if (value2 instanceof Long) {
            this.put(key2, (Long)value2 + 1L);
        } else if (value2 instanceof Double) {
            this.put(key2, (Double)value2 + 1.0);
        } else if (value2 instanceof Float) {
            this.put(key2, ((Float)value2).floatValue() + 1.0f);
        } else {
            throw new JSONException("Unable to increment [" + JSONObject.quote(key2) + "].");
        }
        return this;
    }

    public boolean isNull(String key2) {
        return NULL.equals(this.opt(key2));
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String key2) {
        return key2 == null ? null : this.map.get(key2);
    }

    public boolean optBoolean(String key2) {
        return this.optBoolean(key2, false);
    }

    public boolean optBoolean(String key2, boolean defaultValue) {
        try {
            return this.getBoolean(key2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key2) {
        return this.optDouble(key2, Double.NaN);
    }

    public double optDouble(String key2, double defaultValue) {
        try {
            return this.getDouble(key2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key2) {
        return this.optInt(key2, 0);
    }

    public int optInt(String key2, int defaultValue) {
        try {
            return this.getInt(key2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key2) {
        Object o = this.opt(key2);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key2) {
        Object object = this.opt(key2);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(String key2) {
        return this.optLong(key2, 0L);
    }

    public long optLong(String key2, long defaultValue) {
        try {
            return this.getLong(key2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key2) {
        return this.optString(key2, "");
    }

    public String optString(String key2, String defaultValue) {
        Object object = this.opt(key2);
        return NULL.equals(object) ? defaultValue : object.toString();
    }

    private void populateMap(Object bean) {
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
                String name = method.getName();
                String key2 = "";
                if (name.startsWith("get")) {
                    key2 = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key2 = name.substring(2);
                }
                if (key2.length() <= 0 || !Character.isUpperCase(key2.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key2.length() == 1) {
                    key2 = key2.toLowerCase();
                } else if (!Character.isUpperCase(key2.charAt(1))) {
                    key2 = key2.substring(0, 1).toLowerCase() + key2.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                if (result == null) continue;
                this.map.put(key2, JSONObject.wrap(result));
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.map.put("type-class", klass.getCanonicalName());
    }

    public JSONObject put(String key2, boolean value2) throws JSONException {
        this.put(key2, value2 ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key2, Collection value2) throws JSONException {
        this.put(key2, new JSONArray(value2));
        return this;
    }

    public JSONObject put(String key2, double value2) throws JSONException {
        this.put(key2, new Double(value2));
        return this;
    }

    public JSONObject put(String key2, int value2) throws JSONException {
        this.put(key2, new Integer(value2));
        return this;
    }

    public JSONObject put(String key2, long value2) throws JSONException {
        this.put(key2, new Long(value2));
        return this;
    }

    public JSONObject put(String key2, Map value2) throws JSONException {
        this.put(key2, new JSONObject(value2));
        return this;
    }

    public JSONObject put(String key2, Object value2) throws JSONException {
        if (key2 == null) {
            throw new JSONException("Null key.");
        }
        if (value2 != null) {
            JSONObject.testValidity(value2);
            this.map.put(key2, value2);
        } else {
            this.remove(key2);
        }
        return this;
    }

    public JSONObject putOnce(String key2, Object value2) throws JSONException {
        if (key2 != null && value2 != null) {
            if (this.opt(key2) != null) {
                throw new JSONException("Duplicate key \"" + key2 + "\"");
            }
            this.put(key2, value2);
        }
        return this;
    }

    public JSONObject putOpt(String key2, Object value2) throws JSONException {
        if (key2 != null && value2 != null) {
            this.put(key2, value2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JSONObject.quote(string, sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    public static Writer quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String hhhh = "000" + Integer.toHexString(c);
                        w.write("\\u" + hhhh.substring(hhhh.length() - 4));
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
        return w;
    }

    public Object remove(String key2) {
        return this.map.remove(key2);
    }

    public static Object stringToValue(String string) {
        block10: {
            if (string.equals("")) {
                return string;
            }
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (string.equalsIgnoreCase("null")) {
                return NULL;
            }
            char b = string.charAt(0);
            if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
                try {
                    if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                        Double d = Double.valueOf(string);
                        if (!d.isInfinite() && !d.isNaN()) {
                            return d;
                        }
                        break block10;
                    }
                    Long myLong = new Long(string);
                    if (myLong == (long)myLong.intValue()) {
                        return new Integer(myLong.intValue());
                    }
                    return myLong;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public static void testValidity(Object o) throws JSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int indentFactor) throws JSONException {
        StringWriter w = new StringWriter();
        StringBuffer stringBuffer = w.getBuffer();
        synchronized (stringBuffer) {
            return this.write(w, indentFactor, 0).toString();
        }
    }

    public static String valueToString(Object value2) throws JSONException {
        if (value2 == null || value2.equals(null)) {
            return "null";
        }
        if (value2 instanceof JSONString) {
            String object;
            try {
                object = ((JSONString)value2).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (object instanceof String) {
                return object;
            }
            throw new JSONException("Bad value from toJSONString: " + object);
        }
        if (value2 instanceof Number) {
            return JSONObject.numberToString((Number)value2);
        }
        if (value2 instanceof Boolean || value2 instanceof JSONObject || value2 instanceof JSONArray) {
            return value2.toString();
        }
        if (value2 instanceof Map) {
            return new JSONObject((Map)value2).toString();
        }
        if (value2 instanceof Collection) {
            return new JSONArray((Collection)value2).toString();
        }
        if (value2.getClass().isArray()) {
            return new JSONArray(value2).toString();
        }
        return JSONObject.quote(value2.toString());
    }

    public static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null || object.getClass().equals(GemFireCacheImpl.class)) {
                return object.toString();
            }
            if (cyclicDepChkEnabled.get() != null) {
                if (cyclicDepChkEnabled.get().booleanValue() && cyclicDependencySet.get().contains(object)) {
                    return object.getClass().getCanonicalName();
                }
                cyclicDependencySet.get().add(object);
                return new JSONObject(object);
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    static final Writer writeValue(Writer writer, Object value2, int indentFactor, int indent) throws JSONException, IOException {
        if (value2 == null || value2.equals(null)) {
            writer.write("null");
        } else if (value2 instanceof JSONObject) {
            ((JSONObject)value2).write(writer, indentFactor, indent);
        } else if (value2 instanceof JSONArray) {
            ((JSONArray)value2).write(writer, indentFactor, indent);
        } else if (value2 instanceof Map) {
            new JSONObject((Map)value2).write(writer, indentFactor, indent);
        } else if (value2 instanceof Collection) {
            new JSONArray((Collection)value2).write(writer, indentFactor, indent);
        } else if (value2.getClass().isArray()) {
            new JSONArray(value2).write(writer, indentFactor, indent);
        } else if (value2 instanceof Number) {
            writer.write(JSONObject.numberToString((Number)value2));
        } else if (value2 instanceof Boolean) {
            writer.write(value2.toString());
        } else if (value2 instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value2).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            writer.write(o != null ? o.toString() : JSONObject.quote(value2.toString()));
        } else {
            JSONObject.quote(value2.toString(), writer);
        }
        return writer;
    }

    static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.length();
            Iterator keys = this.keys();
            writer.write(123);
            if (length == 1) {
                Object key2 = keys.next();
                writer.write(JSONObject.quote(key2.toString()));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                JSONObject.writeValue(writer, this.map.get(key2), indentFactor, indent);
            } else if (length != 0) {
                int newindent = indent + indentFactor;
                while (keys.hasNext()) {
                    Object key3 = keys.next();
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newindent);
                    writer.write(JSONObject.quote(key3.toString()));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    JSONObject.writeValue(writer, this.map.get(key3), indentFactor, newindent);
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

