/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.Config;
import com.springsource.vfabric.licensing.client.LicenseException;
import com.springsource.vfabric.licensing.log.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;

public class Ec2Metadata {
    private final String instanceType;
    private final int numComputeUnits;
    private static Logger LOG = Logger.getLogger(Ec2Metadata.class);
    private final String INSTANCETYPE_URL = "http://169.254.169.254/latest/meta-data/instance-type";

    public Ec2Metadata() throws LicenseException {
        String computeUnitsStr;
        InputStream stream = null;
        ClassLoader cl = Ec2Metadata.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl != null) {
            stream = cl.getResourceAsStream("ec2-instances.properties");
        }
        if (stream == null) {
            throw new LicenseException("Could not load EC2 instance type map");
        }
        try {
            URL url = new URL("http://169.254.169.254/latest/meta-data/instance-type");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(Config.getEc2ConnectTimeout());
            conn.setReadTimeout(Config.getEc2ReadTimeout());
            LOG.debug("GET reponse message: " + conn.getResponseMessage());
            int responseCode = conn.getResponseCode();
            if (200 != responseCode) {
                throw new LicenseException("Bad response from ec2 metadata url.");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.instanceType = reader.readLine();
            reader.close();
            conn.disconnect();
            Properties instanceMap = new Properties();
            instanceMap.load(stream);
            computeUnitsStr = instanceMap.getProperty(this.instanceType);
            if (computeUnitsStr == null) {
                throw new LicenseException("No instance type '" + this.instanceType + "' in instance map");
            }
        }
        catch (IOException e) {
            throw new LicenseException("No connection to ec2 metadata, " + e);
        }
        try {
            float num = Float.parseFloat(computeUnitsStr);
            this.numComputeUnits = (int)Math.floor(num);
        }
        catch (NumberFormatException e) {
            throw new LicenseException("Could not parse compute units number string '" + computeUnitsStr + "'");
        }
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public int getNumComputeUnits() {
        return this.numComputeUnits;
    }
}

