/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.GuestInfoAccessor;
import com.springsource.vfabric.licensing.client.GuestInfoException;
import com.springsource.vfabric.licensing.client.LicenseProvider;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalStateManager;
import com.springsource.vfabric.licensing.client.ServerLicenseCombiner;
import com.springsource.vfabric.licensing.events.ConsumeServerLicenseEvent;
import com.springsource.vfabric.licensing.events.EventManager;
import com.springsource.vfabric.licensing.log.Logger;
import com.springsource.vfabric.licensing.state.ComponentUsage;
import com.springsource.vfabric.licensing.state.InstanceState;
import com.springsource.vfabric.licensing.state.LicenseState;
import com.springsource.vfabric.licensing.state.LicenseStateException;
import com.springsource.vfabric.licensing.state.ServerLicenseState;
import java.util.Collection;
import java.util.Date;

class GuestInfoLicenseProvider
implements LicenseProvider {
    LicenseState currentLicenseInfo = null;
    private final String componentId;
    private final String componentVersion;
    private final GuestInfoAccessor guestInfo;
    private final LocalStateManager localState;
    private final EventManager eventMgr;
    private static Logger LOG = Logger.getLogger(GuestInfoLicenseProvider.class);

    public GuestInfoLicenseProvider(String componentId, String componentVersion, GuestInfoAccessor guestInfo, LocalStateManager localState, EventManager eventMgr) throws GuestInfoException {
        this.componentId = componentId;
        this.componentVersion = componentVersion;
        this.localState = localState;
        this.eventMgr = eventMgr;
        this.guestInfo = guestInfo;
    }

    @Override
    public LicenseState getComponentLicenseState() {
        try {
            String licenseStateString = this.guestInfo.readVariable(this.componentId + ".serverLicenseState");
            ServerLicenseState fullState = ServerLicenseState.deserialize(licenseStateString);
            for (ServerLicenseState.License serverLicense : fullState.getLicenses()) {
                this.eventMgr.saveEvent(new ConsumeServerLicenseEvent(serverLicense));
            }
            return ServerLicenseCombiner.combine(fullState);
        }
        catch (LicenseStateException e) {
            LOG.warn("Unable to parse LicenseState from guest info", e);
            return null;
        }
        catch (GuestInfoException e) {
            LOG.info("Failed to read guest info value for component '" + this.componentId + "'");
            return null;
        }
    }

    @Override
    public void notifyStateChanged() {
        Collection<InstanceState> currentStates;
        try {
            currentStates = this.localState.getCurrentStates();
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Unable to retrieve current state from storage, cannot report license usage");
            return;
        }
        ComponentUsage componentUsage = new ComponentUsage(this.componentId, this.componentVersion, new Date(), currentStates);
        try {
            this.guestInfo.writeVariable(this.componentId + ".clientLicenseState", componentUsage.serialize());
        }
        catch (LicenseStateException e) {
            LOG.warn("Failed to serialize license state for component '" + this.componentId + "'" + e.getMessage());
        }
        catch (GuestInfoException e) {
            LOG.info("Failed to write guestinfo for component '" + this.componentId + "': " + e.getMessage());
        }
    }
}

