/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.LicenseException;
import com.springsource.vfabric.licensing.client.LicenseProvider;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalStateManager;
import com.springsource.vfabric.licensing.client.ServerLicenseCombiner;
import com.springsource.vfabric.licensing.events.ConsumeServerLicenseEvent;
import com.springsource.vfabric.licensing.events.EventManager;
import com.springsource.vfabric.licensing.log.Logger;
import com.springsource.vfabric.licensing.state.ComponentUsage;
import com.springsource.vfabric.licensing.state.InstanceState;
import com.springsource.vfabric.licensing.state.LicenseState;
import com.springsource.vfabric.licensing.state.LicenseStateException;
import com.springsource.vfabric.licensing.state.ServerLicenseState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpLicenseProvider
implements LicenseProvider {
    private static final Logger LOG = Logger.getLogger(HttpLicenseProvider.class);
    private static final String SET_COMPONENT_STATE_PATH = "/vfabric-license-server/component-manager/set-component-states/";
    private static final String GET_COMPONENT_STATE_PATH = "/vfabric-license-server/component-manager/get-component-state/";
    private final String componentId;
    private final String componentVersion;
    private URL serverUrl;
    private String ipAddress;
    private final int numCpus;
    private final LocalStateManager stateMgr;
    private final EventManager eventMgr;
    private static TrustManager[] TRUST_ALL_CERTS = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static HostnameVerifier ALLOW_ALL_HOSTS = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private final SSLContext sslContext;

    public HttpLicenseProvider(String componentId, String componentVersion, int numCpus, URL serverUrl, LocalStateManager stateMgr, EventManager eventMgr) throws LicenseException {
        this.componentId = componentId;
        this.componentVersion = componentVersion;
        HttpLicenseProvider.verifyUrl(serverUrl);
        this.serverUrl = serverUrl;
        this.stateMgr = stateMgr;
        this.eventMgr = eventMgr;
        this.numCpus = numCpus;
        this.ipAddress = HttpLicenseProvider.acquireLocalIpAddress();
        try {
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(null, TRUST_ALL_CERTS, new SecureRandom());
        }
        catch (GeneralSecurityException e) {
            throw new LocalLicenseConfigurationException("Internal error: " + e);
        }
        this.sendComponentUsage();
    }

    private static void verifyUrl(URL url) throws LicenseException {
        if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            throw new LicenseException("Unsupported protocol in server URL: " + url.toString());
        }
        if (url.getHost() == null || url.getHost().length() == 0) {
            throw new LicenseException("No host specified in server URL: " + url.toString());
        }
        if (url.getQuery() != null) {
            throw new LicenseException("Unexpected query in server URL: " + url.toString());
        }
    }

    @Override
    public void notifyStateChanged() {
        try {
            this.sendComponentUsage();
        }
        catch (LicenseException e) {
            LOG.error("Failed to report license usage to HTTP license server: " + e);
        }
    }

    private void sendComponentUsage() throws LicenseException {
        String requestBody;
        Collection<InstanceState> currentStates = this.stateMgr.getCurrentStates();
        ComponentUsage toSend = new ComponentUsage(this.componentId, this.componentVersion, new Date(), currentStates, this.ipAddress, this.numCpus);
        try {
            requestBody = toSend.serialize();
        }
        catch (LicenseStateException e) {
            throw new LicenseException("Failed to serialize license state: " + e);
        }
        try {
            URL url = new URL(this.serverUrl.toString() + SET_COMPONENT_STATE_PATH);
            String response = this.doHttpPost(url, requestBody);
            if (response != null) {
                LOG.debug("response: " + response);
            }
        }
        catch (MalformedURLException e) {
            throw new LicenseException("HTTP POST to url " + this.serverUrl + " failed: " + e);
        }
    }

    @Override
    public LicenseState getComponentLicenseState() {
        String response = null;
        LicenseState licenseState = null;
        StringBuilder path = new StringBuilder(GET_COMPONENT_STATE_PATH);
        path.append(this.ipAddress).append("/").append(this.componentId).append("/").append(this.componentVersion).append("/").append(new Date().getTime()).append("/");
        try {
            URL url = new URL(this.serverUrl.toString() + path.toString());
            response = this.doHttpGet(url);
        }
        catch (LicenseException e) {
            LOG.error("Failed to get license state from server: " + e);
        }
        catch (MalformedURLException e) {
            LOG.error("Bad URL for license state: " + e);
        }
        try {
            if (response != null) {
                LOG.debug("response: " + response);
                ServerLicenseState serverState = ServerLicenseState.deserialize(response);
                for (ServerLicenseState.License serverLicense : serverState.getLicenses()) {
                    this.eventMgr.saveEvent(new ConsumeServerLicenseEvent(serverLicense));
                }
                licenseState = ServerLicenseCombiner.combine(serverState);
            }
        }
        catch (LicenseStateException e) {
            LOG.error("Failed to deserialize LicenseState from the HTTP response", e);
        }
        return licenseState;
    }

    protected void setHttpURLConnection(HttpURLConnection httpUrlConnection) {
    }

    protected HttpURLConnection createHttpURLConnection(URL url) throws LicenseException {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (url.getProtocol().equals("https")) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslContext.getSocketFactory());
                ((HttpsURLConnection)connection).setHostnameVerifier(ALLOW_ALL_HOSTS);
            }
            return connection;
        }
        catch (IOException e) {
            throw new LicenseException("Could not create connection to license server:" + e);
        }
        catch (ClassCastException e) {
            throw new LicenseException("Could not use " + url.toString() + " to create an http or https connection: " + e);
        }
    }

    public static String acquireLocalIpAddress() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            return localhost.getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to acquire IP address", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doHttpPost(URL url, String data) throws LicenseException {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            try {
                String line;
                conn = this.createHttpURLConnection(url);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
                conn.setRequestProperty("Accept", "text/plain");
                conn.setDoOutput(true);
                OutputStream output = conn.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
                writer.write(data);
                writer.flush();
                writer.close();
                output.close();
                int responseCode = conn.getResponseCode();
                LOG.debug("Post response code: " + responseCode);
                String responseString = conn.getResponseMessage();
                LOG.debug("Post response message: " + responseString);
                if (200 != responseCode) {
                    throw new LicenseException("POST received failed response code '" + responseCode + "'");
                }
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder responseBody = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    responseBody.append(line);
                }
                String response = responseBody.toString();
                if (conn.getContentType().contains("text/plain")) {
                    String string2 = response;
                    return string2;
                }
                LOG.warn("POST server response should be text/plain, not " + conn.getContentType());
                String string = URLDecoder.decode(responseBody.toString(), "UTF-8");
                return string;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        catch (IOException e) {
            throw new LicenseException("An error occurred while performing an HTTP POST " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doHttpGet(URL url) throws LicenseException {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            try {
                String line;
                conn = this.createHttpURLConnection(url);
                conn.setRequestProperty("Accept", "text/plain");
                LOG.debug("GET reponse message: " + conn.getResponseMessage());
                int responseCode = conn.getResponseCode();
                if (200 != responseCode) {
                    throw new LicenseException("GET received failed response code '" + responseCode + "'");
                }
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder responseBody = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    responseBody.append(line).append('\n');
                }
                reader.close();
                conn.disconnect();
                if (conn.getContentType().contains("text/plain")) {
                    String string2 = responseBody.toString();
                    return string2;
                }
                LOG.warn("GET server response should be text/plain, not " + conn.getContentType());
                String string = URLDecoder.decode(responseBody.toString(), "UTF-8");
                return string;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        catch (IOException e) {
            throw new LicenseException("An error occurred while performing an HTTP GET" + e);
        }
    }
}

