/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.Config;
import com.springsource.vfabric.licensing.client.CpuInfo;
import com.springsource.vfabric.licensing.client.Ec2Metadata;
import com.springsource.vfabric.licensing.client.LicenseException;
import com.springsource.vfabric.licensing.client.LinuxCpuInfo;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalStateManager;
import com.springsource.vfabric.licensing.client.SerialNumberReader;
import com.springsource.vfabric.licensing.client.WindowsCpuInfo;
import com.springsource.vfabric.licensing.events.EventManager;
import com.springsource.vfabric.licensing.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.LinkedList;

public class LicenseManagerEnvironment {
    private static final String OS_TYPE;
    private static final boolean IS_WINDOWS;
    private static final boolean IS_UNIX;
    private static Integer correctedCpuCount;
    private final String componentId;
    private final LocalStateManager stateManager;
    private final EventManager eventManager;
    private final File homeFolder;
    private final Collection<String> serialNumbers;
    private static Logger LOG;

    LicenseManagerEnvironment(String componentId, Collection<SerialNumberReader> serialNumberReaders, File homeFolder) throws LocalLicenseConfigurationException {
        this.componentId = componentId;
        this.serialNumbers = new LinkedList<String>();
        this.addDefaultSerialNumbers();
        if (serialNumberReaders != null) {
            for (SerialNumberReader reader : serialNumberReaders) {
                this.addSerialNumbers(reader.getSerialNumbers());
            }
        }
        if (homeFolder == null) {
            homeFolder = this.getDefaultHomeFolder();
        }
        if (!homeFolder.exists() || !homeFolder.isDirectory() || homeFolder.mkdirs()) {
            throw new LocalLicenseConfigurationException("Specified home folder '" + homeFolder.getAbsolutePath() + "' must be an existing directory.");
        }
        this.homeFolder = homeFolder;
        File licenseStateFile = new File(homeFolder.getAbsolutePath() + File.separator + componentId + "-license.cfg");
        this.stateManager = new LocalStateManager(componentId, licenseStateFile);
        File eventsFile = new File(homeFolder.getAbsolutePath() + File.separator + componentId + "-events.txt");
        this.eventManager = new EventManager(eventsFile);
        LOG.debug("Home folder = '" + homeFolder.getAbsolutePath());
        LOG.debug("Local state = '" + licenseStateFile.getAbsolutePath());
        LOG.debug("Events      = '" + eventsFile.getAbsolutePath());
    }

    LicenseManagerEnvironment(String componentId, Collection<String> serialNumbers, File licenseStateFile, File eventsFile) throws LocalLicenseConfigurationException {
        this.componentId = componentId;
        this.serialNumbers = new LinkedList<String>();
        if (serialNumbers == null || serialNumbers.size() == 0) {
            this.addDefaultSerialNumbers();
        } else {
            this.addSerialNumbers(serialNumbers);
        }
        this.stateManager = new LocalStateManager(componentId, licenseStateFile);
        this.eventManager = new EventManager(eventsFile);
        this.homeFolder = this.getDefaultHomeFolder();
    }

    private File getDefaultHomeFolder() throws LocalLicenseConfigurationException {
        String path;
        if (IS_WINDOWS) {
            path = System.getenv("ALLUSERSPROFILE") + "\\VMware\\vFabric";
        } else if (IS_UNIX) {
            path = "/opt/vmware/vFabric";
        } else {
            LOG.warn("Unsupported system: " + OS_TYPE + " assuming something unix-like");
            path = "/opt/vmware/vFabric";
        }
        return new File(path);
    }

    public static File[] getDefaultSerialNumberFiles(String componentId) throws LocalLicenseConfigurationException {
        String path;
        if (IS_WINDOWS) {
            path = System.getenv("ALLUSERSPROFILE") + "\\VMware\\vFabric";
        } else if (IS_UNIX) {
            path = "/etc/opt/vmware/vfabric";
        } else {
            LOG.warn("Unsupported system: " + OS_TYPE + " assuming something unix-like");
            path = "/etc/opt/vmware/vfabric";
        }
        return new File[]{new File(path + File.separator + componentId + "-serial-numbers.txt"), new File(path + File.separator + "vfabric-serial-numbers.txt")};
    }

    private void addDefaultSerialNumbers() throws LocalLicenseConfigurationException {
        File[] files = LicenseManagerEnvironment.getDefaultSerialNumberFiles(this.componentId);
        LOG.debug("Looking up serials numbers from filesystem...");
        for (File file : files) {
            LOG.debug("Reading serial numbers in " + file.getAbsolutePath());
            SerialNumberReader reader = new SerialNumberReader(file);
            Collection<String> serials = reader.getSerialNumbers();
            for (String serial : serials) {
                LOG.debug("Found " + serial);
            }
            this.addSerialNumbers(reader.getSerialNumbers());
        }
    }

    private void addSerialNumbers(Collection<String> serials) {
        for (String serial : serials) {
            if (!this.serialNumbers.contains(serial)) {
                this.serialNumbers.add(serial);
                continue;
            }
            LOG.info("Ignoring duplicate serial number " + serial);
        }
    }

    public static File getDefaultDormantLicensePath() throws LocalLicenseConfigurationException {
        if (IS_WINDOWS) {
            String allusers = System.getenv("ALLUSERSPROFILE");
            return new File(allusers + "\\VMware\\vFabric\\licenses\\");
        }
        if (IS_UNIX) {
            return new File("/opt/vmware/vFabric/licenses/");
        }
        LOG.warn("Unsupported system: " + OS_TYPE + " assuming something unix-like");
        return new File("/opt/vmware/vFabric/licenses/");
    }

    public static void createFileIfNotExist(File infile) throws LocalLicenseConfigurationException {
        try {
            File file = new File(infile.getCanonicalPath());
            File parent = file.getParentFile();
            if (!parent.mkdirs()) {
                LOG.debug("Unable to create parent directory " + parent.getAbsolutePath() + ". Assuming it already exists.");
            }
            if (file.exists() && !file.isFile()) {
                throw new LocalLicenseConfigurationException("State file exists but is NOT a regular file " + file.getAbsolutePath());
            }
            if (!file.createNewFile()) {
                LOG.debug("State file already exists: " + file.getAbsolutePath());
            }
            RandomAccessFile testRaf = new RandomAccessFile(file, "rw");
            testRaf.close();
            LOG.info("License state file " + file.getAbsolutePath() + " is ready");
        }
        catch (IOException e) {
            throw new LocalLicenseConfigurationException("Failed to access/create local file " + infile.getAbsolutePath() + ": " + e);
        }
    }

    public LocalStateManager getStateManager() {
        return this.stateManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isLinux() {
        return IS_UNIX;
    }

    public Collection<String> getSerialNumbers() {
        return this.serialNumbers;
    }

    public File getLicenseStateFile() {
        return this.stateManager.getLocalStateFile();
    }

    public File getHomeFolder() {
        return this.homeFolder;
    }

    private static int calcCorrectedCpuCount() {
        try {
            Ec2Metadata ec2 = new Ec2Metadata();
            LOG.info("EC2 instance type is " + ec2.getInstanceType() + ", " + ec2.getNumComputeUnits() + " compute units.");
            return ec2.getNumComputeUnits();
        }
        catch (LicenseException e) {
            CpuInfo cpuInfo;
            LOG.info("No ec2 info available: " + e);
            if (LicenseManagerEnvironment.isLinux()) {
                String cpuInfoFile = Config.getLinuxRuntimeInfo();
                try {
                    cpuInfo = new LinuxCpuInfo(new FileInputStream(cpuInfoFile));
                }
                catch (FileNotFoundException e2) {
                    LOG.warn("No cpuinfo file, cannot get cpu/core info on '" + OS_TYPE + "'.");
                    return Runtime.getRuntime().availableProcessors();
                }
            } else if (LicenseManagerEnvironment.isWindows()) {
                cpuInfo = new WindowsCpuInfo();
            } else {
                LOG.error("Could not calculate cpu count on non-windows, non-linux system");
                return 1;
            }
            int cpuCount = 0;
            for (int count : cpuInfo.getCoreCounts()) {
                cpuCount += count;
            }
            return cpuCount;
        }
    }

    public static synchronized int getCorrectedCpuCount() {
        long configVal = Config.getCpuCount();
        if (configVal > 0L) {
            LOG.debug("using test configuration value for corrected cpu count, value = " + configVal);
            return (int)configVal;
        }
        if (correctedCpuCount == null) {
            correctedCpuCount = LicenseManagerEnvironment.calcCorrectedCpuCount();
            LOG.debug("first time access of corrected cpu count, value = " + correctedCpuCount);
        }
        return correctedCpuCount;
    }

    static {
        correctedCpuCount = null;
        OS_TYPE = System.getProperty("os.name").toLowerCase();
        IS_WINDOWS = OS_TYPE.contains("win");
        IS_UNIX = OS_TYPE.contains("nix") || OS_TYPE.contains("nux") || OS_TYPE.contains("sunos") || OS_TYPE.contains("mac os x");
        LOG = Logger.getLogger(LicenseManagerEnvironment.class);
    }
}

