/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.HttpLicenseProvider;
import com.springsource.vfabric.licensing.client.LicenseManagerEnvironment;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.log.Logger;
import com.springsource.vfabric.licensing.state.ComponentInstance;
import com.springsource.vfabric.licensing.state.InstanceState;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.WritableByteChannel;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalStateManager {
    private final String componentId;
    private final File localStateFile;
    private Map<ComponentInstance, InstanceState> currentStates;
    private Map<String, Calendar> evaluationStartDates;
    private Set<String> previouslyExpiredSerials;
    private static final Pattern INSTANCE_KEY_REGEX = Pattern.compile("instance\\.(.*)");
    private static final DateFormat dateFormatter = DateFormat.getDateTimeInstance(2, 1);
    private static final Logger LOG = Logger.getLogger(LocalStateManager.class);
    private static final int DAYS_TO_KEEP_REMOVED_INSTANCES = 14;
    private static final String COMMENT = "\\s*#.*";
    private static final String BLANK = "\\s*";
    private static final Object STATE_LOCK = new Object();
    private static ComponentInstance localIpComponentInstance = null;

    public LocalStateManager(String componentId, File localStateFile) throws LocalLicenseConfigurationException {
        this.componentId = componentId;
        if (localStateFile == null) {
            throw new IllegalArgumentException("State file must be provided to LocalStateManager");
        }
        LicenseManagerEnvironment.createFileIfNotExist(localStateFile);
        this.localStateFile = localStateFile;
    }

    public void updateInstanceState(final InstanceState newState) throws LocalLicenseConfigurationException {
        this.writeWithFreshState(new StateWriter(){

            @Override
            public void writeToState() {
                LocalStateManager.this.currentStates.put(newState.getInstance(), newState);
            }
        });
    }

    public void updateInstanceStates(final Collection<InstanceState> newStates) throws LocalLicenseConfigurationException {
        this.writeWithFreshState(new StateWriter(){

            @Override
            public void writeToState() {
                for (InstanceState state : newStates) {
                    LocalStateManager.this.currentStates.put(state.getInstance(), state);
                }
            }
        });
    }

    public void startEvaluationIfNotStarted(final String serialNumber, boolean isDefault) throws LocalLicenseConfigurationException {
        if (!isDefault) {
            LOG.info("Starting evaluation period for serial number '" + serialNumber);
        }
        this.writeWithFreshState(new StateWriter(){

            @Override
            public void writeToState() {
                if (LocalStateManager.this.evaluationStartDates.get(serialNumber) == null) {
                    LocalStateManager.this.evaluationStartDates.put(serialNumber, new GregorianCalendar());
                }
            }
        });
    }

    public void clearEvaluation(final String serialNumber) throws LocalLicenseConfigurationException {
        this.writeWithFreshState(new StateWriter(){

            @Override
            public void writeToState() {
                LocalStateManager.this.evaluationStartDates.remove(serialNumber);
            }
        });
    }

    public Calendar getEvaluationPeriodStart(final String serialNumber) throws LocalLicenseConfigurationException {
        return this.readWithFreshState(new StateReader<Calendar>(){

            @Override
            public Calendar readFromState() {
                return (Calendar)LocalStateManager.this.evaluationStartDates.get(serialNumber);
            }
        });
    }

    public Collection<InstanceState> getCurrentStates() throws LocalLicenseConfigurationException {
        return this.readWithFreshState(new StateReader<Collection<InstanceState>>(){

            @Override
            public Collection<InstanceState> readFromState() {
                return new ArrayList<InstanceState>(LocalStateManager.this.currentStates.values());
            }
        });
    }

    public int getRunningCount() throws LocalLicenseConfigurationException {
        int count = this.readWithFreshState(new StateReader<Integer>(){

            @Override
            public Integer readFromState() {
                int retval = 0;
                for (InstanceState state : LocalStateManager.this.currentStates.values()) {
                    if (!state.isRunning()) continue;
                    ++retval;
                }
                return retval;
            }
        });
        return count;
    }

    public boolean containsRunningSelfInstance() throws LocalLicenseConfigurationException {
        return this.readWithFreshState(new StateReader<Boolean>(){

            @Override
            public Boolean readFromState() {
                InstanceState selfState = (InstanceState)LocalStateManager.this.currentStates.get(ComponentInstance.COMPONENT_INSTANCE_SELF);
                if (selfState == null && localIpComponentInstance != null) {
                    selfState = (InstanceState)LocalStateManager.this.currentStates.get(localIpComponentInstance);
                }
                return selfState != null && selfState.isRunning();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWithFreshState(StateWriter writer) throws LocalLicenseConfigurationException {
        RandomAccessFile raf = null;
        Object object = STATE_LOCK;
        synchronized (object) {
            try {
                try {
                    LicenseManagerEnvironment.createFileIfNotExist(this.localStateFile);
                    raf = new RandomAccessFile(this.localStateFile, "rw");
                    FileChannel fc = raf.getChannel();
                    fc.lock();
                    this.refreshStateFromLockedChannel(fc);
                    writer.writeToState();
                    fc.truncate(0L);
                    fc.position(0L);
                    Writer stateWriter = Channels.newWriter((WritableByteChannel)fc, "UTF-8");
                    this.saveStateToWriter(stateWriter);
                    stateWriter.flush();
                    fc.force(true);
                }
                finally {
                    if (raf != null) {
                        raf.close();
                    }
                }
            }
            catch (OverlappingFileLockException e) {
                throw new LocalLicenseConfigurationException("Write: failed to lock license state: " + e);
            }
            catch (IOException e) {
                throw new LocalLicenseConfigurationException("Write: Failed to save/load state:" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readWithFreshState(StateReader<T> reader) throws LocalLicenseConfigurationException {
        RandomAccessFile raf = null;
        Object object = STATE_LOCK;
        synchronized (object) {
            try {
                raf = new RandomAccessFile(this.localStateFile, "rw");
                FileChannel fc = raf.getChannel();
                fc.lock();
                this.refreshStateFromLockedChannel(fc);
                T t = reader.readFromState();
                return t;
                finally {
                    if (raf != null) {
                        raf.close();
                    }
                }
            }
            catch (OverlappingFileLockException e) {
                throw new LocalLicenseConfigurationException("Read: failed to lock license state: " + e);
            }
            catch (IOException e) {
                throw new LocalLicenseConfigurationException("Read: Failed to save/load state:" + e);
            }
        }
    }

    private void refreshStateFromLockedChannel(FileChannel fc) throws IOException {
        Scanner scanner = new Scanner(Channels.newInputStream(fc), "UTF-8");
        HashMap<String, String> propsFromDisk = new HashMap<String, String>();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.matches(COMMENT) || line.matches(BLANK)) continue;
            String[] tokens = line.split("=");
            if (tokens.length == 2) {
                propsFromDisk.put(tokens[0], tokens[1]);
                continue;
            }
            LOG.error("Failed to parse line from saved state: " + line);
        }
        this.currentStates = LocalStateManager.readInstances(propsFromDisk);
        this.evaluationStartDates = LocalStateManager.readEvaluationStarts(propsFromDisk);
        this.previouslyExpiredSerials = this.readExpirationEvents(propsFromDisk);
    }

    private static Map<ComponentInstance, InstanceState> readInstances(Map<String, String> propsFromDisk) {
        HashMap<ComponentInstance, InstanceState> instances = new HashMap<ComponentInstance, InstanceState>();
        GregorianCalendar oldStateUpdateTime = new GregorianCalendar();
        ((Calendar)oldStateUpdateTime).add(5, -14);
        for (Map.Entry<String, String> entry : propsFromDisk.entrySet()) {
            String key2 = entry.getKey();
            Matcher matcher = INSTANCE_KEY_REGEX.matcher(key2);
            if (!matcher.matches()) continue;
            String val = entry.getValue();
            String[] fields = val.split(",");
            if (fields.length == 3) {
                String id = matcher.group(1);
                String type = LocalStateManager.readInstanceIdType(fields[0]);
                String state = LocalStateManager.readState(fields[1]);
                Calendar timestamp = LocalStateManager.readSavedDate(fields[2]);
                if (state.equals("off") && timestamp.before(oldStateUpdateTime)) {
                    LOG.info("Forgetting old shutdown of instance '" + id);
                    continue;
                }
                ComponentInstance instance = new ComponentInstance(id, type);
                instances.put(instance, new InstanceState(instance, state, timestamp.getTime()));
                continue;
            }
            LOG.error("Found unreadable saved instance: key = " + key2 + ", value = " + val);
        }
        return instances;
    }

    private static String readState(String in) {
        if (in.equals("on") || in.equals("off")) {
            return in;
        }
        LOG.error("Unexpected value for instance state '" + in + "', assuming running.");
        return "on";
    }

    private static Calendar readSavedDate(String in) {
        GregorianCalendar retval = new GregorianCalendar();
        try {
            long timeStamp = Long.parseLong(in);
            retval.setTimeInMillis(timeStamp);
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse saved timestamp value '" + in + ", using current time.");
        }
        return retval;
    }

    private static String readInstanceIdType(String in) {
        if (in.equals("self") || in.equals("uuid") || in.equals("ipmac") || in.equals("moid")) {
            return in;
        }
        LOG.error("Unexpected saved identifier type: " + in + ", using 'ipmac'");
        return "ipmac";
    }

    private static Map<String, Calendar> readEvaluationStarts(Map<String, String> propsFromDisk) {
        HashMap<String, Calendar> evals = new HashMap<String, Calendar>();
        for (Map.Entry<String, String> entry : propsFromDisk.entrySet()) {
            String[] keyElems = entry.getKey().split("\\.");
            if (keyElems.length != 2 || !keyElems[0].equals("evalStart")) continue;
            long millis = Long.parseLong(entry.getValue());
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(millis);
            evals.put(keyElems[1], calendar);
        }
        return evals;
    }

    private Set<String> readExpirationEvents(Map<String, String> propsFromDisk) {
        HashSet<String> serials = new HashSet<String>();
        for (Map.Entry<String, String> entry : propsFromDisk.entrySet()) {
            String[] elems = entry.getKey().split("\\.");
            if (elems.length <= 1 || !elems[1].equals("expiredEventPosted")) continue;
            serials.add(elems[0]);
        }
        return serials;
    }

    private void saveStateToWriter(Writer writer) throws IOException {
        writer.write("# ");
        writer.write(this.componentId);
        writer.write(" written ");
        writer.write(dateFormatter.format(new Date()));
        writer.write(10);
        for (Map.Entry<String, Calendar> entry : this.evaluationStartDates.entrySet()) {
            writer.write("evalStart.");
            writer.write(entry.getKey());
            writer.write(61);
            writer.write(String.valueOf(entry.getValue().getTimeInMillis()));
            writer.write(10);
        }
        for (InstanceState state : this.currentStates.values()) {
            writer.write("instance.");
            writer.write(state.getIdentifier());
            writer.write(61);
            writer.write(state.getIdentifierType());
            writer.write(44);
            writer.write(state.getComponentState());
            writer.write(44);
            writer.write(String.valueOf(state.getTimestamp().getTime()));
            writer.write(10);
        }
        for (String serial : this.previouslyExpiredSerials) {
            writer.write(serial);
            writer.write(".expiredEventPosted=true\n");
        }
    }

    public File getLocalStateFile() {
        return this.localStateFile;
    }

    public boolean getExpirationEventPosted(String serial) {
        final String fSerial = serial;
        try {
            return this.readWithFreshState(new StateReader<Boolean>(){

                @Override
                public Boolean readFromState() {
                    return LocalStateManager.this.previouslyExpiredSerials.contains(fSerial);
                }
            });
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Failed getExpirationEventPosted");
            return false;
        }
    }

    public void setExpirationEventPosted(String serial) {
        final String fSerial = serial;
        try {
            this.writeWithFreshState(new StateWriter(){

                @Override
                public void writeToState() {
                    LocalStateManager.this.previouslyExpiredSerials.add(fSerial);
                }
            });
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Failed setExpirationEventPosted");
        }
    }

    static {
        String localIp = HttpLicenseProvider.acquireLocalIpAddress();
        if (localIp != null) {
            localIpComponentInstance = new ComponentInstance(localIp, "ipmac");
        }
    }

    private static interface StateWriter {
        public void writeToState();
    }

    private static interface StateReader<T> {
        public T readFromState();
    }
}

