/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.Config;
import com.springsource.vfabric.licensing.client.HttpLicenseProvider;
import com.springsource.vfabric.licensing.client.LicenseManager;
import com.springsource.vfabric.licensing.client.LicenseProvider;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalStateManager;
import com.springsource.vfabric.licensing.client.LocalVliCheckLicenseProvider;
import com.springsource.vfabric.licensing.events.ComponentStateChangeEvent;
import com.springsource.vfabric.licensing.events.Event;
import com.springsource.vfabric.licensing.events.EventManager;
import com.springsource.vfabric.licensing.events.UpdatedLicenseStateEvent;
import com.springsource.vfabric.licensing.log.Logger;
import com.springsource.vfabric.licensing.state.InstanceState;
import com.springsource.vfabric.licensing.state.LicenseState;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class MasterLicenseManager
implements LicenseManager {
    private final LicenseProvider activeProvider;
    private final LocalVliCheckLicenseProvider defaultProvider;
    private final LocalStateManager stateManager;
    private final EventManager eventManager;
    private final Timer heartbeatTimer;
    private final boolean isSelf;
    private LicenseState lastKnownState;
    private static final Logger LOG = Logger.getLogger(MasterLicenseManager.class);
    private final TimerTask heartbeatTask = new TimerTask(){

        @Override
        public void run() {
            LOG.info("heartbeat");
            MasterLicenseManager.this.setManagedComponentStates(null);
            MasterLicenseManager.this.getComponentLicenseState();
        }
    };

    public MasterLicenseManager(LicenseProvider activeProvider, LocalVliCheckLicenseProvider defaultProvider, LocalStateManager stateManager, EventManager eventManager, boolean isSelf) throws LocalLicenseConfigurationException {
        long interval = Config.getHeartbeatInterval();
        this.heartbeatTimer = new Timer("vfabric-license-heartbeat", true);
        this.heartbeatTimer.schedule(this.heartbeatTask, interval * 1000L, interval * 1000L);
        this.activeProvider = activeProvider;
        this.defaultProvider = defaultProvider;
        this.stateManager = stateManager;
        this.eventManager = eventManager;
        this.isSelf = isSelf;
        LOG.info("getting initial component license state");
        this.getComponentLicenseState();
    }

    @Override
    public LicenseState getComponentLicenseState() {
        LicenseState state = null;
        if (this.activeProvider != null) {
            state = this.activeProvider.getComponentLicenseState();
        }
        if (state == null || state.getTotalAvailable() == 0) {
            LOG.info("Failed to retrieve usable licenses for component. Falling back to built-in default evaluation serial numbers.");
            state = this.defaultProvider.getComponentLicenseState();
        } else {
            try {
                LOG.info("Sucessfully retrieved valid license for component. Resetting evaluation period on default (fallback) licenses. They will not be used.");
                this.defaultProvider.resetAllEvaluations();
            }
            catch (LocalLicenseConfigurationException e) {
                LOG.warn("Could not reset evaluation period on default license manager:", e);
            }
        }
        if (!state.equals(this.lastKnownState)) {
            this.eventManager.saveEvent(new UpdatedLicenseStateEvent(state));
            this.lastKnownState = state;
        }
        return state;
    }

    @Override
    public void setComponentState(String componentState) {
        InstanceState instance = null;
        instance = this.isSelf ? new InstanceState(componentState, new Date()) : new InstanceState(HttpLicenseProvider.acquireLocalIpAddress(), "ipmac", componentState, new Date());
        try {
            this.stateManager.updateInstanceState(instance);
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Failed to set component state to '" + componentState + "': ", e);
        }
        if (this.activeProvider != null) {
            this.activeProvider.notifyStateChanged();
        }
        this.defaultProvider.notifyStateChanged();
        this.eventManager.saveEvent(new ComponentStateChangeEvent(instance));
    }

    @Override
    public void setManagedComponentStates(Collection<InstanceState> states2) {
        if (states2 != null) {
            try {
                this.stateManager.updateInstanceStates(states2);
                LinkedList<Event> events = new LinkedList<Event>();
                for (InstanceState state : states2) {
                    events.add(new ComponentStateChangeEvent(state));
                }
                this.eventManager.saveEvents(events);
            }
            catch (LocalLicenseConfigurationException e) {
                LOG.error("Failed to set component state: ", e);
            }
        }
        if (this.activeProvider != null) {
            this.activeProvider.notifyStateChanged();
        }
        this.defaultProvider.notifyStateChanged();
    }

    public void shutdown() {
        this.heartbeatTimer.cancel();
    }
}

