/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.state.LicenseState;
import com.springsource.vfabric.licensing.state.ServerLicenseState;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ServerLicenseCombiner {
    public static LicenseState combine(ServerLicenseState in) {
        return new LicenseState(in.getComponentId(), in.getTimestamp(), "server", ServerLicenseCombiner.getTotalAvailable(in), ServerLicenseCombiner.getTotalUsed(in), ServerLicenseCombiner.getExpiration(in), ServerLicenseCombiner.getEnforcement(in), ServerLicenseCombiner.getAddonFeatures(in), ServerLicenseCombiner.getExtended(in));
    }

    private static int getTotalAvailable(ServerLicenseState in) {
        int available = 0;
        for (ServerLicenseState.License license : in.getLicenses()) {
            available += license.getTotalAvailable();
        }
        return available;
    }

    private static int getTotalUsed(ServerLicenseState in) {
        int used = 0;
        for (ServerLicenseState.License license : in.getLicenses()) {
            used += license.getTotalUsed();
        }
        return used;
    }

    private static Date getExpiration(ServerLicenseState in) {
        Calendar overall = null;
        for (ServerLicenseState.License license : in.getLicenses()) {
            Date current = license.getExpirationDate();
            if (current == null) {
                overall = null;
                break;
            }
            if (overall == null) {
                overall = new GregorianCalendar();
                overall.setTime(current);
                continue;
            }
            GregorianCalendar currentCalendar = new GregorianCalendar();
            currentCalendar.setTime(current);
            if (!currentCalendar.after(overall)) continue;
            overall = currentCalendar;
        }
        return overall == null ? null : overall.getTime();
    }

    public static String getEnforcement(ServerLicenseState in) {
        for (ServerLicenseState.License license : in.getLicenses()) {
            if (!license.getEnforcement().equals("soft")) continue;
            return "soft";
        }
        return "hard";
    }

    public static Set<String> getAddonFeatures(ServerLicenseState in) {
        HashSet<String> addons = new HashSet<String>();
        for (ServerLicenseState.License license : in.getLicenses()) {
            if (license.getAddonFeatures() == null) continue;
            addons.addAll(license.getAddonFeatures());
        }
        return addons;
    }

    private static Properties getExtended(ServerLicenseState in) {
        Properties extended = new Properties();
        for (ServerLicenseState.License license : in.getLicenses()) {
            if (license.getExtendedParameters() == null) continue;
            extended.putAll((Map<?, ?>)license.getExtendedParameters());
        }
        return extended;
    }
}

