/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.GuestInfoAccessor;
import com.springsource.vfabric.licensing.client.GuestInfoException;
import com.springsource.vfabric.licensing.client.RpcToolCommandBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;

public class VmToolsGuestInfoAccessor
implements GuestInfoAccessor {
    static final int CMD_WAIT_SECONDS = 10;
    RpcToolCommandBuilder commandBuilder;

    public VmToolsGuestInfoAccessor() throws GuestInfoException {
        this.commandBuilder = new RpcToolCommandBuilder();
    }

    public VmToolsGuestInfoAccessor(RpcToolCommandBuilder commandBuilder) {
        this.commandBuilder = commandBuilder;
    }

    @Override
    public String readVariable(String key2) throws GuestInfoException {
        assert (key2 != null && key2.length() > 0);
        return this.sendCommand("info-get guestinfo." + key2);
    }

    @Override
    public void writeVariable(String key2, String value2) throws GuestInfoException {
        assert (key2 != null && key2.length() > 0);
        assert (value2 != null && value2.length() > 0);
        this.sendCommand("info-set guestinfo." + key2 + " " + value2);
    }

    String sendCommand(String rpcCommand) throws GuestInfoException {
        assert (rpcCommand != null && rpcCommand.length() > 0);
        try {
            int waitTime;
            String[] args = this.commandBuilder.buildCommand(rpcCommand);
            Process process = Runtime.getRuntime().exec(args);
            int exitValue = 0;
            StringWriter stderr = new StringWriter();
            StringWriter stdout = new StringWriter();
            for (waitTime = 0; waitTime < 10; ++waitTime) {
                try {
                    VmToolsGuestInfoAccessor.readStream(process.getInputStream(), stdout);
                    VmToolsGuestInfoAccessor.readStream(process.getErrorStream(), stderr);
                    exitValue = process.exitValue();
                    break;
                }
                catch (IllegalThreadStateException e) {
                    Thread.sleep(1000L);
                    continue;
                }
            }
            if (waitTime == 10) {
                throw new GuestInfoException("Timed out waiting for command '" + rpcCommand + "' to complete.");
            }
            if (exitValue != 0) {
                VmToolsGuestInfoAccessor.readStream(process.getErrorStream(), stderr);
                throw new GuestInfoException("Command '" + rpcCommand + "' returned non-zero value: " + exitValue + ", " + stderr.toString());
            }
            VmToolsGuestInfoAccessor.readStream(process.getInputStream(), stdout);
            return stdout.toString();
        }
        catch (IOException e) {
            throw new GuestInfoException("Caught IOException running vmware-rpctool: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new GuestInfoException("InterruptedException running vmware-rpctool: " + e.getMessage());
        }
    }

    private static void readStream(InputStream ins, Writer outs) throws IOException {
        int numRead;
        assert (ins != null);
        assert (outs != null);
        InputStreamReader in = new InputStreamReader(ins, "UTF-8");
        char[] buf = new char[1024];
        do {
            if ((numRead = in.read(buf)) <= 0) continue;
            outs.write(buf, 0, numRead);
        } while (numRead > 0);
    }
}

