/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.events;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public abstract class Event {
    protected final DateFormat FORMAT_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final Date time;
    private final EventSeverity severity;

    public Event(EventSeverity severity) {
        this.severity = severity;
        this.time = new Date();
    }

    protected abstract Properties getArguments();

    public void appendToWriter(Writer writer) throws IOException {
        writer.append(this.FORMAT_8601.format(this.time)).append(',');
        writer.append(this.severity.name()).append(',');
        writer.append(this.getClass().getSimpleName()).append(',');
        Properties args = this.getArguments();
        if (args != null) {
            Enumeration<Object> it = args.keys();
            while (it.hasMoreElements()) {
                String argName = (String)it.nextElement();
                writer.append(argName.toString()).append('=').append(args.getProperty(argName));
                if (!it.hasMoreElements()) continue;
                writer.append('|');
            }
        }
    }

    protected static Properties makeProperties(String ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("makeProperties needs an even number of params!");
        }
        Properties props = new Properties();
        for (int i = 0; i < params.length; ++i) {
            String key2 = params[i++];
            String value2 = params[i];
            props.put(key2, value2);
        }
        return props;
    }

    public static enum EventSeverity {
        ERROR,
        WARNING,
        INFO;

    }
}

