/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.events;

import com.springsource.vfabric.licensing.client.LicenseManagerEnvironment;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.events.Event;
import com.springsource.vfabric.licensing.events.EventManagerStartedEvent;
import com.springsource.vfabric.licensing.log.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collection;

public class EventManager {
    private final File eventsFile;
    private static Logger LOG = Logger.getLogger(EventManager.class);
    private static final Object EVENT_LOCK = new Object();

    public EventManager(File eventsFile) throws LocalLicenseConfigurationException {
        if (eventsFile == null) {
            throw new IllegalArgumentException("Events file must be provided to the EventManager");
        }
        LicenseManagerEnvironment.createFileIfNotExist(eventsFile);
        this.eventsFile = eventsFile;
        this.saveEvent(new EventManagerStartedEvent());
    }

    public void saveEvent(Event event) {
        this.saveEvents(Arrays.asList(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEvents(Collection<Event> events) {
        Object object = EVENT_LOCK;
        synchronized (object) {
            try {
                FileOutputStream ostream = null;
                Writer writer = null;
                FileLock lock = null;
                try {
                    ostream = new FileOutputStream(this.eventsFile, true);
                    FileChannel fc = ostream.getChannel();
                    lock = fc.lock();
                    writer = Channels.newWriter((WritableByteChannel)fc, "UTF-8");
                    for (Event event : events) {
                        event.appendToWriter(writer);
                        writer.append('\n');
                    }
                    writer.flush();
                }
                finally {
                    if (lock != null) {
                        lock.release();
                    }
                    if (ostream != null) {
                        ostream.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Failed to write event to " + this.eventsFile.getAbsolutePath(), e);
            }
        }
    }

    public File getEventsFile() {
        return this.eventsFile;
    }
}

