/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.events;

import com.springsource.vfabric.licensing.client.ActivatedLicense;
import com.springsource.vfabric.licensing.events.Event;
import java.util.Calendar;
import java.util.Properties;

public class LicenseExpiredEvent
extends Event {
    private final ActivatedLicense license;

    public LicenseExpiredEvent(ActivatedLicense license) {
        super(Event.EventSeverity.WARNING);
        this.license = license;
    }

    @Override
    protected Properties getArguments() {
        String expirationDate = "";
        if (this.license.isPerpetual()) {
            expirationDate = "never";
        } else if (this.license.isExpiringOnASetDate()) {
            expirationDate = this.FORMAT_8601.format(this.license.getExpirationDate().getTime());
        } else if (this.license.isFloatingEval()) {
            Calendar expirationCalendar = this.license.getExpirationDate();
            expirationDate = expirationCalendar == null ? "unset" : this.FORMAT_8601.format(this.license.getExpirationDate().getTime());
        }
        return LicenseExpiredEvent.makeProperties("serialNumber", this.license.getSerialNumber(), "expirationType", this.license.getPrettyExpirationType(), "expirationDate", expirationDate);
    }
}

