/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.events;

import com.springsource.vfabric.licensing.events.Event;
import com.springsource.vfabric.licensing.state.LicenseState;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class UpdatedLicenseStateEvent
extends Event {
    private final LicenseState newState;

    public UpdatedLicenseStateEvent(LicenseState newState) {
        super(Event.EventSeverity.INFO);
        this.newState = newState;
    }

    @Override
    protected Properties getArguments() {
        Date expirationDate = this.newState.getExpirationDate();
        String expirationString = expirationDate == null ? "permanent" : this.FORMAT_8601.format(expirationDate.getTime());
        Set<String> addons = this.newState.getAddonFeatures();
        StringWriter addonStr = new StringWriter();
        if (addons != null && addons.size() != 0) {
            Iterator<String> addonsIt = addons.iterator();
            while (addonsIt.hasNext()) {
                addonStr.append(addonsIt.next());
                if (!addonsIt.hasNext()) continue;
                addonStr.append('+');
            }
        } else {
            addonStr.append("<empty>");
        }
        return UpdatedLicenseStateEvent.makeProperties("available", Integer.toString(this.newState.getTotalAvailable()), "used", Integer.toString(this.newState.getTotalUsed()), "licenseType", this.newState.getLicenseType(), "expirationDate", expirationString, "enforcement", this.newState.getEnforcement(), "addons", addonStr.toString());
    }
}

