/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.state;

import com.springsource.vfabric.licensing.state.ComponentInstance;
import java.util.Date;

public class InstanceState {
    private final ComponentInstance componentInstance;
    private final String componentState;
    private final Date timestamp;
    public static final String COMPONENT_STATE_RUNNING = "on";
    public static final String COMPONENT_STATE_NOT_RUNNING = "off";

    public InstanceState(String componentState, Date timestamp) {
        this(ComponentInstance.COMPONENT_INSTANCE_SELF, componentState, timestamp);
    }

    public InstanceState(ComponentInstance componentInstance, String componentState, Date timestamp) {
        this.componentInstance = componentInstance;
        this.componentState = InstanceState.checkInstanceState(componentState);
        this.timestamp = timestamp == null ? new Date() : timestamp;
    }

    public InstanceState(String identifier, String identifierType, String componentState, Date timestamp) {
        this(new ComponentInstance(identifier, identifierType), componentState, timestamp);
    }

    private static String checkInstanceState(String in) {
        if (!in.equals(COMPONENT_STATE_RUNNING) && !in.equals(COMPONENT_STATE_NOT_RUNNING)) {
            throw new IllegalArgumentException("Unexpected component state '" + in + "'");
        }
        return in;
    }

    public ComponentInstance getInstance() {
        return this.componentInstance;
    }

    public String getComponentState() {
        return this.componentState;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getIdentifier() {
        return this.componentInstance.getIdentifier();
    }

    public String getIdentifierType() {
        return this.componentInstance.getIdentifierType();
    }

    public boolean isRunning() {
        return this.componentState.equals(COMPONENT_STATE_RUNNING);
    }
}

