/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.state;

import com.springsource.vfabric.licensing.state.LicenseStateException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class StateUtils {
    static String getOrThrow(String key2, Properties props) throws LicenseStateException {
        String val = props.getProperty(key2);
        if (val == null) {
            throw new LicenseStateException("Could not read properties, no '" + key2 + "'");
        }
        return val;
    }

    static Date getDateOrThrow(String key2, Properties props) throws LicenseStateException {
        long time;
        String timeString = StateUtils.getOrThrow(key2, props);
        try {
            time = Long.parseLong(timeString);
        }
        catch (NumberFormatException e) {
            throw new LicenseStateException("Could not read time from timestamp '" + timeString + "': " + e.getMessage());
        }
        Date now = new Date();
        time = StateUtils.correctForVFP485(time, now.getTime());
        return new Date(time);
    }

    static Date getDateOrNull(String key2, Properties props) {
        try {
            return StateUtils.getDateOrThrow(key2, props);
        }
        catch (LicenseStateException e) {
            return null;
        }
    }

    static int getIntOrThrow(String key2, Properties props) throws LicenseStateException {
        String numString = StateUtils.getOrThrow(key2, props);
        try {
            return Integer.parseInt(numString);
        }
        catch (NumberFormatException e) {
            throw new LicenseStateException("Could not read number from '" + numString + "': " + e.getMessage());
        }
    }

    static void addChecksum(Properties props) {
        props.put("checksum", Integer.toString(StateUtils.calcChecksum(props)));
    }

    static boolean validateChecksum(Properties props) {
        int expected;
        String expectedStr = (String)props.get("checksum");
        if (expectedStr == null) {
            return false;
        }
        try {
            expected = Integer.parseInt(expectedStr);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return expected == StateUtils.calcChecksum(props);
    }

    private static int calcChecksum(Properties props) {
        int checksum = 0;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (entry.getKey().equals("checksum")) continue;
            checksum ^= entry.getKey().hashCode();
            checksum ^= entry.getValue().hashCode();
        }
        return checksum ^= "jfkshsjkr7893tyjdskl02&EF#@fd9(HKU%^kjkjldjfh;d(Y&*()*jkf".hashCode();
    }

    public static long correctForVFP485(long clientTime, long serverTime) {
        if (clientTime > 0x100000000L) {
            return clientTime;
        }
        clientTime &= 0xFFFFFFFFL;
        long epochStart = serverTime & 0xFFFFFFFF00000000L;
        long[] possibleEpochs = new long[]{epochStart, epochStart - 0x100000000L, epochStart + 0x100000000L};
        long closestToServer = 0L;
        long shortestDistance = Long.MAX_VALUE;
        for (long epoch : possibleEpochs) {
            long clientTimeInEpoch = epoch + clientTime;
            long distance = Math.abs(clientTimeInEpoch - serverTime);
            if (distance >= shortestDistance) continue;
            closestToServer = clientTimeInEpoch;
            shortestDistance = distance;
        }
        return closestToServer;
    }
}

