/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.util;

import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SerialNumberUtil {
    public static void getSerialNumbersFromStream(InputStream istream, List<String> serials) throws Exception {
        if (istream == null) {
            throw new IllegalArgumentException("istream cannot be null");
        }
        Scanner scanner = new Scanner(istream, "US-ASCII");
        Pattern serialNumberPattern = Pattern.compile("\\s*(\\w{5}-\\w{5}-\\w{5}-\\w{5}-\\w{5}).*");
        Pattern commentPattern = Pattern.compile("\\s*--.*");
        Pattern blankPattern = Pattern.compile("\\s*");
        int lineNum = 0;
        while (scanner.hasNextLine()) {
            ++lineNum;
            String line = scanner.nextLine();
            Matcher serialNumberMatcher = serialNumberPattern.matcher(line);
            if (serialNumberMatcher.matches()) {
                serials.add(serialNumberMatcher.group(1));
                continue;
            }
            if (commentPattern.matcher(line).matches() || blankPattern.matcher(line).matches()) continue;
            throw new Exception("Failed to read serial numbers, error on line " + lineNum + ": '" + line + "'");
        }
    }
}

