/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.BitVector;

public class BitVectorHelper {
    public static BitVector bitVectorSet(BitVector bv, int pos) {
        Logger log = Logger.getLogger(BitVectorHelper.class);
        int index2 = pos >> 5;
        int mask = 1 << (pos & 0x1F);
        try {
            int vector = bv.getVector()[index2];
            int result = vector | mask;
            bv.setVector(result, index2);
            return bv;
        }
        catch (Exception e) {
            log.warn("Invalid Bit Vector: impossible to get the vector for index " + index2, e);
            log.debug("Invalid Bit Vector: impossible to get the vector for index " + index2, e);
            return null;
        }
    }

    public static BitVector bitVectorClear(BitVector bv, int pos) {
        Logger log = Logger.getLogger(BitVectorHelper.class);
        int index2 = pos >> 5;
        int inverseMask = ~(1 << (pos & 0x1F));
        try {
            int vector = bv.getVector()[index2];
            int result = vector & inverseMask;
            bv.setVector(result, index2);
            return bv;
        }
        catch (Exception e) {
            log.warn("Invalid Bit Vector: impossible to get the vector for index " + index2, e);
            log.debug("Invalid Bit Vector: impossible to get the vector for index " + index2, e);
            return null;
        }
    }

    public static boolean bitVectorTest(BitVector bv, int pos) {
        int index2 = pos >> 5;
        int mask = 1 << (pos & 0x1F);
        try {
            int vector = bv.getVector()[index2];
            int result = vector & mask;
            return result != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getValueFromBitVector(BitVector bv, int pos, int size2) {
        int value2 = 0;
        for (int i = size2 - 1; i >= 0; --i) {
            value2 <<= 1;
            if (!BitVectorHelper.bitVectorTest(bv, pos + i)) continue;
            ++value2;
        }
        return value2;
    }

    public static long getHashFromBitVector(BitVector bv, int pos, int size2) {
        long value2 = 0L;
        for (int i = size2 - 1; i >= 0; --i) {
            value2 <<= 1;
            if (!BitVectorHelper.bitVectorTest(bv, pos + i)) continue;
            ++value2;
        }
        return value2;
    }
}

