/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.vmware.licensecheck.DLFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;

public abstract class DLFAbstractReader {
    public String formatDLFPropertyValue(String propertyValue) throws DLFException {
        if (propertyValue.equals("")) {
            throw new DLFException(2L, "Corrupted dormant license file: it is not a propertes file");
        }
        if (propertyValue.charAt(0) == '\"' && propertyValue.charAt(propertyValue.length() - 1) == '\"') {
            String trunkPropValue = propertyValue.substring(1, propertyValue.length() - 1);
            return trunkPropValue;
        }
        return propertyValue;
    }

    public Properties loadDormantLicenseFile(InputStream dlfStream) throws IOException, DLFException {
        Properties props = new Properties();
        props.load(dlfStream);
        Properties outProps = new Properties();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value2 = props.getProperty(string);
            String string2 = this.formatDLFPropertyValue(string);
            if (string2.equals("REGEDIT4") || string2.startsWith("[HKEY_")) continue;
            value2 = this.formatDLFPropertyValue(value2);
            outProps.put(string2, value2);
        }
        return outProps;
    }
}

