/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFAbstractFactory;
import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.DLFReader;
import com.vmware.licensecheck.DLFZipInputStreamReader;
import com.vmware.licensecheck.DormantLicense;
import com.vmware.licensecheck.IDLFFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipInputStream;

public class DLFPathFactory
extends DLFAbstractFactory
implements IDLFFactory {
    public static final String PATH_DIRLOCATION_PREFIX = "dir://";
    public static final String PATH_DIRSLOCATION_PREFIX = "dirs://";
    public static final String PATH_FILELOCATION_PREFIX = "file://";
    public static final String PATH_ZIPLOCATION_PREFIX = "zip://";
    private Logger log = Logger.getLogger(this.getClass());
    private DLFReader dlfReader;
    private DLFZipInputStreamReader dlfReaderZip;
    private String fullPath;
    private PrefixType prefixType;
    private String path;

    public DLFPathFactory(String dlfPath, String productVersion, String productName) throws DLFException {
        if (dlfPath == null || !dlfPath.contains("//")) {
            throw new DLFException(1L, "Invalid dormantPath: " + dlfPath);
        }
        if (dlfPath.startsWith(PATH_DIRLOCATION_PREFIX)) {
            this.prefixType = PrefixType.typeDir;
            this.path = dlfPath.substring(PATH_DIRLOCATION_PREFIX.length());
        } else if (dlfPath.startsWith(PATH_DIRSLOCATION_PREFIX)) {
            this.prefixType = PrefixType.typeDirs;
            this.path = dlfPath.substring(PATH_DIRSLOCATION_PREFIX.length());
        } else if (dlfPath.startsWith(PATH_FILELOCATION_PREFIX)) {
            this.prefixType = PrefixType.typeFile;
            this.path = dlfPath.substring(PATH_FILELOCATION_PREFIX.length());
        } else if (dlfPath.startsWith(PATH_ZIPLOCATION_PREFIX)) {
            this.prefixType = PrefixType.typeZip;
            this.path = dlfPath.substring(PATH_ZIPLOCATION_PREFIX.length());
        } else {
            throw new DLFException(1L, "Unknown prefix: " + dlfPath);
        }
        this.fullPath = dlfPath;
        this.setProductName(productName);
        this.setProductVersion(productVersion);
        if (this.prefixType == PrefixType.typeZip) {
            this.dlfReaderZip = new DLFZipInputStreamReader();
        } else {
            this.dlfReader = new DLFReader();
        }
        this.encoding = "UTF-8";
    }

    private void addLicenseFromFile(Vector<DormantLicense> validDLFs, File file) throws DLFException {
        Properties dlfProps;
        String dlfPath = file.getPath();
        if (!file.exists()) {
            this.log.warn("File does not exist: " + dlfPath);
            this.log.debug("File does not exist: " + dlfPath);
            throw new DLFException(1L, "File does not exist: " + dlfPath);
        }
        if (!file.isFile()) {
            this.log.warn("Not a file: " + dlfPath);
            this.log.debug("Not a file: " + dlfPath);
            throw new DLFException(1L, "Not a file: " + dlfPath);
        }
        try {
            dlfProps = this.dlfReader.loadDormantLicenseFile(dlfPath);
        }
        catch (IOException e) {
            this.log.warn(e.getMessage());
            this.log.debug(e.getMessage(), e);
            throw new DLFException(e);
        }
        this.addLicense(validDLFs, dlfProps);
    }

    private void addLicenseFromDirectory(Vector<DormantLicense> validDLFs, File directory) throws DLFException {
        String dlfPath = directory.getPath();
        if (!directory.exists()) {
            this.log.warn("Directory does not exist: " + dlfPath);
            this.log.debug("Directory does not exist: " + dlfPath);
            throw new DLFException(1L, "Directory does not exist: " + dlfPath);
        }
        if (!directory.isDirectory()) {
            this.log.warn("Not a directory: " + dlfPath);
            this.log.debug("Not a directory: " + dlfPath);
            throw new DLFException(1L, "Not a directory: " + dlfPath);
        }
        Vector<Properties> listDlfProps = this.dlfReader.loadDormantLicenseFiles(dlfPath);
        this.addLicense(validDLFs, listDlfProps);
    }

    private void addLicenseFromDirectoryRecursive(Vector<DormantLicense> validDLFs, File directory) throws DLFException {
        this.addLicenseFromDirectory(validDLFs, directory);
        DirectoryFilter filter = new DirectoryFilter();
        File[] dirs = directory.listFiles(filter);
        for (int i = 0; i < dirs.length; ++i) {
            this.addLicenseFromDirectoryRecursive(validDLFs, dirs[i]);
        }
    }

    private void addLicenseFromZip(Vector<DormantLicense> validDLFs, File zipfile) throws DLFException {
        FileInputStream fInput;
        String dlfPath = zipfile.getPath();
        try {
            fInput = new FileInputStream(zipfile);
        }
        catch (FileNotFoundException e) {
            this.log.warn("zipfile does not exist: " + dlfPath);
            this.log.debug("zipfile does not exist: " + dlfPath);
            throw new DLFException(1L, "zipfile does not exist: " + dlfPath);
        }
        ZipInputStream zipInput = new ZipInputStream(fInput);
        Vector<Properties> listDlfProps = this.dlfReaderZip.loadDormantLicenseFiles(zipInput);
        this.addLicense(validDLFs, listDlfProps);
    }

    @Override
    public Vector<DormantLicense> getDLFList() throws DLFException {
        Vector<DormantLicense> dlfList = new Vector<DormantLicense>();
        File f = new File(this.path);
        switch (this.prefixType) {
            case typeDir: {
                this.addLicenseFromDirectory(dlfList, f);
                break;
            }
            case typeDirs: {
                this.addLicenseFromDirectoryRecursive(dlfList, f);
                break;
            }
            case typeFile: {
                this.addLicenseFromFile(dlfList, f);
                break;
            }
            case typeZip: {
                this.addLicenseFromZip(dlfList, f);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (dlfList.isEmpty()) {
            this.log.warn("No valid DLFs found: " + this.fullPath);
            this.log.debug("No valid DLFs found: " + this.fullPath);
            throw new DLFException(3L, "No valid DLFs found: " + this.fullPath);
        }
        return dlfList;
    }

    private class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private static enum PrefixType {
        typeDir,
        typeDirs,
        typeFile,
        typeZip;

    }
}

