/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFAbstractReader;
import com.vmware.licensecheck.DLFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class DLFReader
extends DLFAbstractReader {
    private Logger log = Logger.getLogger(this.getClass());

    public Vector<Properties> loadDormantLicenseFiles(String dirPath) throws DLFException {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            this.log.warn("Path must be a valid directory" + dirPath);
            this.log.debug("Path must be a valid directory" + dirPath);
            throw new DLFException(1L, "Path must be a valid directory" + dirPath);
        }
        Vector<Properties> dlfs = new Vector<Properties>();
        class DormantLicenseFilter
        implements FilenameFilter {
            DormantLicenseFilter() {
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("license");
            }
        }
        DormantLicenseFilter filter = new DormantLicenseFilter();
        File[] files = dir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            this.log.debug("loading file: " + files[i]);
            try {
                dlfs.add(this.loadDormantLicenseFile(files[i].getAbsolutePath()));
                continue;
            }
            catch (IOException e) {
                this.log.warn(e.getMessage());
                this.log.debug(e.getMessage(), e);
                continue;
            }
            catch (DLFException e) {
                this.log.warn(e.getMessage());
                this.log.debug(e.getMessage(), e);
            }
        }
        return dlfs;
    }

    public Properties loadDormantLicenseFile(String path) throws IOException, DLFException {
        File f = new File(path);
        FileInputStream fis = new FileInputStream(f);
        Properties outProps = this.loadDormantLicenseFile(fis);
        outProps.put("_path", path);
        return outProps;
    }
}

