/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFAbstractFactory;
import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.DLFZipInputStreamReader;
import com.vmware.licensecheck.DormantLicense;
import com.vmware.licensecheck.IDLFFactory;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipInputStream;

public class DLFZipInputStreamFactory
extends DLFAbstractFactory
implements IDLFFactory {
    private Logger log = Logger.getLogger(this.getClass());
    private DLFZipInputStreamReader dlfReader;
    private ZipInputStream dlfStream;

    public DLFZipInputStreamFactory(ZipInputStream dlfStream) {
        this.dlfStream = dlfStream;
        this.dlfReader = new DLFZipInputStreamReader();
        this.encoding = "UTF-8";
    }

    @Override
    public Vector<DormantLicense> getDLFList() throws DLFException {
        Vector<DormantLicense> validDLFs = new Vector<DormantLicense>();
        Vector<Properties> listDlfProps = this.dlfReader.loadDormantLicenseFiles(this.dlfStream);
        if (listDlfProps == null || listDlfProps.size() < 1) {
            this.log.warn("No Valid License available in ZIP");
            this.log.debug("No Valid License available in ZIP");
            throw new DLFException(3L, "No Valid License available in ZIP");
        }
        this.addLicense(validDLFs, listDlfProps);
        return validDLFs;
    }
}

