/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFAbstractReader;
import com.vmware.licensecheck.DLFException;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DLFZipInputStreamReader
extends DLFAbstractReader {
    private Logger log = Logger.getLogger(this.getClass());

    public Vector<Properties> loadDormantLicenseFiles(ZipInputStream zis) throws DLFException {
        ZipEntry ze;
        Vector<Properties> dlfs = new Vector<Properties>();
        try {
            ze = zis.getNextEntry();
            if (ze == null) {
                throw new DLFException(1L, "Path must be a valid ZIP");
            }
        }
        catch (IOException e) {
            throw new DLFException(1L, "Path must be a valid ZIP");
        }
        while (ze != null) {
            String filename = ze.getName();
            if (!ze.isDirectory() && filename.contains("license")) {
                try {
                    this.log.debug("loading from zip: " + filename);
                    Properties tmp = this.loadDormantLicenseFile(zis);
                    tmp.put("_path", filename);
                    dlfs.add(tmp);
                }
                catch (Exception e) {
                    this.log.warn(e.getMessage() + ": " + filename);
                }
            }
            try {
                ze = zis.getNextEntry();
            }
            catch (IOException e) {
                this.log.warn(e.getMessage());
                break;
            }
        }
        try {
            zis.close();
        }
        catch (IOException e) {
            throw new DLFException(1L, "Path must be a valid ZIP");
        }
        return dlfs;
    }
}

