/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class ExpirationDateHelper {
    private static final String EPOCH_DATE_FORMAT = "yyyy-MM-dd";
    private static Logger log = Logger.getLogger(ExpirationDateHelper.class);

    public static Date stringToDate(String strDate, String strFormat) throws Exception {
        SimpleDateFormat date = new SimpleDateFormat(strFormat);
        return date.parse(strDate);
    }

    public static Calendar getEpochDate(String epoch) throws DLFException {
        Date date;
        try {
            date = ExpirationDateHelper.stringToDate(epoch, EPOCH_DATE_FORMAT);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            log.debug(e.getMessage(), e);
            throw new DLFException(e);
        }
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.setTime(date);
        return retVal;
    }

    public static Calendar getIssueDate(String epoch, int issueDate) throws DLFException {
        Calendar cal = ExpirationDateHelper.getEpochDate(epoch);
        cal.add(5, issueDate);
        return cal;
    }

    public static Calendar getExpirationDate(String epoch, int issueDate, int expiration) throws DLFException {
        if (expiration == 0) {
            return null;
        }
        Calendar calendarLicense = ExpirationDateHelper.getIssueDate(epoch, issueDate);
        calendarLicense.add(5, 30 * expiration);
        return calendarLicense;
    }

    public static boolean hasExpired(Calendar expirationDate) {
        if (expirationDate == null) {
            return false;
        }
        GregorianCalendar now = new GregorianCalendar();
        return expirationDate.before(now);
    }
}

