/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtil {
    public static byte[] hash(String strEntry, String encoding, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return HashUtil.hash(strEntry.getBytes(encoding), salt);
    }

    public static byte[] hash(byte[] entry, byte[] salt) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(entry);
        messageDigest.update(salt);
        return messageDigest.digest();
    }

    public static String hashToFormatedString(byte[] hash) {
        String outStr = "";
        for (int i = 0; i < hash.length; ++i) {
            byte b = hash[i];
            String tmpStr = String.format("%02x", b);
            outStr = outStr + tmpStr;
            if ((i + 1) % 4 != 0 || i >= hash.length - 1) continue;
            outStr = outStr + "-";
        }
        return outStr;
    }

    public static String byteArrayToString(byte[] result, String encoding) {
        String outStr = "";
        for (int i = 0; i < result.length; ++i) {
            byte b = result[i];
            String tmpStr = Integer.toString((char)b & 0xFF, 16);
            outStr = outStr + tmpStr;
        }
        return outStr;
    }

    public static int byteToInt(byte bIn) {
        if (bIn > 127 || bIn < -128) {
            return 0;
        }
        if (bIn >= 0) {
            return bIn;
        }
        return -(-bIn) & 0xFF;
    }
}

