/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.ExpirationDateHelper;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;

public class LicenseAttributes {
    private String productName;
    private String licenseVersion;
    private String licenseType;
    private String licenseEdition;
    private String epoch;
    private Calendar epochDate;
    private String hash;
    private String data;
    private String dataHash;
    private String path;
    private HashMap<String, String> extendedAttributes;
    private String serial;
    private int version;
    private int batchId;
    private int unitId;
    private int issue;
    private Calendar issueDate;
    private int expiration;
    private Calendar expirationDate;
    private int subscription;
    private int support;
    private int count;
    private boolean[] addons;

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getLicenseVersion() {
        return this.licenseVersion;
    }

    public void setLicenseVersion(String licenseVersion) {
        this.licenseVersion = licenseVersion;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getEpoch() {
        return this.epoch;
    }

    public Calendar getEpochDate() throws DLFException {
        if (this.epochDate == null) {
            this.epochDate = ExpirationDateHelper.getEpochDate(this.epoch);
        }
        return this.epochDate;
    }

    public void setEpoch(String epoch) {
        this.epoch = epoch;
    }

    public String getLicenseEdition() {
        return this.licenseEdition;
    }

    public void setLicenseEdition(String licenseEdition) {
        this.licenseEdition = licenseEdition;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public void setDataHash(String dataHash) {
        this.dataHash = dataHash;
    }

    public HashMap<String, String> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(HashMap<String, String> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public String getSerial() {
        return this.serial;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setBatchId(int batchId) {
        this.batchId = batchId;
    }

    public int getBatchId() {
        return this.batchId;
    }

    public void setUnitId(int unitId) {
        this.unitId = unitId;
    }

    public int getUnitId() {
        return this.unitId;
    }

    public void setIssue(int issue) {
        this.issue = issue;
    }

    public int getIssue() {
        return this.issue;
    }

    public Calendar getIssueDate() throws DLFException {
        if (this.issueDate == null) {
            this.issueDate = ExpirationDateHelper.getIssueDate(this.epoch, this.issue);
        }
        return this.issueDate;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public Calendar getExpirationDate() throws DLFException {
        if (this.expiration == 0) {
            return null;
        }
        if (this.expirationDate == null) {
            this.expirationDate = ExpirationDateHelper.getExpirationDate(this.epoch, this.issue, this.expiration);
        }
        return this.expirationDate;
    }

    public boolean isExpired() {
        if (this.expiration == 0) {
            return false;
        }
        return ExpirationDateHelper.hasExpired(this.expirationDate);
    }

    public boolean isExpiring() {
        return this.expiration != 0;
    }

    public void setSubscription(int subscription) {
        this.subscription = subscription;
    }

    public int getSubscription() {
        return this.subscription;
    }

    public void setSupport(int support) {
        this.support = support;
    }

    public int getSupport() {
        return this.support;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void setAddons(boolean[] addons) {
        this.addons = addons;
    }

    public boolean[] getAddons() {
        return this.addons;
    }

    public void addSerialAttributes(LicenseAttributes serialAttr) {
        String serial = serialAttr.getSerial();
        int version = serialAttr.getVersion();
        int batchId = serialAttr.getBatchId();
        int unitId = serialAttr.getUnitId();
        int issue = serialAttr.getIssue();
        int expiration = serialAttr.getExpiration();
        int subscription = serialAttr.getSubscription();
        int support = serialAttr.getSupport();
        int count = serialAttr.getCount();
        boolean[] addons = serialAttr.getAddons();
        this.setSerial(serial);
        this.setVersion(version);
        this.setBatchId(batchId);
        this.setUnitId(unitId);
        this.setIssue(issue);
        this.setExpiration(expiration);
        this.setSubscription(subscription);
        this.setSupport(support);
        this.setCount(count);
        this.setAddons(addons);
    }

    public String[] getEnabledFeatures() {
        String enabled;
        if (this.extendedAttributes != null && (enabled = this.extendedAttributes.get("enable")) != null) {
            return enabled.split(",");
        }
        return null;
    }

    public String[] getAddonFeatures() throws DLFException {
        String addonList;
        if (this.extendedAttributes != null && this.addons != null && (addonList = this.extendedAttributes.get("addon")) != null) {
            String[] addonFeatures = addonList.split(",");
            if (addonFeatures.length > 5) {
                throw new DLFException("too many addons defined in DLF: " + this.path);
            }
            Vector<String> varray = new Vector<String>();
            for (int i = 0; i < addonFeatures.length; ++i) {
                if (!this.addons[i]) continue;
                varray.add(addonFeatures[i]);
            }
            if (!varray.isEmpty()) {
                String[] sArray = new String[varray.size()];
                return varray.toArray(sArray);
            }
        }
        return null;
    }
}

