/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4UnknownSizeDecompressor;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.Utils;

final class LZ4JavaSafeUnknownSizeDecompressor
extends LZ4UnknownSizeDecompressor {
    public static final LZ4UnknownSizeDecompressor INSTANCE = new LZ4JavaSafeUnknownSizeDecompressor();

    LZ4JavaSafeUnknownSizeDecompressor() {
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, maxDestLen);
        int srcEnd = srcOff + srcLen;
        int destEnd = destOff + maxDestLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (sOff < srcEnd) {
            int matchCopyEnd;
            int literalCopyEnd;
            int token;
            int literalLen;
            if ((literalLen = (token = src[sOff++] & 0xFF) >>> 4) == 15) {
                byte len;
                while ((len = src[sOff++]) == -1) {
                    literalLen += 255;
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) > destEnd - 8 || sOff + literalLen > srcEnd - 8) {
                if (literalCopyEnd > destEnd || sOff + literalLen > srcEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4Utils.safeArraycopy(src, sOff, dest, dOff, literalLen);
                dOff = literalCopyEnd;
                if ((sOff += literalLen) >= srcEnd) break;
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            LZ4Utils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            sOff += literalLen;
            dOff = literalCopyEnd;
            int matchDec = src[sOff++] & 0xFF | (src[sOff++] & 0xFF) << 8;
            int matchOff = dOff - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len;
                while ((len = src[sOff++]) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4Utils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4Utils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
        return dOff - destOff;
    }
}

