/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.measurements.Measurements;
import com.yahoo.ycsb.workloads.CoreWorkload;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseClient
extends DB {
    private static final Configuration config = HBaseConfiguration.create();
    public boolean _debug = false;
    public String _table = "";
    public HTable _hTable = null;
    public String _columnFamily = "";
    public byte[] _columnFamilyBytes;
    public boolean _clientSideBuffering = false;
    public long _writeBufferSize = 0xC00000L;
    public static final int Ok = 0;
    public static final int ServerError = -1;
    public static final int HttpError = -2;
    public static final int NoMatchingRecord = -3;
    public static final Object tableLock = new Object();

    public void init() throws DBException {
        if (this.getProperties().getProperty("debug") != null && this.getProperties().getProperty("debug").compareTo("true") == 0) {
            this._debug = true;
        }
        if (this.getProperties().containsKey("clientbuffering")) {
            this._clientSideBuffering = Boolean.parseBoolean(this.getProperties().getProperty("clientbuffering"));
        }
        if (this.getProperties().containsKey("writebuffersize")) {
            this._writeBufferSize = Long.parseLong(this.getProperties().getProperty("writebuffersize"));
        }
        this._columnFamily = this.getProperties().getProperty("columnfamily");
        if (this._columnFamily == null) {
            System.err.println("Error, must specify a columnfamily for HBase table");
            throw new DBException("No columnfamily specified");
        }
        this._columnFamilyBytes = Bytes.toBytes((String)this._columnFamily);
        String table = CoreWorkload.table;
        try {
            HTable ht = new HTable(config, table);
            HTableDescriptor hTableDescriptor = ht.getTableDescriptor();
        }
        catch (IOException e) {
            throw new DBException((Throwable)e);
        }
    }

    public void cleanup() throws DBException {
        Measurements _measurements = Measurements.getMeasurements();
        try {
            long st = System.nanoTime();
            if (this._hTable != null) {
                this._hTable.flushCommits();
            }
            long en = System.nanoTime();
            _measurements.measure("UPDATE", (int)((en - st) / 1000L));
        }
        catch (IOException e) {
            throw new DBException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHTable(String table) throws IOException {
        Object object = tableLock;
        synchronized (object) {
            this._hTable = new HTable(config, table);
            this._hTable.setAutoFlush(!this._clientSideBuffering, true);
            this._hTable.setWriteBufferSize(this._writeBufferSize);
        }
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        if (!this._table.equals(table)) {
            this._hTable = null;
            try {
                this.getHTable(table);
                this._table = table;
            }
            catch (IOException e) {
                System.err.println("Error accessing HBase table: " + e);
                return -1;
            }
        }
        Result r = null;
        try {
            if (this._debug) {
                System.out.println("Doing read from HBase columnfamily " + this._columnFamily);
                System.out.println("Doing read for key: " + key);
            }
            Get g = new Get(Bytes.toBytes((String)key));
            if (fields == null) {
                g.addFamily(this._columnFamilyBytes);
            } else {
                for (String field : fields) {
                    g.addColumn(this._columnFamilyBytes, Bytes.toBytes((String)field));
                }
            }
            r = this._hTable.get(g);
        }
        catch (IOException e) {
            System.err.println("Error doing get: " + e);
            return -1;
        }
        catch (ConcurrentModificationException e) {
            return -1;
        }
        for (KeyValue kv : r.raw()) {
            result.put(Bytes.toString((byte[])kv.getQualifier()), (ByteIterator)new ByteArrayByteIterator(kv.getValue()));
            if (!this._debug) continue;
            System.out.println("Result for field: " + Bytes.toString((byte[])kv.getQualifier()) + " is: " + Bytes.toString((byte[])kv.getValue()));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        if (!this._table.equals(table)) {
            this._hTable = null;
            try {
                this.getHTable(table);
                this._table = table;
            }
            catch (IOException e) {
                System.err.println("Error accessing HBase table: " + e);
                return -1;
            }
        }
        Scan s = new Scan(Bytes.toBytes((String)startkey));
        s.setCaching(recordcount);
        if (fields == null) {
            s.addFamily(this._columnFamilyBytes);
        } else {
            for (String field : fields) {
                s.addColumn(this._columnFamilyBytes, Bytes.toBytes((String)field));
            }
        }
        ResultScanner scanner = null;
        try {
            scanner = this._hTable.getScanner(s);
            int numResults = 0;
            Result rr = scanner.next();
            while (rr != null) {
                String key = Bytes.toString((byte[])rr.getRow());
                if (this._debug) {
                    System.out.println("Got scan result for key: " + key);
                }
                HashMap<String, ByteArrayByteIterator> rowResult = new HashMap<String, ByteArrayByteIterator>();
                for (KeyValue kv : rr.raw()) {
                    rowResult.put(Bytes.toString((byte[])kv.getQualifier()), new ByteArrayByteIterator(kv.getValue()));
                }
                result.add(rowResult);
                if (++numResults >= recordcount) {
                    break;
                }
                rr = scanner.next();
            }
        }
        catch (IOException e) {
            if (this._debug) {
                System.out.println("Error in getting/parsing scan result: " + e);
            }
            int n = -1;
            return n;
        }
        finally {
            scanner.close();
        }
        return 0;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        if (!this._table.equals(table)) {
            this._hTable = null;
            try {
                this.getHTable(table);
                this._table = table;
            }
            catch (IOException e) {
                System.err.println("Error accessing HBase table: " + e);
                return -1;
            }
        }
        if (this._debug) {
            System.out.println("Setting up put for key: " + key);
        }
        Put p = new Put(Bytes.toBytes((String)key));
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            byte[] value = entry.getValue().toArray();
            if (this._debug) {
                System.out.println("Adding field/value " + entry.getKey() + "/" + Bytes.toStringBinary((byte[])value) + " to put request");
            }
            p.add(this._columnFamilyBytes, Bytes.toBytes((String)entry.getKey()), value);
        }
        try {
            this._hTable.put(p);
        }
        catch (IOException e) {
            if (this._debug) {
                System.err.println("Error doing put: " + e);
            }
            return -1;
        }
        catch (ConcurrentModificationException e) {
            return -1;
        }
        return 0;
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        return this.update(table, key, values);
    }

    public int delete(String table, String key) {
        if (!this._table.equals(table)) {
            this._hTable = null;
            try {
                this.getHTable(table);
                this._table = table;
            }
            catch (IOException e) {
                System.err.println("Error accessing HBase table: " + e);
                return -1;
            }
        }
        if (this._debug) {
            System.out.println("Doing delete for key: " + key);
        }
        Delete d = new Delete(Bytes.toBytes((String)key));
        try {
            this._hTable.delete(d);
        }
        catch (IOException e) {
            if (this._debug) {
                System.err.println("Error doing delete: " + e);
            }
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Please specify a threadcount, columnfamily and operation count");
            System.exit(0);
        }
        int keyspace = 10000;
        int threadcount = Integer.parseInt(args[0]);
        final String columnfamily = args[1];
        final int opcount = Integer.parseInt(args[2]) / threadcount;
        Vector<1> allthreads = new Vector<1>();
        for (int i = 0; i < threadcount; ++i) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Random random = new Random();
                        HBaseClient cli = new HBaseClient();
                        Properties props = new Properties();
                        props.setProperty("columnfamily", columnfamily);
                        props.setProperty("debug", "true");
                        cli.setProperties(props);
                        cli.init();
                        long accum = 0L;
                        for (int i = 0; i < opcount; ++i) {
                            int keynum = random.nextInt(10000);
                            String key = "user" + keynum;
                            long st = System.currentTimeMillis();
                            HashSet<String> scanFields = new HashSet<String>();
                            scanFields.add("field1");
                            scanFields.add("field3");
                            Vector<HashMap<String, ByteIterator>> scanResults = new Vector<HashMap<String, ByteIterator>>();
                            int rescode = cli.scan("table1", "user2", 20, null, scanResults);
                            long en = System.currentTimeMillis();
                            accum += en - st;
                            if (rescode != 0) {
                                System.out.println("Error " + rescode + " for " + key);
                            }
                            if (i % 1 != 0) continue;
                            System.out.println(i + " operations, average latency: " + (double)accum / (double)i);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            allthreads.add(t);
        }
        long st = System.currentTimeMillis();
        for (Thread thread : allthreads) {
            thread.start();
        }
        for (Thread thread : allthreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {}
        }
        long en = System.currentTimeMillis();
        System.out.println("Throughput: " + 1000.0 * ((double)(opcount * threadcount) / (double)(en - st)) + " ops/sec");
    }
}

