/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.dyn.Coroutine;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.anno.JRubyClass;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.CoroutineFiberState;
import org.jruby.ext.fiber.Fiber;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Fiber"})
public class CoroutineFiber
extends Fiber {
    private volatile IRubyObject slot;
    private CoroutineFiberState state;
    private CoroutineFiber lastFiber;
    private Coroutine coro;
    private ThreadContext context;

    public CoroutineFiber(Ruby runtime2, RubyClass type2, Coroutine coro) {
        super(runtime2, type2);
        this.root = coro != null;
        this.coro = coro;
        assert (this.root ^ runtime2.getCurrentContext().getFiber() != null);
    }

    protected void initFiber(ThreadContext context) {
        final Ruby runtime2 = context.runtime;
        this.slot = runtime2.getNil();
        this.context = this.root ? context : ThreadContext.newContext(runtime2);
        this.context.setFiber(this);
        this.context.setThread(context.getThread());
        this.state = CoroutineFiberState.SUSPENDED_YIELD;
        if (this.coro == null) {
            this.coro = new Coroutine(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void run() {
                    try {
                        try {
                            CoroutineFiber.this.slot = CoroutineFiber.this.block.yieldArray(CoroutineFiber.this.context, CoroutineFiber.this.slot, null, null);
                        }
                        catch (JumpException.RetryJump rtry) {
                            CoroutineFiber.this.parent.raise(new IRubyObject[]{runtime2.newSyntaxError("Invalid retry").getException()}, Block.NULL_BLOCK);
                            Object var3_2 = null;
                            CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                            return;
                        }
                        catch (JumpException.BreakJump brk) {
                            CoroutineFiber.this.parent.raise(new IRubyObject[]{runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, runtime2.getNil(), "break from proc-closure").getException()}, Block.NULL_BLOCK);
                            Object var3_3 = null;
                            CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                            return;
                        }
                        catch (JumpException.ReturnJump ret) {
                            CoroutineFiber.this.parent.raise(new IRubyObject[]{runtime2.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, runtime2.getNil(), "unexpected return").getException()}, Block.NULL_BLOCK);
                            Object var3_4 = null;
                            CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                            return;
                        }
                        catch (RaiseException re) {
                            CoroutineFiber.this.parent.raise(new IRubyObject[]{re.getException()}, Block.NULL_BLOCK);
                            Object var3_5 = null;
                            CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                            return;
                        }
                        Object var3_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_6 = null;
                        CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                        throw throwable;
                    }
                    CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                }
            };
        }
    }

    protected IRubyObject resumeOrTransfer(ThreadContext context, IRubyObject arg2, boolean transfer2) {
        CoroutineFiber current2 = (CoroutineFiber)context.getFiber();
        this.slot = arg2;
        try {
            switch (this.state) {
                case SUSPENDED_YIELD: {
                    if (transfer2) {
                        current2.state = CoroutineFiberState.SUSPENDED_TRANSFER;
                    } else {
                        current2.state = CoroutineFiberState.SUSPENDED_RESUME;
                        this.lastFiber = (CoroutineFiber)context.getFiber();
                    }
                    this.state = CoroutineFiberState.RUNNING;
                    context.getRuntime().getThreadService().setCurrentContext(context);
                    context.setThread(context.getThread());
                    Coroutine.yieldTo(this.coro);
                    break;
                }
                case SUSPENDED_TRANSFER: {
                    if (!transfer2) {
                        throw context.getRuntime().newFiberError("double resume");
                    }
                    current2.state = CoroutineFiberState.SUSPENDED_TRANSFER;
                    this.state = CoroutineFiberState.RUNNING;
                    context.getRuntime().getThreadService().setCurrentContext(context);
                    context.setThread(context.getThread());
                    Coroutine.yieldTo(this.coro);
                    break;
                }
                case FINISHED: {
                    throw context.getRuntime().newFiberError("dead fiber called");
                }
                default: {
                    throw context.getRuntime().newFiberError("fiber in an invalid state: " + (Object)((Object)this.state));
                }
            }
        }
        catch (OutOfMemoryError oome) {
            if (oome.getMessage().equals("unable to create new native thread")) {
                throw context.runtime.newThreadError("too many threads, can't create a new Fiber");
            }
            throw oome;
        }
        context.pollThreadEvents();
        return this.slot;
    }

    public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
        assert (!this.root);
        if (this.lastFiber.state != CoroutineFiberState.SUSPENDED_RESUME) {
            if (this.lastFiber.state == CoroutineFiberState.SUSPENDED_TRANSFER) {
                throw context.getRuntime().newFiberError("a Fiber that was transferred to cannot yield");
            }
            throw context.getRuntime().newFiberError("invalid state of last Fiber at yield: " + (Object)((Object)this.lastFiber.state));
        }
        this.slot = arg2;
        this.state = CoroutineFiberState.SUSPENDED_YIELD;
        this.lastFiber.state = CoroutineFiberState.RUNNING;
        context.getRuntime().getThreadService().setCurrentContext(this.lastFiber.context);
        ThreadContext o = this.lastFiber.context;
        this.lastFiber.context.setThread(context.getThread());
        Coroutine.yieldTo(this.lastFiber.coro);
        context.pollThreadEvents();
        return this.slot;
    }
}

