/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.util.concurrent.locks.LockSupport;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.anno.JRubyClass;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.Fiber;
import org.jruby.ext.fiber.ThreadFiberState;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Fiber"})
public class ThreadFiber
extends Fiber {
    private volatile IRubyObject result;
    private Runnable runnable;
    private ThreadFiberState state = ThreadFiberState.NOT_STARTED;
    private ThreadFiber transferredFrom;
    private ThreadFiber transferredTo;
    private volatile Thread waiter = null;
    private volatile Thread fiber = null;

    public ThreadFiber(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected void initFiber(ThreadContext context) {
        final Ruby runtime2 = context.runtime;
        this.result = runtime2.getNil();
        this.waiter = Thread.currentThread();
        this.runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                ThreadContext context = runtime2.getCurrentContext();
                context.setFiber(ThreadFiber.this);
                ThreadFiber.this.fiber = Thread.currentThread();
                ThreadFiber.this.state = ThreadFiberState.YIELDED;
                LockSupport.unpark(ThreadFiber.this.waiter);
                LockSupport.park();
                try {
                    try {
                        ThreadFiber.this.result = ThreadFiber.this.block.yieldArray(context, ThreadFiber.this.result, null, null);
                    }
                    catch (JumpException.RetryJump rtry) {
                        ThreadFiber.this.parent.raise(new IRubyObject[]{runtime2.newSyntaxError("Invalid retry").getException()}, Block.NULL_BLOCK);
                        Object var4_3 = null;
                        ThreadFiber.this.state = ThreadFiberState.FINISHED;
                        LockSupport.unpark(ThreadFiber.this.waiter);
                        return;
                    }
                    catch (JumpException.BreakJump brk) {
                        ThreadFiber.this.parent.raise(new IRubyObject[]{runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, runtime2.getNil(), "break from proc-closure").getException()}, Block.NULL_BLOCK);
                        Object var4_4 = null;
                        ThreadFiber.this.state = ThreadFiberState.FINISHED;
                        LockSupport.unpark(ThreadFiber.this.waiter);
                        return;
                    }
                    catch (JumpException.ReturnJump ret) {
                        ThreadFiber.this.parent.raise(new IRubyObject[]{runtime2.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, runtime2.getNil(), "unexpected return").getException()}, Block.NULL_BLOCK);
                        Object var4_5 = null;
                        ThreadFiber.this.state = ThreadFiberState.FINISHED;
                        LockSupport.unpark(ThreadFiber.this.waiter);
                        return;
                    }
                    catch (RaiseException re) {
                        ThreadFiber.this.parent.raise(new IRubyObject[]{re.getException()}, Block.NULL_BLOCK);
                        Object var4_6 = null;
                        ThreadFiber.this.state = ThreadFiberState.FINISHED;
                        LockSupport.unpark(ThreadFiber.this.waiter);
                        return;
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    ThreadFiber.this.state = ThreadFiberState.FINISHED;
                    LockSupport.unpark(ThreadFiber.this.waiter);
                    throw throwable;
                }
                ThreadFiber.this.state = ThreadFiberState.FINISHED;
                LockSupport.unpark(ThreadFiber.this.waiter);
            }
        };
        context.runtime.getExecutor().execute(this.runnable);
        LockSupport.park();
    }

    protected IRubyObject resumeOrTransfer(ThreadContext context, IRubyObject arg2, boolean transfer2) {
        this.result = arg2;
        try {
            switch (this.state) {
                case NOT_STARTED: {
                    if (this.isRoot()) {
                        this.state = ThreadFiberState.RUNNING;
                        return this.result;
                    }
                    context.runtime.getExecutor().execute(this.runnable);
                }
                case YIELDED: {
                    if (!transfer2 && this.transferredTo != null) {
                        throw context.getRuntime().newFiberError("double resume");
                    }
                    if (transfer2) {
                        this.transferredFrom = (ThreadFiber)context.getFiber();
                        this.transferredFrom.transferredTo = this;
                    }
                    this.waiter = Thread.currentThread();
                    LockSupport.unpark(this.fiber);
                    LockSupport.park();
                    context.pollThreadEvents();
                    if (transfer2) {
                        if (!this.transferredFrom.isRoot()) {
                            this.result = this.transferredFrom.yield(context, this.result);
                        }
                        this.transferredFrom.transferredTo = null;
                        this.transferredFrom = null;
                    }
                    return this.result;
                }
                case RUNNING: {
                    if (transfer2 && context.getFiber() == this) {
                        return this.result;
                    }
                    throw context.getRuntime().newFiberError("double resume");
                }
                case FINISHED: {
                    throw context.getRuntime().newFiberError("dead fiber called");
                }
            }
            throw context.getRuntime().newFiberError("fiber in an unknown state");
        }
        catch (OutOfMemoryError oome) {
            if (oome.getMessage().equals("unable to create new native thread")) {
                throw context.runtime.newThreadError("too many threads, can't create a new Fiber");
            }
            throw oome;
        }
    }

    public IRubyObject yield(ThreadContext context, IRubyObject res) {
        this.result = res;
        this.state = ThreadFiberState.YIELDED;
        LockSupport.unpark(this.waiter);
        LockSupport.park();
        context.pollThreadEvents();
        this.state = ThreadFiberState.RUNNING;
        return this.result;
    }
}

